/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.Animator;
import java.awt.Point;
import javax.swing.JDialog;

public class DialogEarthquakeShaker {
    private JDialog myDialog;
    private Point myNaturalLocation;
    private long myStartTime;

    private DialogEarthquakeShaker(JDialog dialog) {
        this.myDialog = dialog;
    }

    public void startShake() {
        this.myNaturalLocation = this.myDialog.getLocation();
        this.myStartTime = System.currentTimeMillis();
        new Animator("EarthQuake", 10, 70, true){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                long elapsed = System.currentTimeMillis() - DialogEarthquakeShaker.this.myStartTime;
                double waveOffset = (double)(elapsed % 70L) / 70.0;
                double angle = waveOffset * 2.0 * Math.PI;
                int shakenX = (int)(Math.sin(angle) * 10.0 + (double)((DialogEarthquakeShaker)DialogEarthquakeShaker.this).myNaturalLocation.x);
                DialogEarthquakeShaker.this.myDialog.setLocation(shakenX, ((DialogEarthquakeShaker)DialogEarthquakeShaker.this).myNaturalLocation.y);
                DialogEarthquakeShaker.this.myDialog.repaint();
                if (elapsed > 150L) {
                    this.suspend();
                    DialogEarthquakeShaker.this.myDialog.setLocation(DialogEarthquakeShaker.this.myNaturalLocation);
                    DialogEarthquakeShaker.this.myDialog.repaint();
                    Disposer.dispose((Disposable)this);
                }
            }
        }.resume();
    }

    public static void shake(JDialog dialog) {
        new DialogEarthquakeShaker(dialog).startShake();
    }
}

