/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SecurityDetector
extends Detector
implements Detector.XmlScanner,
Detector.JavaScanner {
    private static final Implementation IMPLEMENTATION_MANIFEST = new Implementation(SecurityDetector.class, Scope.MANIFEST_SCOPE);
    private static final Implementation IMPLEMENTATION_JAVA = new Implementation(SecurityDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue EXPORTED_SERVICE = Issue.create("ExportedService", "Exported service does not require permission", "Exported services (services which either set `exported=true` or contain an intent-filter and do not specify `exported=false`) should define a permission that an entity must have in order to launch the service or bind to it. Without this, any application can use this service.", Category.SECURITY, 5, Severity.WARNING, IMPLEMENTATION_MANIFEST);
    public static final Issue EXPORTED_PROVIDER = Issue.create("ExportedContentProvider", "Content provider does not require permission", "Content providers are exported by default and any application on the system can potentially use them to read and write data. If the content provider provides access to sensitive data, it should be protected by specifying `export=false` in the manifest or by protecting it with a permission that can be granted to other applications.", Category.SECURITY, 5, Severity.WARNING, IMPLEMENTATION_MANIFEST);
    public static final Issue EXPORTED_RECEIVER = Issue.create("ExportedReceiver", "Receiver does not require permission", "Exported receivers (receivers which either set `exported=true` or contain an intent-filter and do not specify `exported=false`) should define a permission that an entity must have in order to launch the receiver or bind to it. Without this, any application can use this receiver.", Category.SECURITY, 5, Severity.WARNING, IMPLEMENTATION_MANIFEST);
    public static final Issue OPEN_PROVIDER = Issue.create("GrantAllUris", "Content provider shares everything", "The `<grant-uri-permission>` element allows specific paths to be shared. This detector checks for a path URL of just '/' (everything), which is probably not what you want; you should limit access to a subset.", Category.SECURITY, 7, Severity.WARNING, IMPLEMENTATION_MANIFEST);
    public static final Issue SET_READABLE = Issue.create("SetWorldReadable", "`File.setReadable()` used to make file world-readable", "Setting files world-readable is very dangerous, and likely to cause security holes in applications. It is strongly discouraged; instead, applications should use more formal mechanisms for interactions such as `ContentProvider`, `BroadcastReceiver`, and `Service`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION_JAVA);
    public static final Issue SET_WRITABLE = Issue.create("SetWorldWritable", "`File.setWritable()` used to make file world-writable", "Setting files world-writable is very dangerous, and likely to cause security holes in applications. It is strongly discouraged; instead, applications should use more formal mechanisms for interactions such as `ContentProvider`, `BroadcastReceiver`, and `Service`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION_JAVA);
    public static final Issue WORLD_WRITEABLE = Issue.create("WorldWriteableFiles", "`openFileOutput()` or similar call passing `MODE_WORLD_WRITEABLE`", "There are cases where it is appropriate for an application to write world writeable files, but these should be reviewed carefully to ensure that they contain no private data, and that if the file is modified by a malicious application it does not trick or compromise your application.", Category.SECURITY, 4, Severity.WARNING, IMPLEMENTATION_JAVA);
    public static final Issue WORLD_READABLE = Issue.create("WorldReadableFiles", "`openFileOutput()` or similar call passing `MODE_WORLD_READABLE`", "There are cases where it is appropriate for an application to write world readable files, but these should be reviewed carefully to ensure that they contain no private data that is leaked to other applications.", Category.SECURITY, 4, Severity.WARNING, IMPLEMENTATION_JAVA);
    private static final String FILE_CLASS = "java.io.File";

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("service", "grant-uri-permission", "provider", "activity", "receiver");
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        String tag = element.getTagName();
        if (tag.equals("service")) {
            SecurityDetector.checkService(context, element);
        } else if (tag.equals("grant-uri-permission")) {
            SecurityDetector.checkGrantPermission(context, element);
        } else if (tag.equals("provider")) {
            SecurityDetector.checkProvider(context, element);
        } else if (tag.equals("receiver")) {
            SecurityDetector.checkReceiver(context, element);
        }
    }

    public static boolean getExported(Element element) {
        String exportValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
        if (exportValue != null && !exportValue.isEmpty()) {
            return Boolean.valueOf(exportValue);
        }
        for (Element child : LintUtils.getChildren(element)) {
            if (!child.getTagName().equals("intent-filter")) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnprotectedByPermission(Element element) {
        org.w3c.dom.Node parent;
        String permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
        if ((permission == null || permission.isEmpty()) && (parent = element.getParentNode()).getNodeType() == 1 && parent.getNodeName().equals("application")) {
            Element application = (Element)parent;
            permission = application.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
            return permission == null || permission.isEmpty();
        }
        return false;
    }

    private static boolean isWearableBindListener(Element element) {
        for (Element child : LintUtils.getChildren(element)) {
            if (!child.getTagName().equals("intent-filter")) continue;
            for (Element innerChild : LintUtils.getChildren(child)) {
                String name;
                if (!innerChild.getTagName().equals("action") || !"com.google.android.gms.wearable.BIND_LISTENER".equals(name = innerChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isStandardReceiver(Element element) {
        String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if ("com.google.android.gms.tagmanager.InstallReferrerReceiver".equals(name)) {
            return true;
        }
        for (Element child : LintUtils.getChildren(element)) {
            if (!child.getTagName().equals("intent-filter")) continue;
            for (Element innerChild : LintUtils.getChildren(child)) {
                if (!innerChild.getTagName().equals("action")) continue;
                String categoryString = innerChild.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                return categoryString.startsWith("android.");
            }
        }
        return false;
    }

    private static void checkReceiver(XmlContext context, Element element) {
        if (SecurityDetector.getExported(element) && SecurityDetector.isUnprotectedByPermission(element) && !SecurityDetector.isStandardReceiver(element)) {
            context.report(EXPORTED_RECEIVER, element, context.getLocation(element), "Exported receiver does not require permission");
        }
    }

    private static void checkService(XmlContext context, Element element) {
        if (SecurityDetector.getExported(element) && SecurityDetector.isUnprotectedByPermission(element) && !SecurityDetector.isWearableBindListener(element)) {
            context.report(EXPORTED_SERVICE, element, context.getLocation(element), "Exported service does not require permission");
        }
    }

    private static void checkGrantPermission(XmlContext context, Element element) {
        Attr path = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "path");
        Attr prefix = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "pathPrefix");
        Attr pattern = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "pathPattern");
        String msg = "Content provider shares everything; this is potentially dangerous.";
        if (path != null && path.getValue().equals("/")) {
            context.report(OPEN_PROVIDER, path, context.getLocation(path), msg);
        }
        if (prefix != null && prefix.getValue().equals("/")) {
            context.report(OPEN_PROVIDER, prefix, context.getLocation(prefix), msg);
        }
        if (pattern != null && pattern.getValue().equals("/")) {
            context.report(OPEN_PROVIDER, pattern, context.getLocation(pattern), msg);
        }
    }

    private static void checkProvider(XmlContext context, Element element) {
        String permission;
        String exportValue = element.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
        boolean exported = true;
        if (exportValue != null && !exportValue.isEmpty()) {
            exported = Boolean.valueOf(exportValue);
        }
        if (exported && ((permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "readPermission")) == null || permission.isEmpty()) && ((permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "writePermission")) == null || permission.isEmpty()) && ((permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "permission")) == null || permission.isEmpty())) {
            boolean hasPermission = false;
            for (Element child : LintUtils.getChildren(element)) {
                String tag = child.getTagName();
                if (!tag.equals("path-permission")) continue;
                hasPermission = true;
                break;
            }
            if (!hasPermission) {
                context.report(EXPORTED_PROVIDER, element, context.getLocation(element), "Exported content providers can provide access to potentially sensitive data");
            }
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        ArrayList<String> values = new ArrayList<String>(3);
        values.add("openFileOutput");
        values.add("getSharedPreferences");
        values.add("getDir");
        values.add("setReadable");
        values.add("setWritable");
        return values;
    }

    @Override
    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (resolved instanceof JavaParser.ResolvedMethod) {
            JavaParser.ResolvedClass resolvedClass = ((JavaParser.ResolvedMethod)resolved).getContainingClass();
            String methodName = node.astName().astValue();
            if (resolvedClass.isSubclassOf(FILE_CLASS, false)) {
                if ("setReadable".equals(methodName)) {
                    if (node.astArguments().size() == 2 && Boolean.TRUE.equals(ConstantEvaluator.evaluate(context, node.astArguments().first())) && Boolean.FALSE.equals(ConstantEvaluator.evaluate(context, node.astArguments().last()))) {
                        context.report(SET_READABLE, (Node)node, context.getLocation((Node)node), "Setting file permissions to world-readable can be risky, review carefully");
                    }
                    return;
                }
                if ("setWritable".equals(methodName)) {
                    if (node.astArguments().size() == 2 && Boolean.TRUE.equals(ConstantEvaluator.evaluate(context, node.astArguments().first())) && Boolean.FALSE.equals(ConstantEvaluator.evaluate(context, node.astArguments().last()))) {
                        context.report(SET_WRITABLE, (Node)node, context.getLocation((Node)node), "Setting file permissions to world-writable can be risky, review carefully");
                    }
                    return;
                }
            }
        }
        StrictListAccessor args = node.astArguments();
        for (Expression arg : args) {
            arg.accept(visitor);
        }
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext context) {
        return new IdentifierVisitor(context);
    }

    private static class IdentifierVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public IdentifierVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitIdentifier(Identifier node) {
            if ("MODE_WORLD_WRITEABLE".equals(node.astValue())) {
                Location location = this.mContext.getLocation((Node)node);
                this.mContext.report(WORLD_WRITEABLE, (Node)node, location, "Using `MODE_WORLD_WRITEABLE` when creating files can be risky, review carefully");
            } else if ("MODE_WORLD_READABLE".equals(node.astValue())) {
                Location location = this.mContext.getLocation((Node)node);
                this.mContext.report(WORLD_READABLE, (Node)node, location, "Using `MODE_WORLD_READABLE` when creating files can be risky, review carefully");
            }
            return false;
        }
    }
}

