/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class UpgradeFormatDialog
extends DialogWrapper {
    private ButtonGroup formatGroup = new ButtonGroup();
    private List<JRadioButton> formatButtons = new ArrayList<JRadioButton>();
    private JBLoadingPanel myLoadingPanel;
    protected File myPath;

    public UpgradeFormatDialog(Project project, File path, boolean canBeParent) {
        this(project, path, canBeParent, true);
    }

    protected UpgradeFormatDialog(Project project, File path, boolean canBeParent, boolean initHere) {
        super(project, canBeParent);
        this.myPath = path;
        this.setResizable(false);
        this.setTitle(SvnBundle.message("dialog.upgrade.wcopy.format.title", new Object[0]));
        if (initHere) {
            this.init();
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "createActions"));
        }
        return actionArray;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn.upgradeDialog";
    }

    public void setData(@NotNull WorkingCopyFormat selectedFormat) {
        if (selectedFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFormat", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "setData"));
        }
        for (JRadioButton button : this.formatButtons) {
            if (selectedFormat != UpgradeFormatDialog.getFormat(button)) continue;
            button.setSelected(true);
            break;
        }
    }

    public void setSupported(@NotNull Collection<WorkingCopyFormat> supported) {
        if (supported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supported", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "setSupported"));
        }
        for (JRadioButton button : this.formatButtons) {
            button.setEnabled(supported.contains((Object)UpgradeFormatDialog.getFormat(button)));
        }
    }

    public void startLoading() {
        this.enableFormatButtons(false);
        this.getOKAction().setEnabled(false);
        this.myLoadingPanel.startLoading();
    }

    private void enableFormatButtons(boolean enabled) {
        for (JRadioButton button : this.formatButtons) {
            button.setEnabled(enabled);
        }
    }

    public void stopLoading() {
        this.getOKAction().setEnabled(true);
        this.myLoadingPanel.stopLoading();
    }

    protected String getTopMessage(String label) {
        return SvnBundle.message("label.configure." + label + ".label", ApplicationNamesInfo.getInstance().getFullProductName());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = new Insets(2, 2, 2, 2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        File adminPath = new File(this.myPath, SVNFileUtil.getAdminDirectoryName());
        boolean adminPathIsDirectory = adminPath.isDirectory();
        String label = this.getMiddlePartOfResourceKey(adminPathIsDirectory);
        JLabel topLabel = new JLabel(this.getTopMessage(label));
        topLabel.setUI((LabelUI)new MultiLineLabelUI());
        panel.add((Component)topLabel, gb);
        ++gb.gridy;
        this.registerFormat(WorkingCopyFormat.ONE_DOT_SIX, label, panel, gb);
        this.registerFormat(WorkingCopyFormat.ONE_DOT_SEVEN, label, panel, gb);
        this.registerFormat(WorkingCopyFormat.ONE_DOT_EIGHT, label, panel, gb);
        JPanel auxiliaryPanel = this.getBottomAuxiliaryPanel();
        if (auxiliaryPanel != null) {
            panel.add((Component)auxiliaryPanel, gb);
            ++gb.gridy;
        }
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.myLoadingPanel.add((Component)panel, (Object)"Center");
        return this.myLoadingPanel;
    }

    private void registerFormat(@NotNull WorkingCopyFormat format, @NotNull String label, @NotNull JPanel panel, @NotNull GridBagConstraints gb) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "registerFormat"));
        }
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "registerFormat"));
        }
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "registerFormat"));
        }
        if (gb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gb", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "registerFormat"));
        }
        JRadioButton button = new JRadioButton(SvnBundle.message("radio.configure." + label + ".auto." + UpgradeFormatDialog.getKey(format) + "format", new Object[0]));
        button.putClientProperty("format", (Object)format);
        panel.add((Component)button, gb);
        ++gb.gridy;
        this.formatGroup.add(button);
        this.formatButtons.add(button);
    }

    private static String getKey(@NotNull WorkingCopyFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "getKey"));
        }
        return String.format("%d%d", format.getVersion().major, format.getVersion().minor);
    }

    @Nullable
    protected JPanel getBottomAuxiliaryPanel() {
        return null;
    }

    protected String getMiddlePartOfResourceKey(boolean adminPathIsDirectory) {
        return !adminPathIsDirectory ? "create" : "upgrade";
    }

    protected boolean showHints() {
        return true;
    }

    @NotNull
    private static WorkingCopyFormat getFormat(@NotNull JRadioButton button) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "getFormat"));
        }
        Object format = button.getClientProperty("format");
        WorkingCopyFormat workingCopyFormat = format instanceof WorkingCopyFormat ? (WorkingCopyFormat)((Object)format) : WorkingCopyFormat.UNKNOWN;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "getFormat"));
        }
        return workingCopyFormat;
    }

    @NotNull
    public WorkingCopyFormat getUpgradeMode() {
        WorkingCopyFormat result = WorkingCopyFormat.UNKNOWN;
        for (JRadioButton button : this.formatButtons) {
            if (!button.isSelected()) continue;
            result = UpgradeFormatDialog.getFormat(button);
            break;
        }
        WorkingCopyFormat workingCopyFormat = result;
        if (workingCopyFormat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/UpgradeFormatDialog", "getUpgradeMode"));
        }
        return workingCopyFormat;
    }
}

