/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.model.Unmanaged;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorExtractionContext;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructSchemaExtractionStrategySupport
implements ModelSchemaExtractionStrategy {
    private final ModelSchemaAspectExtractor aspectExtractor;

    protected StructSchemaExtractionStrategySupport(ModelSchemaAspectExtractor aspectExtractor) {
        this.aspectExtractor = aspectExtractor;
    }

    protected abstract boolean isTarget(ModelType<?> var1);

    public <R> void extract(ModelSchemaExtractionContext<R> extractionContext) {
        ModelType<R> type = extractionContext.getType();
        if (!this.isTarget(type)) {
            return;
        }
        this.validateTypeHierarchy(extractionContext, type);
        List<ModelPropertyExtractionResult<?>> propertyExtractionResults = this.extractPropertySchemas(extractionContext, (Multimap<String, Method>)ModelSchemaUtils.getCandidateMethods(type.getRawClass()));
        List<ModelSchemaAspect> aspects = this.aspectExtractor.extract(extractionContext, propertyExtractionResults);
        ModelSchema<R> schema = this.createSchema(extractionContext, propertyExtractionResults, aspects);
        for (ModelPropertyExtractionResult<?> propertyResult : propertyExtractionResults) {
            this.toPropertyExtractionContext(extractionContext, propertyResult);
        }
        extractionContext.found(schema);
    }

    private <R, P> void toPropertyExtractionContext(ModelSchemaExtractionContext<R> parentContext, ModelPropertyExtractionResult<P> propertyResult) {
        ModelProperty<P> property = propertyResult.getProperty();
        parentContext.child(property.getType(), this.propertyDescription(parentContext, property), this.createPropertyValidator(parentContext, propertyResult));
    }

    private <R> List<ModelPropertyExtractionResult<?>> extractPropertySchemas(ModelSchemaExtractionContext<R> extractionContext, Multimap<String, Method> methodsByName) {
        ArrayList results = Lists.newArrayList();
        HashSet handledMethods = Sets.newHashSet();
        ArrayList methodNames = Lists.newArrayList((Iterable)methodsByName.keySet());
        Collections.sort(methodNames);
        HashSet skippedMethodNames = Sets.newHashSet();
        for (String methodName : methodNames) {
            PropertyAccessorExtractionContext getterContext;
            ModelPropertyExtractionResult<R> result;
            String isGetterName;
            Collection<Method> isGetterMethods;
            int getterPrefixLen;
            if (skippedMethodNames.contains(methodName)) continue;
            Collection<Method> methods = methodsByName.get((Object)methodName);
            List<Method> overloadedMethods = ModelSchemaUtils.getOverloadedMethods(methods);
            if (overloadedMethods != null) {
                this.handleOverloadedMethods(extractionContext, overloadedMethods);
                if ((methods = StructSchemaExtractionStrategySupport.filterGetterMethods(methods)).isEmpty()) continue;
            }
            if ((getterPrefixLen = StructSchemaExtractionStrategySupport.getterPrefixLength(methodName)) < 0) continue;
            Method mostSpecificGetter = ModelSchemaUtils.findMostSpecificMethod(methods);
            char getterPropertyNameFirstChar = methodName.charAt(getterPrefixLen);
            if (!Character.isUpperCase(getterPropertyNameFirstChar)) {
                this.handleInvalidGetter(extractionContext, mostSpecificGetter, String.format("the %s character of the getter method name must be an uppercase character", getterPrefixLen == 2 ? "3rd" : "4th"));
                continue;
            }
            String propertyNameCapitalized = methodName.substring(getterPrefixLen);
            String propertyName = StringUtils.uncapitalize((String)propertyNameCapitalized);
            String setterName = "set" + propertyNameCapitalized;
            Collection setterMethods = methodsByName.get((Object)setterName);
            PropertyAccessorExtractionContext setterContext = !setterMethods.isEmpty() ? new PropertyAccessorExtractionContext(setterMethods) : null;
            String prefix = methodName.substring(0, getterPrefixLen);
            Iterable<Method> getterMethods = methods;
            if (prefix.equals("get") && !(isGetterMethods = methodsByName.get((Object)(isGetterName = "is" + propertyNameCapitalized))).isEmpty()) {
                List<Method> overloadedIsGetterMethods = ModelSchemaUtils.getOverloadedMethods(isGetterMethods);
                if (overloadedIsGetterMethods != null) {
                    this.handleOverloadedMethods(extractionContext, overloadedIsGetterMethods);
                    isGetterMethods = StructSchemaExtractionStrategySupport.filterGetterMethods(isGetterMethods);
                }
                if (!isGetterMethods.isEmpty()) {
                    Method mostSpecificIsGetter = ModelSchemaUtils.findMostSpecificMethod((Iterable<Method>)isGetterMethods);
                    if (mostSpecificGetter.getReturnType() != Boolean.TYPE || mostSpecificIsGetter.getReturnType() != Boolean.TYPE) {
                        this.handleInvalidGetter(extractionContext, mostSpecificIsGetter, String.format("property '%s' has both '%s()' and '%s()' getters, but they don't both return a boolean", propertyName, isGetterName, methodName));
                        continue;
                    }
                    getterMethods = Iterables.concat(getterMethods, isGetterMethods);
                    skippedMethodNames.add(isGetterName);
                }
            }
            if ((result = this.extractPropertySchema(extractionContext, propertyName, getterContext = new PropertyAccessorExtractionContext(getterMethods), setterContext, getterPrefixLen)) == null) continue;
            results.add(result);
            handledMethods.addAll(getterContext.getDeclaringMethods());
            if (setterContext == null) continue;
            handledMethods.addAll(setterContext.getDeclaringMethods());
        }
        this.validateAllNecessaryMethodsHandled(extractionContext, methodsByName.values(), handledMethods);
        return results;
    }

    private static Collection<Method> filterGetterMethods(Collection<Method> methods) {
        return Lists.newArrayList((Iterable)Iterables.filter(methods, (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                return method.getParameterTypes().length == 0;
            }
        }));
    }

    private static int getterPrefixLength(String methodName) {
        if (methodName.startsWith("get") && !"get".equals(methodName)) {
            return 3;
        }
        if (methodName.startsWith("is") && !"is".equals(methodName)) {
            return 2;
        }
        return -1;
    }

    @Nullable
    private <R> ModelPropertyExtractionResult<R> extractPropertySchema(final ModelSchemaExtractionContext<?> extractionContext, String propertyName, PropertyAccessorExtractionContext getterContext, PropertyAccessorExtractionContext setterContext, int getterPrefixLen) {
        WeaklyTypeReferencingMethod<?, Void> setterRef;
        Method mostSpecificGetter = getterContext.getMostSpecificDeclaration();
        if (mostSpecificGetter.getParameterTypes().length != 0) {
            this.handleInvalidGetter(extractionContext, mostSpecificGetter, "getter methods cannot take parameters");
            return null;
        }
        if (mostSpecificGetter.getReturnType() != Boolean.TYPE && getterPrefixLen == 2) {
            this.handleInvalidGetter(extractionContext, mostSpecificGetter, "getter method name must start with 'get'");
            return null;
        }
        ModelProperty.StateManagementType stateManagementType = this.determineStateManagementType(extractionContext, getterContext);
        final ModelType returnType = ModelType.returnType(mostSpecificGetter);
        if (setterContext != null) {
            this.validateSetter(extractionContext, returnType, getterContext, setterContext);
            setterRef = WeaklyTypeReferencingMethod.of(extractionContext.getType(), ModelType.of(Void.TYPE), setterContext.getMostSpecificDeclaration());
        } else {
            setterRef = null;
        }
        ImmutableSet declaringClasses = ImmutableSet.copyOf((Iterable)Iterables.transform(getterContext.getDeclaringMethods(), (Function)new Function<Method, ModelType<?>>(){

            public ModelType<?> apply(Method input) {
                return ModelType.of(input.getDeclaringClass());
            }
        }));
        ArrayList getterRefs = Lists.newArrayList((Iterable)Iterables.transform(getterContext.getGetters(), (Function)new Function<Method, WeaklyTypeReferencingMethod<?, R>>(){

            public WeaklyTypeReferencingMethod<?, R> apply(@Nullable Method getter) {
                return WeaklyTypeReferencingMethod.of(extractionContext.getType(), returnType, getter);
            }
        }));
        boolean declaredAsHavingUnmanagedType = getterContext.getAnnotation(Unmanaged.class) != null;
        return new ModelPropertyExtractionResult(new ModelProperty(returnType, propertyName, stateManagementType, (Set<ModelType<?>>)declaringClasses, getterRefs, setterRef, declaredAsHavingUnmanagedType), getterContext, setterContext);
    }

    protected abstract void validateAllNecessaryMethodsHandled(ModelSchemaExtractionContext<?> var1, Collection<Method> var2, Set<Method> var3);

    protected abstract <R> void validateTypeHierarchy(ModelSchemaExtractionContext<R> var1, ModelType<R> var2);

    protected abstract void handleInvalidGetter(ModelSchemaExtractionContext<?> var1, Method var2, String var3);

    protected abstract void handleOverloadedMethods(ModelSchemaExtractionContext<?> var1, Collection<Method> var2);

    protected abstract ModelProperty.StateManagementType determineStateManagementType(ModelSchemaExtractionContext<?> var1, PropertyAccessorExtractionContext var2);

    protected abstract <R> ModelSchema<R> createSchema(ModelSchemaExtractionContext<R> var1, Iterable<ModelPropertyExtractionResult<?>> var2, Iterable<ModelSchemaAspect> var3);

    protected abstract <P> Action<ModelSchema<P>> createPropertyValidator(ModelSchemaExtractionContext<?> var1, ModelPropertyExtractionResult<P> var2);

    private String propertyDescription(ModelSchemaExtractionContext<?> parentContext, ModelProperty<?> property) {
        if (property.getDeclaredBy().size() == 1 && property.getDeclaredBy().contains(parentContext.getType())) {
            return String.format("property '%s'", property.getName());
        }
        ImmutableSortedSet declaredBy = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(property.getDeclaredBy(), (Function)Functions.toStringFunction()));
        return String.format("property '%s' declared by %s", property.getName(), Joiner.on((String)", ").join((Iterable)declaredBy));
    }

    protected abstract void validateSetter(ModelSchemaExtractionContext<?> var1, ModelType<?> var2, PropertyAccessorExtractionContext var3, PropertyAccessorExtractionContext var4);
}

