/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.CommonBundle;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSerializedXmlAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.actions.ShowSerializedXmlAction");

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(ShowSerializedXmlAction.getEventProject((AnActionEvent)e) != null && e.getData(CommonDataKeys.PSI_FILE) != null && e.getData(CommonDataKeys.EDITOR) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        PsiClass psiClass = ShowSerializedXmlAction.getPsiClass(e);
        if (psiClass == null) {
            return;
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null || virtualFile == null) {
            return;
        }
        final String className = ClassUtil.getJVMClassName((PsiClass)psiClass);
        Project project = ShowSerializedXmlAction.getEventProject((AnActionEvent)e);
        CompilerManager.getInstance((Project)project).make((CompileScope)new FileSetCompileScope(Collections.singletonList(virtualFile), new Module[]{module}), new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (aborted || errors > 0) {
                    return;
                }
                ShowSerializedXmlAction.generateAndShowXml(module, className);
            }
        });
    }

    private static void generateAndShowXml(Module module, String className) {
        Element element;
        Object o;
        Class<?> aClass;
        ArrayList<URL> urls = new ArrayList<URL>();
        List list = OrderEnumerator.orderEntries((Module)module).recursively().runtimeOnly().getPathsList().getPathList();
        for (String path : list) {
            try {
                urls.add(new File(FileUtil.toSystemIndependentName((String)path)).toURI().toURL());
            }
            catch (MalformedURLException e1) {
                LOG.info((Throwable)e1);
            }
        }
        Project project = module.getProject();
        UrlClassLoader loader = UrlClassLoader.build().urls(urls).parent(XmlSerializer.class.getClassLoader()).get();
        try {
            aClass = Class.forName(className, true, (ClassLoader)loader);
        }
        catch (ClassNotFoundException e) {
            Messages.showErrorDialog((Project)project, (String)("Cannot find class '" + className + "'"), (String)CommonBundle.getErrorTitle());
            LOG.info((Throwable)e);
            return;
        }
        try {
            o = new SampleObjectGenerator().createValue(aClass, (FList<Type>)FList.emptyList());
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project, (String)("Cannot generate class '" + className + "': " + e.getMessage()), (String)CommonBundle.getErrorTitle());
            LOG.info((Throwable)e);
            return;
        }
        try {
            element = XmlSerializer.serialize((Object)o);
        }
        catch (XmlSerializationException e) {
            LOG.info((Throwable)e);
            Throwable cause = e.getCause();
            Messages.showErrorDialog((Project)project, (String)(e.getMessage() + (cause != null ? ": " + cause.getMessage() : "")), (String)CommonBundle.getErrorTitle());
            return;
        }
        String text = JDOMUtil.writeElement((Element)element, (String)"\n");
        Messages.showIdeaMessageDialog((Project)project, (String)text, (String)("Serialized XML for '" + className + "'"), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getInformationIcon(), null);
    }

    @Nullable
    private static PsiClass getPsiClass(AnActionEvent e) {
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null || psiFile == null) {
            return null;
        }
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    private static class SampleObjectGenerator {
        private int myNum;

        private SampleObjectGenerator() {
        }

        @Nullable
        public Object createValue(Type type, FList<Type> types) throws Exception {
            return this.createValue(type, types, Collections.emptyList());
        }

        @Nullable
        public Object createValue(Type type, FList<Type> types, List<Type> elementTypes) throws Exception {
            Class valueClass;
            if (types.contains((Object)type)) {
                return null;
            }
            FList processedTypes = types.prepend((Object)type);
            Class clazz = valueClass = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
            if (String.class.isAssignableFrom(valueClass)) {
                return "value" + this.myNum++;
            }
            if (Byte.TYPE.isAssignableFrom(valueClass) || Byte.class.isAssignableFrom(valueClass) || Short.TYPE.isAssignableFrom(valueClass) || Short.class.isAssignableFrom(valueClass) || Integer.TYPE.isAssignableFrom(valueClass) || Integer.class.isAssignableFrom(valueClass) || Long.TYPE.isAssignableFrom(valueClass) || Long.class.isAssignableFrom(valueClass)) {
                return this.myNum++ % 127;
            }
            if (Double.TYPE.isAssignableFrom(valueClass) || Double.class.isAssignableFrom(valueClass) || Float.TYPE.isAssignableFrom(valueClass) || Float.class.isAssignableFrom(valueClass)) {
                return 0.5 + (double)this.myNum++;
            }
            if (Boolean.TYPE.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass)) {
                return this.myNum++ % 2 == 0;
            }
            if (valueClass.isEnum()) {
                T[] constants = valueClass.getEnumConstants();
                return constants[this.myNum++ % constants.length];
            }
            if (Collection.class.isAssignableFrom(valueClass) && type instanceof ParameterizedType) {
                return this.createCollection(valueClass, (ParameterizedType)type, (FList<Type>)processedTypes, elementTypes);
            }
            if (Map.class.isAssignableFrom(valueClass) && type instanceof ParameterizedType) {
                return this.createMap((ParameterizedType)type, (FList<Type>)processedTypes);
            }
            if (valueClass.isArray()) {
                return this.createArray(valueClass, (FList<Type>)processedTypes, elementTypes);
            }
            if (Element.class.isAssignableFrom(valueClass)) {
                return new Element("customElement" + this.myNum++).setAttribute("attribute", "value" + this.myNum++).addContent(new Element("child" + this.myNum++));
            }
            return this.createObject(valueClass, (FList<Type>)processedTypes);
        }

        @NotNull
        public Object createObject(@NotNull Class<?> aClass, FList<Type> processedTypes) throws Exception {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/idea/devkit/actions/ShowSerializedXmlAction$SampleObjectGenerator", "createObject"));
            }
            Object o = ReflectionUtil.newInstance(aClass);
            for (MutableAccessor accessor : XmlSerializerUtil.getAccessors(aClass)) {
                List<Type> elementTypes;
                com.intellij.util.xmlb.annotations.AbstractCollection abstractCollection = (com.intellij.util.xmlb.annotations.AbstractCollection)accessor.getAnnotation(com.intellij.util.xmlb.annotations.AbstractCollection.class);
                List<Type> list = elementTypes = abstractCollection != null ? Arrays.asList(abstractCollection.elementTypes()) : Collections.emptyList();
                Object value = this.createValue(accessor.getGenericType(), processedTypes, elementTypes);
                if (value == null) continue;
                accessor.set(o, value);
            }
            Object object = o;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/actions/ShowSerializedXmlAction$SampleObjectGenerator", "createObject"));
            }
            return object;
        }

        @Nullable
        private Object createArray(Class<?> valueClass, FList<Type> processedTypes, List<Type> elementTypes) throws Exception {
            Object[] array = (Object[])Array.newInstance(valueClass.getComponentType(), Math.max(elementTypes.size(), 2));
            for (int i = 0; i < array.length; ++i) {
                Class<?> type = elementTypes.isEmpty() ? valueClass.getComponentType() : elementTypes.get(i % elementTypes.size());
                array[i] = this.createValue(type, processedTypes);
            }
            return array;
        }

        private Object createMap(ParameterizedType type, FList<Type> processedTypes) throws Exception {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < 2; ++i) {
                Object key = this.createValue(keyType, processedTypes);
                Object value = this.createValue(valueType, processedTypes);
                if (key == null || value == null) continue;
                map.put(key, value);
            }
            return map;
        }

        @Nullable
        private Object createCollection(Class<?> aClass, ParameterizedType genericType, FList<Type> processedTypes, List<Type> elementTypes) throws Exception {
            AbstractCollection o;
            if (List.class.isAssignableFrom(aClass)) {
                o = new ArrayList();
            } else if (Set.class.isAssignableFrom(aClass)) {
                o = new HashSet();
            } else {
                return null;
            }
            Type elementClass = genericType.getActualTypeArguments()[0];
            for (int i = 0; i < Math.max(elementTypes.size(), 2); ++i) {
                Type type = elementTypes.isEmpty() ? elementClass : elementTypes.get(i % elementTypes.size());
                Object item = this.createValue(type, processedTypes);
                if (item == null) continue;
                o.add(item);
            }
            return o;
        }
    }
}

