/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.JBColor;
import org.jetbrains.annotations.NotNull;

public class ConvertToJBColorQuickFix
extends LocalQuickFixBase {
    public ConvertToJBColorQuickFix() {
        super("Convert to JBColor");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToJBColorQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/quickfix/ConvertToJBColorQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        String newJBColor = String.format("new %s(%s, new java.awt.Color())", JBColor.class.getName(), element.getText());
        PsiExpression expression = factory.createExpressionFromText(newJBColor, element.getContext());
        PsiElement newElement = element.replace((PsiElement)expression);
        PsiElement el = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
        int offset = el.getTextOffset() + el.getText().length() - 2;
        Editor editor = PsiUtilBase.findEditor((PsiElement)el);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(offset);
        }
    }
}

