/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.text.MessageFormat;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.SVNAbstractTunnelConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNTunnelConnector
extends SVNAbstractTunnelConnector {
    private static final String TUNNEL_COMMAND = "{0} {1} svnserve -t";
    private String myTunnelSpec;
    private String myName;

    public SVNTunnelConnector(String name, String tunnelSpec) {
        this.myName = name;
        this.myTunnelSpec = tunnelSpec;
    }

    @Override
    public void open(SVNRepositoryImpl repository) throws SVNException {
        String expandedTunnel = SVNTunnelConnector.expandTunnelSpec(this.myName, this.myTunnelSpec);
        String host = repository.getLocation().getHost();
        if (repository.getLocation().getUserInfo() != null && !"".equals(repository.getLocation().getUserInfo())) {
            String username = repository.getLocation().getUserInfo();
            host = username + "@" + host;
        }
        expandedTunnel = MessageFormat.format(TUNNEL_COMMAND, expandedTunnel, host);
        ISVNAuthenticationManager authManager = repository.getAuthenticationManager();
        if (authManager != null) {
            String userName;
            SVNAuthentication auth = authManager.getFirstAuthentication("svn.username", host, repository.getLocation());
            if (auth == null) {
                SVNErrorManager.cancel("Authentication cancelled", SVNLogType.NETWORK);
            }
            if ((userName = auth.getUserName()) == null || "".equals(userName.trim())) {
                userName = System.getProperty("user.name");
            }
            auth = new SVNUserNameAuthentication(userName, auth.isStorageAllowed(), repository.getLocation(), false);
            BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.username", host, null, auth, repository.getLocation(), authManager);
            expandedTunnel = expandedTunnel + " --tunnel-user " + userName;
            repository.setExternalUserName(userName);
        }
        SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "tunnel command: " + expandedTunnel);
        this.open(repository, expandedTunnel);
    }

    private static String expandTunnelSpec(String name, String tunnelSpec) throws SVNException {
        String lastSegment;
        int spaceIndex;
        if (tunnelSpec == null || tunnelSpec.trim().length() == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "No tunnel spec foound for ''{0}''", (Object)name);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        String firstSegment = (spaceIndex = (tunnelSpec = tunnelSpec.trim()).indexOf(32)) > 0 ? tunnelSpec.substring(0, spaceIndex) : tunnelSpec;
        String string = lastSegment = spaceIndex > 0 ? tunnelSpec.substring(spaceIndex).trim() : tunnelSpec;
        if (firstSegment.charAt(0) == '%' && firstSegment.charAt(firstSegment.length() - 1) == '%') {
            firstSegment = firstSegment.substring(1);
            firstSegment = firstSegment.substring(0, firstSegment.length() - 1);
            firstSegment = SVNFileUtil.getEnvironmentVariable(firstSegment);
        } else if (firstSegment.charAt(0) == '$') {
            firstSegment = firstSegment.substring(1);
            firstSegment = SVNFileUtil.getEnvironmentVariable(firstSegment);
        } else {
            firstSegment = null;
            lastSegment = null;
        }
        if (firstSegment != null) {
            tunnelSpec = firstSegment;
        } else if (lastSegment != null) {
            tunnelSpec = lastSegment;
        }
        return tunnelSpec;
    }

    @Override
    public void handleExceptionOnOpen(SVNRepositoryImpl repository, SVNException exception) throws SVNException {
        throw exception;
    }
}

