/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.rebase.GitRebaseStatus;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseSpec {
    private static final Logger LOG = Logger.getInstance(GitRebaseSpec.class);
    @Nullable
    private final GitRebaseParams myParams;
    @NotNull
    private final Map<GitRepository, GitRebaseStatus> myStatuses;
    @NotNull
    private final Map<GitRepository, String> myInitialHeadPositions;
    @NotNull
    private final Map<GitRepository, String> myInitialBranchNames;
    @NotNull
    private final GitChangesSaver mySaver;
    private final boolean myShouldBeSaved;

    public GitRebaseSpec(@Nullable GitRebaseParams params, @NotNull Map<GitRepository, GitRebaseStatus> statuses, @NotNull Map<GitRepository, String> initialHeadPositions, @NotNull Map<GitRepository, String> initialBranchNames, @NotNull GitChangesSaver saver, boolean shouldBeSaved) {
        if (statuses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statuses", "git4idea/rebase/GitRebaseSpec", "<init>"));
        }
        if (initialHeadPositions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialHeadPositions", "git4idea/rebase/GitRebaseSpec", "<init>"));
        }
        if (initialBranchNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialBranchNames", "git4idea/rebase/GitRebaseSpec", "<init>"));
        }
        if (saver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saver", "git4idea/rebase/GitRebaseSpec", "<init>"));
        }
        this.myParams = params;
        this.myStatuses = statuses;
        this.myInitialHeadPositions = initialHeadPositions;
        this.myInitialBranchNames = initialBranchNames;
        this.mySaver = saver;
        this.myShouldBeSaved = shouldBeSaved;
    }

    @NotNull
    public static GitRebaseSpec forNewRebase(@NotNull Project project, @NotNull GitRebaseParams params, @NotNull Collection<GitRepository> repositories, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseSpec", "forNewRebase"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "git4idea/rebase/GitRebaseSpec", "forNewRebase"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseSpec", "forNewRebase"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseSpec", "forNewRebase"));
        }
        GitUtil.updateRepositories(repositories);
        Map<GitRepository, String> initialHeadPositions = GitRebaseSpec.findInitialHeadPositions(repositories, params.getBranch());
        Map<GitRepository, String> initialBranchNames = GitRebaseSpec.findInitialBranchNames(repositories);
        TreeMap<GitRepository, GitRebaseStatus> initialStatusMap = new TreeMap<GitRepository, GitRebaseStatus>(DvcsUtil.REPOSITORY_COMPARATOR);
        for (GitRepository repository : repositories) {
            initialStatusMap.put(repository, GitRebaseStatus.notStarted());
        }
        GitRebaseSpec gitRebaseSpec = new GitRebaseSpec(params, initialStatusMap, initialHeadPositions, initialBranchNames, GitRebaseSpec.newSaver(project, indicator), true);
        if (gitRebaseSpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "forNewRebase"));
        }
        return gitRebaseSpec;
    }

    @Nullable
    public static GitRebaseSpec forResumeInSingleRepository(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseSpec", "forResumeInSingleRepository"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseSpec", "forResumeInSingleRepository"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseSpec", "forResumeInSingleRepository"));
        }
        if (!repository.isRebaseInProgress()) {
            return null;
        }
        GitRebaseStatus suspended = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED, Collections.emptyList());
        return new GitRebaseSpec(null, Collections.singletonMap(repository, suspended), Collections.emptyMap(), Collections.emptyMap(), GitRebaseSpec.newSaver(project, indicator), false);
    }

    public boolean isValid() {
        return this.singleOngoingRebase() && this.rebaseStatusesMatch();
    }

    @NotNull
    public GitChangesSaver getSaver() {
        GitChangesSaver gitChangesSaver = this.mySaver;
        if (gitChangesSaver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "getSaver"));
        }
        return gitChangesSaver;
    }

    @NotNull
    public Collection<GitRepository> getAllRepositories() {
        Set<GitRepository> set = this.myStatuses.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "getAllRepositories"));
        }
        return set;
    }

    @Nullable
    public GitRepository getOngoingRebase() {
        return (GitRepository)ContainerUtil.getFirstItem(this.getOngoingRebases());
    }

    @Nullable
    public GitRebaseParams getParams() {
        return this.myParams;
    }

    @NotNull
    public Map<GitRepository, GitRebaseStatus> getStatuses() {
        Map<GitRepository, GitRebaseStatus> map = Collections.unmodifiableMap(this.myStatuses);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "getStatuses"));
        }
        return map;
    }

    @NotNull
    public Map<GitRepository, String> getHeadPositionsToRollback() {
        Map map = ContainerUtil.filter(this.myInitialHeadPositions, (Condition)new Condition<GitRepository>(){

            public boolean value(GitRepository repository) {
                return ((GitRebaseStatus)GitRebaseSpec.this.myStatuses.get(repository)).getType() == GitRebaseStatus.Type.SUCCESS;
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "getHeadPositionsToRollback"));
        }
        return map;
    }

    @NotNull
    public Map<GitRepository, String> getInitialBranchNames() {
        Map<GitRepository, String> map = this.myInitialBranchNames;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "getInitialBranchNames"));
        }
        return map;
    }

    @NotNull
    public GitRebaseSpec cloneWithNewStatuses(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statuses", "git4idea/rebase/GitRebaseSpec", "cloneWithNewStatuses"));
        }
        GitRebaseSpec gitRebaseSpec = new GitRebaseSpec(this.myParams, statuses, this.myInitialHeadPositions, this.myInitialBranchNames, this.mySaver, true);
        if (gitRebaseSpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "cloneWithNewStatuses"));
        }
        return gitRebaseSpec;
    }

    public boolean shouldBeSaved() {
        return this.myShouldBeSaved;
    }

    @NotNull
    public List<GitRepository> getIncompleteRepositories() {
        ArrayList incompleteRepositories = ContainerUtil.newArrayList();
        final GitRepository ongoingRebase = this.getOngoingRebase();
        if (ongoingRebase != null) {
            incompleteRepositories.add(ongoingRebase);
        }
        incompleteRepositories.addAll(DvcsUtil.sortRepositories((Collection)ContainerUtil.filter(this.myStatuses.keySet(), (Condition)new Condition<GitRepository>(){

            public boolean value(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseSpec$2", "value"));
                }
                return !repository.equals(ongoingRebase) && ((GitRebaseStatus)GitRebaseSpec.this.myStatuses.get(repository)).getType() != GitRebaseStatus.Type.SUCCESS;
            }
        })));
        ArrayList arrayList = incompleteRepositories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "getIncompleteRepositories"));
        }
        return arrayList;
    }

    @NotNull
    private static GitStashChangesSaver newSaver(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/rebase/GitRebaseSpec", "newSaver"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseSpec", "newSaver"));
        }
        Git git = (Git)ServiceManager.getService(Git.class);
        GitPlatformFacade facade = (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class);
        GitStashChangesSaver gitStashChangesSaver = new GitStashChangesSaver(project, facade, git, indicator, "Uncommitted changes before rebase");
        if (gitStashChangesSaver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "newSaver"));
        }
        return gitStashChangesSaver;
    }

    @NotNull
    private static Map<GitRepository, String> findInitialHeadPositions(@NotNull Collection<GitRepository> repositories, final @Nullable String branchToCheckout) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseSpec", "findInitialHeadPositions"));
        }
        Map map = ContainerUtil.map2Map(repositories, (Function)new Function<GitRepository, Pair<GitRepository, String>>(){

            public Pair<GitRepository, String> fun(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseSpec$3", "fun"));
                }
                String currentRevision = GitRebaseSpec.findCurrentRevision(repository, branchToCheckout);
                LOG.debug("Current revision in [" + repository.getRoot().getName() + "] is [" + currentRevision + "]");
                return Pair.create((Object)repository, (Object)currentRevision);
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "findInitialHeadPositions"));
        }
        return map;
    }

    @Nullable
    private static String findCurrentRevision(@NotNull GitRepository repository, @Nullable String branchToCheckout) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseSpec", "findCurrentRevision"));
        }
        if (branchToCheckout != null) {
            GitLocalBranch branch = repository.getBranches().findLocalBranch(branchToCheckout);
            if (branch != null) {
                Hash hash = repository.getBranches().getHash(branch);
                if (hash != null) {
                    return hash.asString();
                }
                LOG.warn("The hash for branch [" + branchToCheckout + "] is not known!");
            } else {
                LOG.warn("The branch [" + branchToCheckout + "] is not known!");
            }
        }
        return repository.getCurrentRevision();
    }

    @NotNull
    private static Map<GitRepository, String> findInitialBranchNames(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/rebase/GitRebaseSpec", "findInitialBranchNames"));
        }
        Map map = ContainerUtil.map2Map(repositories, (Function)new Function<GitRepository, Pair<GitRepository, String>>(){

            public Pair<GitRepository, String> fun(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseSpec$4", "fun"));
                }
                String currentBranchName = repository.getCurrentBranchName();
                LOG.debug("Current branch in [" + repository.getRoot().getName() + "] is [" + currentBranchName + "]");
                return Pair.create((Object)repository, (Object)currentBranchName);
            }
        });
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "findInitialBranchNames"));
        }
        return map;
    }

    @NotNull
    private Collection<GitRepository> getOngoingRebases() {
        List list = ContainerUtil.filter(this.myStatuses.keySet(), (Condition)new Condition<GitRepository>(){

            public boolean value(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseSpec$5", "value"));
                }
                return ((GitRebaseStatus)GitRebaseSpec.this.myStatuses.get(repository)).getType() == GitRebaseStatus.Type.SUSPENDED;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseSpec", "getOngoingRebases"));
        }
        return list;
    }

    private boolean singleOngoingRebase() {
        Collection<GitRepository> ongoingRebases = this.getOngoingRebases();
        if (ongoingRebases.size() > 1) {
            LOG.warn("Invalid rebase spec: rebase is in progress in " + DvcsUtil.getShortNames(ongoingRebases));
            return false;
        }
        return true;
    }

    private boolean rebaseStatusesMatch() {
        for (GitRepository repository : this.myStatuses.keySet()) {
            GitRebaseStatus.Type savedStatus = this.myStatuses.get(repository).getType();
            if (repository.isRebaseInProgress() && savedStatus != GitRebaseStatus.Type.SUSPENDED) {
                LOG.warn("Invalid rebase spec: rebase is in progress in " + DvcsUtil.getShortRepositoryName((Repository)repository) + ", but it is saved as " + (Object)((Object)savedStatus));
                return false;
            }
            if (repository.isRebaseInProgress() || savedStatus != GitRebaseStatus.Type.SUSPENDED) continue;
            LOG.warn("Invalid rebase spec: rebase is not in progress in " + DvcsUtil.getShortRepositoryName((Repository)repository));
            return false;
        }
        return true;
    }

    public String toString() {
        String initialHeadPositions = StringUtil.join(this.myInitialHeadPositions.keySet(), (Function)new Function<GitRepository, String>(){

            public String fun(@NotNull GitRepository repository) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/rebase/GitRebaseSpec$6", "fun"));
                }
                return DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + (String)GitRebaseSpec.this.myInitialHeadPositions.get(repository);
            }
        }, (String)", ");
        String statuses = StringUtil.join(this.myStatuses.keySet(), (Function)new Function<GitRepository, String>(){

            public String fun(GitRepository repository) {
                return DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + GitRebaseSpec.this.myStatuses.get(repository);
            }
        }, (String)", ");
        return String.format("{Params: [%s].\nInitial positions: %s.\nStatuses: %s.\nSaver: %s}", this.myParams, initialHeadPositions, statuses, this.mySaver);
    }
}

