/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.impl;

import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.stubs.KotlinModifierListStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtModifierListElementType;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubBaseImpl;
import org.jetbrains.kotlin.psi.stubs.impl.ModifierMaskUtils;

public class KotlinModifierListStubImpl
extends KotlinStubBaseImpl<KtModifierList>
implements KotlinModifierListStub {
    private final int mask;

    public KotlinModifierListStubImpl(StubElement parent2, int mask, @NotNull KtModifierListElementType<?> elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/psi/stubs/impl/KotlinModifierListStubImpl", "<init>"));
        }
        super(parent2, elementType);
        this.mask = mask;
    }

    public int getMask() {
        return this.mask;
    }

    @Override
    public boolean hasModifier(@NotNull KtModifierKeywordToken modifierToken) {
        if (modifierToken == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierToken", "org/jetbrains/kotlin/psi/stubs/impl/KotlinModifierListStubImpl", "hasModifier"));
        }
        return ModifierMaskUtils.maskHasModifier(this.mask, modifierToken);
    }

    @Override
    @NotNull
    public String toString() {
        String string = super.toString() + ModifierMaskUtils.maskToString(this.mask);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/impl/KotlinModifierListStubImpl", "toString"));
        }
        return string;
    }
}

