/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public class ControlFlowAnalyzer {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final KotlinBuiltIns builtIns;

    public ControlFlowAnalyzer(@NotNull BindingTrace trace, @NotNull KotlinBuiltIns builtIns) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "<init>"));
        }
        this.trace = trace;
        this.builtIns = builtIns;
    }

    public void process(@NotNull BodiesResolveContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "process"));
        }
        for (KtFile ktFile : c.getFiles()) {
            this.checkDeclarationContainer(c, ktFile);
        }
        for (KtClassOrObject ktClassOrObject : c.getDeclaredClasses().keySet()) {
            this.checkDeclarationContainer(c, ktClassOrObject);
        }
        for (KtScript ktScript : c.getScripts().keySet()) {
            this.checkDeclarationContainer(c, ktScript);
        }
        for (KtSecondaryConstructor ktSecondaryConstructor : c.getSecondaryConstructors().keySet()) {
            this.checkSecondaryConstructor(ktSecondaryConstructor);
        }
        for (Map.Entry entry : c.getFunctions().entrySet()) {
            KtNamedFunction function = (KtNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            KotlinType expectedReturnType = !function.hasBlockBody() && !function.hasDeclaredReturnType() ? TypeUtils.NO_EXPECTED_TYPE : functionDescriptor.getReturnType();
            this.checkFunction(c, function, expectedReturnType);
        }
        for (Map.Entry entry : c.getProperties().entrySet()) {
            KtProperty property = (KtProperty)entry.getKey();
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.checkProperty(c, property, propertyDescriptor);
        }
    }

    private void checkSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkSecondaryConstructor"));
        }
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider(constructor, this.trace);
        controlFlowInformationProvider.checkDeclaration();
        controlFlowInformationProvider.checkFunction(this.builtIns.getUnitType());
    }

    private void checkDeclarationContainer(@NotNull BodiesResolveContext c, KtDeclarationContainer declarationContainer) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkDeclarationContainer"));
        }
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider((KtElement)((Object)declarationContainer), this.trace);
        if (c.getTopDownAnalysisMode().isLocalDeclarations()) {
            controlFlowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        controlFlowInformationProvider.checkDeclaration();
    }

    private void checkProperty(@NotNull BodiesResolveContext c, KtProperty property, PropertyDescriptor propertyDescriptor) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkProperty"));
        }
        for (KtPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor accessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (accessorDescriptor != null) : "no property accessor descriptor " + accessor.getText();
            KotlinType returnType2 = accessorDescriptor.getReturnType();
            this.checkFunction(c, accessor, returnType2);
        }
    }

    private void checkFunction(@NotNull BodiesResolveContext c, @NotNull KtDeclarationWithBody function, @Nullable KotlinType expectedReturnType) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkFunction"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/ControlFlowAnalyzer", "checkFunction"));
        }
        if (!function.hasBody()) {
            return;
        }
        ControlFlowInformationProvider controlFlowInformationProvider = new ControlFlowInformationProvider(function, this.trace);
        if (c.getTopDownAnalysisMode().isLocalDeclarations()) {
            controlFlowInformationProvider.checkForLocalClassOrObjectMode();
            return;
        }
        controlFlowInformationProvider.checkDeclaration();
        controlFlowInformationProvider.checkFunction(expectedReturnType);
    }
}

