/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.kotlin.idea.KotlinIconProvider;
import org.jetbrains.kotlin.idea.projectView.KotlinProjectViewUtil;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNode;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiUtil;

public class KtClassOrObjectTreeNode
extends AbstractPsiBasedNode<KtClassOrObject> {
    protected KtClassOrObjectTreeNode(Project project, KtClassOrObject ktClassOrObject, ViewSettings viewSettings) {
        super(project, (Object)ktClassOrObject, viewSettings);
    }

    protected PsiElement extractPsiFromValue() {
        return (PsiElement)this.getValue();
    }

    protected Collection<AbstractTreeNode> getChildrenImpl() {
        return KotlinProjectViewUtil.getClassOrObjectChildren((KtClassOrObject)this.getValue(), this.getProject(), this.getSettings());
    }

    private void update(AbstractTreeNode node) {
        Project project = this.getProject();
        if (project != null) {
            ProjectView.getInstance((Project)project).getCurrentProjectViewPane().getTreeBuilder().addSubtreeToUpdateByElement((Object)node);
        }
    }

    protected void updateImpl(PresentationData data) {
        KtClassOrObject classOrObject = (KtClassOrObject)this.getValue();
        if (classOrObject != null) {
            data.setPresentableText(classOrObject.getName());
            AbstractTreeNode parent2 = this.getParent();
            if (KotlinIconProvider.getMainClass(classOrObject.getContainingKtFile()) != null) {
                if (parent2 instanceof KtFileTreeNode) {
                    this.update(parent2.getParent());
                }
            } else if (!(parent2 instanceof KtClassOrObjectTreeNode) && !(parent2 instanceof KtFileTreeNode)) {
                this.update(parent2);
            }
        }
    }

    protected boolean isDeprecated() {
        return KtPsiUtil.isDeprecated((KtModifierListOwner)this.getValue());
    }

    public boolean canRepresent(Object element2) {
        if (!this.isValid()) {
            return false;
        }
        return super.canRepresent(element2) || KotlinProjectViewUtil.canRepresentPsiElement((PsiElement)this.getValue(), element2, this.getSettings());
    }

    public int getWeight() {
        return 20;
    }
}

