/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.OverridingUtilsKt;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u001f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u0002H\u0002\u00a2\u0006\u0002\u0010\u0007\u001a9\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\n0\t2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"findOriginalTopMostOverriddenDescriptors", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/Set;", "findTopMostOverriddenDescriptors", "", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/List;", "selectMostSpecificInEachOverridableGroup", "", "H", "", "descriptorByHandle", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "descriptors"})
public final class OverridingUtilsKt {
    @NotNull
    public static final <D extends CallableDescriptor> List<D> findTopMostOverriddenDescriptors(D $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        List list2 = (List)DFS.dfs(CollectionsKt.listOf($receiver), findTopMostOverriddenDescriptors.1.INSTANCE, new DFS.CollectingNodeHandler<CallableDescriptor, CallableDescriptor, ArrayList<D>>(new ArrayList()){

            public void afterChildren(@NotNull CallableDescriptor current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                if (current.getOverriddenDescriptors().isEmpty()) {
                    CallableDescriptor callableDescriptor = current;
                    if (callableDescriptor == null) {
                        throw new TypeCastException("null cannot be cast to non-null type D");
                    }
                    ((ArrayList)this.result).add(callableDescriptor);
                }
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"DFS.dfs(\n            lis\u2026         }\n            })");
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <D extends CallableDescriptor> Set<D> findOriginalTopMostOverriddenDescriptors(D $receiver) {
        void var2_2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable iterable = OverridingUtilsKt.findTopMostOverriddenDescriptors($receiver);
        Collection destination$iv = new LinkedHashSet();
        for (Object item$iv : $receiver$iv) {
            CallableDescriptor callableDescriptor;
            void it;
            CallableDescriptor callableDescriptor2 = (CallableDescriptor)item$iv;
            Collection collection = destination$iv;
            if (it.getOriginal() == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            collection.add(callableDescriptor);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <H> Collection<H> selectMostSpecificInEachOverridableGroup(Collection<? extends H> $receiver, @NotNull Function1<? super H, ? extends CallableDescriptor> descriptorByHandle) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(descriptorByHandle, (String)"descriptorByHandle");
        if ($receiver.size() <= 1) {
            return $receiver;
        }
        LinkedList<? extends H> queue = new LinkedList<H>($receiver);
        SmartSet<Object> result2 = SmartSet.Companion.create();
        while (true) {
            Collection $receiver$iv;
            SmartSet conflictedHandles;
            void $receiver$iv2;
            Collection collection = queue;
            if (!(!$receiver$iv2.isEmpty())) break;
            Object nextHandle = CollectionsKt.first((List)queue);
            Collection<H> overridableGroup2 = OverridingUtil.extractMembersOverridableInBothWays(nextHandle, (Collection)queue, descriptorByHandle, (Function1)new Function1<H, Unit>(conflictedHandles = SmartSet.Companion.create()){
                final /* synthetic */ SmartSet $conflictedHandles;

                public final void invoke(H it) {
                    H h = it;
                    Intrinsics.checkExpressionValueIsNotNull(h, (String)"it");
                    this.$conflictedHandles.add(h);
                }
                {
                    this.$conflictedHandles = smartSet;
                    super(1);
                }
            });
            if (overridableGroup2.size() == 1 && overridableGroup2.isEmpty()) {
                Object object = CollectionsKt.single((Iterable)overridableGroup2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"overridableGroup.single()");
                result2.add(object);
                continue;
            }
            H mostSpecific = OverridingUtil.selectMostSpecificMember(overridableGroup2, descriptorByHandle);
            CallableDescriptor mostSpecificDescriptor = (CallableDescriptor)descriptorByHandle.invoke(mostSpecific);
            Iterable iterable = overridableGroup2;
            for (Object element$iv : $receiver$iv) {
                Object it = element$iv;
                if (OverridingUtil.isMoreSpecific(mostSpecificDescriptor, (CallableDescriptor)descriptorByHandle.invoke(it))) continue;
                ((Collection)conflictedHandles).add(element$iv);
            }
            $receiver$iv = conflictedHandles;
            if (!$receiver$iv.isEmpty()) {
                result2.addAll(conflictedHandles);
            }
            H h = mostSpecific;
            Intrinsics.checkExpressionValueIsNotNull(h, (String)"mostSpecific");
            result2.add(h);
        }
        return result2;
    }
}

