/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JavaClass;

public final class CodePosition {
    private final JavaClass cls;
    private final int line;
    private final int offset;

    public CodePosition(JavaClass cls, int line, int offset) {
        this.cls = cls;
        this.line = line;
        this.offset = offset;
    }

    public CodePosition(int line, int offset) {
        this.cls = null;
        this.line = line;
        this.offset = offset;
    }

    public JavaClass getJavaClass() {
        return this.cls;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isSet() {
        return this.line != 0 || this.offset != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodePosition that = (CodePosition)o;
        return this.line == that.line && this.offset == that.offset;
    }

    public int hashCode() {
        return this.line + 31 * this.offset;
    }

    public String toString() {
        return this.line + ":" + this.offset + (this.cls != null ? " " + this.cls : "");
    }
}

