/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javajs.J2SIgnoreImport;
import javajs.api.GenericZipInputStream;
import javajs.api.GenericZipTools;
import javajs.api.ZInputStream;
import javajs.util.BArray;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;

@J2SIgnoreImport(value={ZipOutputStream.class})
public class ZipTools
implements GenericZipTools {
    @Override
    public ZInputStream newZipInputStream(InputStream inputStream) {
        return ZipTools.newZIS(inputStream);
    }

    private static ZInputStream newZIS(InputStream inputStream) {
        return inputStream instanceof ZInputStream ? (ZInputStream)((Object)inputStream) : (inputStream instanceof BufferedInputStream ? new GenericZipInputStream(inputStream) : new GenericZipInputStream(new BufferedInputStream(inputStream)));
    }

    @Override
    public void getAllZipData(InputStream inputStream, String[] stringArray, String string, String string2, String string3, Map<String, String> map) {
        ZipInputStream zipInputStream = (ZipInputStream)((Object)ZipTools.newZIS(inputStream));
        SB sB = new SB();
        string2 = "|" + string2 + "|";
        String string4 = PT.join(stringArray, '/', 1);
        String string5 = null;
        if (string4 != null && (string5 = string4.substring(0, string4.indexOf("/") + 1)).length() == 0) {
            string5 = null;
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string6;
                String string7 = zipEntry.getName();
                if (string4 != null && string5 != null && !string7.equals(string4) && !string7.startsWith(string5) || string3 != null && string7.contains(string3)) continue;
                sB.append(string7).appendC('\n');
                String string8 = "|" + string7.substring(string7.lastIndexOf("/") + 1) + "|";
                boolean bl = string2.indexOf(string8) >= 0;
                byte[] byArray = Rdr.getLimitedStreamBytes(zipInputStream, zipEntry.getSize());
                if (bl) {
                    string6 = this.getBinaryStringForBytes(byArray);
                    string7 = string7 + ":asBinaryString";
                } else {
                    string6 = Rdr.fixUTF(byArray);
                }
                string6 = "BEGIN Directory Entry " + string7 + "\n" + string6 + "\nEND Directory Entry " + string7 + "\n";
                String string9 = string + "|" + string7;
                map.put(string9, string6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        map.put("#Directory_Listing", sB.toString());
    }

    private String getBinaryStringForBytes(byte[] byArray) {
        SB sB = new SB();
        for (int i = 0; i < byArray.length; ++i) {
            sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
        }
        return sB.toString();
    }

    @Override
    public Object getZipFileDirectory(BufferedInputStream bufferedInputStream, String[] stringArray, int n, boolean bl) {
        if (stringArray == null || n >= stringArray.length) {
            return this.getZipDirectoryAsStringAndClose(bufferedInputStream);
        }
        bufferedInputStream = Rdr.getPngZipStream(bufferedInputStream, true);
        String string = stringArray[n];
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        try {
            ZipEntry zipEntry;
            boolean bl2;
            boolean bl3 = string.equals(".");
            if (bl3 || string.lastIndexOf("/") == string.length() - 1) {
                String string2;
                ZipEntry zipEntry2;
                SB sB = new SB();
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    string2 = zipEntry2.getName();
                    if (!bl3 && !string2.startsWith(string)) continue;
                    sB.append(string2).appendC('\n');
                }
                string2 = sB.toString();
                return bl ? Rdr.getBIS(string2.getBytes()) : string2;
            }
            int n2 = string.indexOf(":asBinaryString");
            boolean bl4 = bl2 = n2 > 0;
            if (bl2) {
                string = string.substring(0, n2);
            }
            string = string.replace('\\', '/');
            while ((zipEntry = zipInputStream.getNextEntry()) != null && !string.equals(zipEntry.getName())) {
            }
            byte[] byArray = zipEntry == null ? null : Rdr.getLimitedStreamBytes(zipInputStream, zipEntry.getSize());
            zipEntry = null;
            zipInputStream.close();
            if (byArray == null) {
                return "";
            }
            if (Rdr.isZipB(byArray) || Rdr.isPngZipB(byArray)) {
                return this.getZipFileDirectory(Rdr.getBIS(byArray), stringArray, ++n, bl);
            }
            if (bl) {
                return Rdr.getBIS(byArray);
            }
            if (bl2) {
                SB sB = new SB();
                for (int i = 0; i < byArray.length; ++i) {
                    sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
                }
                return sB.toString();
            }
            if (Rdr.isGzipB(byArray)) {
                byArray = Rdr.getLimitedStreamBytes(this.getUnGzippedInputStream(byArray), -1L);
            }
            return Rdr.fixUTF(byArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public byte[] getZipFileContentsAsBytes(BufferedInputStream bufferedInputStream, String[] stringArray, int n) {
        byte[] byArray = new byte[]{};
        String string = stringArray[n];
        if (string.lastIndexOf("/") == string.length() - 1) {
            return byArray;
        }
        try {
            ZipEntry zipEntry;
            bufferedInputStream = Rdr.getPngZipStream(bufferedInputStream, true);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = Rdr.getLimitedStreamBytes(zipInputStream, zipEntry.getSize());
                return (Rdr.isZipB(byArray2) || Rdr.isPngZipB(byArray2)) && ++n < stringArray.length ? this.getZipFileContentsAsBytes(Rdr.getBIS(byArray2), stringArray, n) : byArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    @Override
    public String getZipDirectoryAsStringAndClose(BufferedInputStream bufferedInputStream) {
        SB sB = new SB();
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, null);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            sB.append(stringArray[i]).appendC('\n');
        }
        return sB.toString();
    }

    @Override
    public String[] getZipDirectoryAndClose(BufferedInputStream bufferedInputStream, String string) {
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, string);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return stringArray;
    }

    private String[] getZipDirectoryOrErrorAndClose(BufferedInputStream bufferedInputStream, String string) throws IOException {
        ZipEntry zipEntry;
        bufferedInputStream = Rdr.getPngZipStream(bufferedInputStream, true);
        Lst<String> lst = new Lst<String>();
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        String string2 = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string3 = zipEntry.getName();
            if (string != null && string3.startsWith(string)) {
                string2 = ZipTools.getStreamAsString(zipInputStream);
                continue;
            }
            if (string3.startsWith("__MACOS")) continue;
            lst.addLast(string3);
        }
        zipInputStream.close();
        if (string != null) {
            lst.add(0, string2 == null ? "" : string2 + "\n############\n");
        }
        return lst.toArray(new String[lst.size()]);
    }

    public static String getStreamAsString(InputStream inputStream) throws IOException {
        return Rdr.fixUTF(Rdr.getLimitedStreamBytes(inputStream, -1L));
    }

    @Override
    public InputStream newGZIPInputStream(InputStream inputStream) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(inputStream, 512));
    }

    @Override
    public BufferedInputStream getUnGzippedInputStream(byte[] byArray) {
        try {
            return Rdr.getUnzippedInputStream(this, Rdr.getBIS(byArray));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void addZipEntry(Object object, String string) throws IOException {
        ((ZipOutputStream)object).putNextEntry(new ZipEntry(string));
    }

    @Override
    public void closeZipEntry(Object object) throws IOException {
        ((ZipOutputStream)object).closeEntry();
    }

    @Override
    public Object getZipOutputStream(Object object) {
        return new ZipOutputStream((OutputStream)object);
    }

    @Override
    public int getCrcValue(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return (int)cRC32.getValue();
    }

    @Override
    public void readFileAsMap(BufferedInputStream bufferedInputStream, Map<String, Object> map, String string) {
        int n = string == null ? -1 : string.indexOf("|");
        string = n >= 0 ? string.substring(n + 1) : null;
        try {
            if (Rdr.isPngZipStream(bufferedInputStream)) {
                boolean bl = "_IMAGE_".equals(string);
                if (string == null || bl) {
                    map.put(bl ? "_DATA_" : "_IMAGE_", new BArray(ZipTools.getPngImageBytes(bufferedInputStream)));
                }
                if (!bl) {
                    this.cacheZipContents(bufferedInputStream, string, map, true);
                }
            } else if (Rdr.isZipS(bufferedInputStream)) {
                this.cacheZipContents(bufferedInputStream, string, map, true);
            } else if (string == null) {
                map.put("_DATA_", new BArray(Rdr.getLimitedStreamBytes(bufferedInputStream, -1L)));
            } else {
                throw new IOException("ZIP file " + string + " not found");
            }
            map.put("$_BINARY_$", Boolean.TRUE);
        }
        catch (IOException iOException) {
            map.clear();
            map.put("_ERROR_", iOException.getMessage());
        }
    }

    @Override
    public String cacheZipContents(BufferedInputStream bufferedInputStream, String string, Map<String, Object> map, boolean bl) {
        String string2;
        ZipInputStream zipInputStream = (ZipInputStream)((Object)ZipTools.newZIS(bufferedInputStream));
        SB sB = new SB();
        long l = 0L;
        boolean bl2 = bl && string != null;
        int n = bl2 ? string.indexOf("|") : -1;
        String string3 = string2 = n >= 0 ? string : null;
        if (n >= 0) {
            string = string.substring(0, n);
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                Object object;
                Object object2;
                String string4 = zipEntry.getName();
                if (string != null) {
                    if (bl2) {
                        if (!string4.equalsIgnoreCase(string)) {
                            continue;
                        }
                    } else {
                        sB.append(string4).appendC('\n');
                    }
                }
                long l2 = zipEntry.getSize();
                byte[] byArray = Rdr.getLimitedStreamBytes(zipInputStream, l2);
                if (string2 != null) {
                    this.readFileAsMap(Rdr.getBIS(byArray), map, string2);
                    return null;
                }
                l += (long)byArray.length;
                if (bl) {
                    BArray bArray;
                    object2 = bArray;
                    bArray = new BArray(byArray);
                } else {
                    object2 = object = byArray;
                }
                map.put(bl2 ? "_DATA_" : (string == null ? "" : string + "|") + string4, object);
                if (!bl2) continue;
                break;
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (l == 0L || string == null) {
            return null;
        }
        System.out.println("ZipTools cached " + l + " bytes from " + string);
        return sB.toString();
    }

    private static byte[] getPngImageBytes(BufferedInputStream bufferedInputStream) {
        try {
            if (Rdr.isPngZipStream(bufferedInputStream)) {
                int[] nArray = new int[2];
                Rdr.getPngZipPointAndCount(bufferedInputStream, nArray);
                if (nArray[1] != 0) {
                    return ZipTools.deActivatePngZipB(Rdr.getLimitedStreamBytes(bufferedInputStream, nArray[0]));
                }
            }
            return Rdr.getLimitedStreamBytes(bufferedInputStream, -1L);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static byte[] deActivatePngZipB(byte[] byArray) {
        if (Rdr.isPngZipB(byArray)) {
            byArray[51] = 32;
        }
        return byArray;
    }
}

