/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.PAL;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.script.SV;
import org.jmol.shape.AtomShape;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Logger;
import org.jmol.util.Normix;

public class Polyhedra
extends AtomShape {
    private static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    private static final int EDGES_NONE = 0;
    public static final int EDGES_ALL = 1;
    public static final int EDGES_FRONT = 2;
    private static final int MAX_VERTICES = 250;
    private static final int FACE_COUNT_MAX = 247;
    private static final int MAX_OTHER = 498;
    private P3[] otherAtoms = new P3[498];
    private V3[] normalsT = new V3[251];
    private int[][] planesT = AU.newInt2(250);
    private static final P3 randomPoint = P3.new3(3141.0f, 2718.0f, 1414.0f);
    private static final int MODE_BONDING = 1;
    private static final int MODE_POINTS = 2;
    private static final int MODE_RADIUS = 3;
    private static final int MODE_BITSET = 4;
    private static final int MODE_UNITCELL = 5;
    private static final int MODE_INFO = 6;
    private static final float DEFAULT_PLANAR_PARAM = 0.98f;
    private static final float CONVEX_HULL_MAX = 0.02f;
    public int polyhedronCount;
    public Polyhedron[] polyhedrons = new Polyhedron[32];
    public int drawEdges;
    private float radius;
    private float radiusMin;
    private float pointScale;
    private int nVertices;
    float faceCenterOffset;
    boolean isCollapsed;
    boolean isFull;
    private boolean iHaveCenterBitSet;
    private boolean bondedOnly;
    private boolean haveBitSetVertices;
    private BS centers;
    private String thisID;
    private P3 center;
    private BS bsVertices;
    private BS bsVertexCount;
    private boolean useUnitCell;
    private int nPoints;
    private float planarParam;
    private Map<String, SV> info;
    private float distanceRef;
    private int modelIndex;
    private BS bsPolys = new BS();
    private final V3 vAB = new V3();
    private final V3 vAC = new V3();
    private final V3 vBC = new V3();
    private static float MAX_DISTANCE_TO_PLANE = 0.1f;

    @Override
    public void setProperty(String string, Object object, BS bS) {
        int n;
        Object object2;
        int n2;
        if (this.thisID != null) {
            bS = new BS();
        }
        if ("init" == string) {
            this.faceCenterOffset = 0.25f;
            this.planarParam = Float.NaN;
            this.pointScale = 0.0f;
            this.radiusMin = 0.0f;
            this.radius = 0.0f;
            this.nVertices = 0;
            this.nPoints = 0;
            this.modelIndex = -1;
            this.bsVertices = null;
            this.thisID = null;
            this.center = null;
            this.useUnitCell = false;
            this.centers = null;
            this.info = null;
            this.bsVertexCount = new BS();
            this.iHaveCenterBitSet = false;
            this.isFull = false;
            this.isCollapsed = false;
            this.bondedOnly = false;
            this.haveBitSetVertices = false;
            if (Boolean.TRUE == object) {
                this.drawEdges = 0;
            }
            return;
        }
        if ("generate" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
                this.iHaveCenterBitSet = true;
            }
            this.deletePolyhedra();
            this.buildPolyhedra();
            return;
        }
        if ("thisID" == string) {
            this.thisID = (String)object;
            return;
        }
        if ("center" == string) {
            this.center = (P3)object;
            return;
        }
        if ("offset" == string) {
            if (this.thisID != null) {
                this.offsetPolyhedra((P3)object);
            }
            return;
        }
        if ("scale" == string) {
            if (this.thisID != null) {
                this.scalePolyhedra(((Float)object).floatValue());
            }
            return;
        }
        if ("model" == string) {
            this.modelIndex = (Integer)object;
            return;
        }
        if ("collapsed" == string) {
            this.isCollapsed = true;
            return;
        }
        if ("full" == string) {
            this.isFull = true;
            return;
        }
        if ("nVertices" == string) {
            int n3 = (Integer)object;
            if (n3 < 0) {
                if (-n3 >= this.nVertices) {
                    this.bsVertexCount.setBits(this.nVertices, 1 - n3);
                    this.nVertices = -n3;
                }
            } else {
                this.nVertices = n3;
                this.bsVertexCount.set(this.nVertices);
            }
            return;
        }
        if ("centers" == string) {
            this.centers = (BS)object;
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("unitCell" == string) {
            this.useUnitCell = true;
            return;
        }
        if ("to" == string) {
            this.bsVertices = (BS)object;
            return;
        }
        if ("toBitSet" == string) {
            this.bsVertices = (BS)object;
            this.haveBitSetVertices = true;
            return;
        }
        if ("toVertices" == string) {
            P3[] p3Array = (P3[])object;
            int n4 = this.nPoints = Math.min(p3Array.length, 250);
            while (--n4 >= 0) {
                this.otherAtoms[n4] = p3Array[n4];
            }
            return;
        }
        if ("faceCenterOffset" == string) {
            this.faceCenterOffset = ((Float)object).floatValue();
            return;
        }
        if ("distanceFactor" == string) {
            return;
        }
        if ("planarParam" == string) {
            this.planarParam = ((Float)object).floatValue();
            return;
        }
        if ("bonds" == string) {
            this.bondedOnly = true;
            return;
        }
        if ("info" == string) {
            this.info = (Map)object;
            this.centers = this.info.containsKey("center") ? null : BSUtil.newAndSetBit(this.info.get((Object)"atomIndex").intValue);
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("delete" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bS;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == string) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == string) {
            this.drawEdges = 1;
            return;
        }
        if ("frontedges" == string) {
            this.drawEdges = 2;
            return;
        }
        if (string.indexOf("color") == 0) {
            bS = "colorThis" == string && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            n2 = "colorPhase" == string ? 1 : 0;
            object2 = n2 != 0 ? ((Object[])object)[1] : object;
            short s = n2 != 0 ? C.getColix((Integer)((Object[])object)[0]) : (short)0;
            n = C.getColixO(n2 != 0 ? object2 : object);
            BS bS2 = this.findPolyBS(bS);
            int n5 = bS2.nextSetBit(0);
            while (n5 >= 0) {
                Polyhedron polyhedron = this.polyhedrons[n5];
                if (polyhedron.id == null) {
                    polyhedron.colixEdge = s;
                } else {
                    polyhedron.colixEdge = s;
                    polyhedron.colix = (short)n;
                }
                n5 = bS2.nextSetBit(n5 + 1);
            }
            if (this.thisID != null) {
                return;
            }
            object = object2;
            string = "color";
        }
        if (string.indexOf("translucency") == 0) {
            n2 = object.equals("translucent");
            if (this.thisID != null) {
                object2 = this.findPolyBS(bS);
                n = ((BS)object2).nextSetBit(0);
                while (n >= 0) {
                    Polyhedron polyhedron = this.polyhedrons[n];
                    polyhedron.colix = C.getColixTranslucent3(polyhedron.colix, n2 != 0, this.translucentLevel);
                    if (polyhedron.colixEdge != 0) {
                        polyhedron.colixEdge = C.getColixTranslucent3(polyhedron.colixEdge, n2 != 0, this.translucentLevel);
                    }
                    n = ((BS)object2).nextSetBit(n + 1);
                }
                return;
            }
            BS bS3 = bS = "translucentThis".equals(object) && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bS);
            if (object.equals("translucentThis")) {
                object = "translucent";
            }
        }
        if ("radius" == string) {
            this.radius = ((Float)object).floatValue();
            return;
        }
        if ("radius1" == string) {
            this.radiusMin = this.radius;
            this.radius = ((Float)object).floatValue();
            return;
        }
        if ("points" == string) {
            this.pointScale = ((Float)object).floatValue();
            this.pointsPolyhedra(bS, this.pointScale);
            return;
        }
        if (string == "deleteModelAtoms") {
            n2 = ((int[])((Object[])object)[2])[0];
            int n6 = this.polyhedronCount;
            while (--n6 >= 0) {
                Polyhedron polyhedron = this.polyhedrons[n6];
                polyhedron.info = null;
                if (polyhedron.modelIndex > n2) {
                    --polyhedron.modelIndex;
                    continue;
                }
                if (polyhedron.modelIndex != n2) continue;
                --this.polyhedronCount;
                this.polyhedrons = (Polyhedron[])AU.deleteElements(this.polyhedrons, n6, 1);
            }
        }
        this.setPropAS(string, object, bS);
    }

    private void pointsPolyhedra(BS bS, float f) {
        bS = this.findPolyBS(this.thisID == null ? bS : null);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.polyhedrons[n].pointScale = f;
            n = bS.nextSetBit(n + 1);
        }
    }

    private void scalePolyhedra(float f) {
        BS bS = this.findPolyBS(null);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.polyhedrons[n].scale = f;
            n = bS.nextSetBit(n + 1);
        }
    }

    private void offsetPolyhedra(P3 p3) {
        BS bS = this.findPolyBS(null);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.polyhedrons[n].setOffset(P3.newP(p3));
            n = bS.nextSetBit(n + 1);
        }
    }

    @Override
    public boolean getPropertyData(String string, Object[] objectArray) {
        String string2;
        int n = objectArray[0] instanceof Integer ? (Integer)objectArray[0] : Integer.MIN_VALUE;
        String string3 = string2 = objectArray[0] instanceof String ? (String)objectArray[0] : null;
        if (string == "checkID") {
            return this.checkID(string2);
        }
        if (string == "info") {
            Polyhedron polyhedron = this.findPoly(string2, n, true);
            if (polyhedron == null) {
                return false;
            }
            objectArray[1] = polyhedron.getInfo(this.vwr, false);
            return true;
        }
        if (string == "points") {
            Polyhedron polyhedron = this.findPoly(string2, n, false);
            if (polyhedron == null) {
                return false;
            }
            objectArray[1] = polyhedron.vertices;
            return true;
        }
        if (string == "symmetry") {
            BS bS = (BS)objectArray[2];
            String string4 = "";
            for (int i = 0; i < this.polyhedronCount; ++i) {
                Polyhedron polyhedron = this.polyhedrons[i];
                if (polyhedron.id == null ? string2 != null || bS != null && !bS.get(polyhedron.centralAtom.i) : string2 == null || !PT.isLike(string2, polyhedron.id)) continue;
                string4 = string4 + (i + 1) + "\t" + polyhedron.getSymmetry(this.vwr, true) + "\n";
            }
            objectArray[1] = string4;
            return true;
        }
        if (string == "move") {
            M4 m4 = (M4)objectArray[1];
            if (m4 == null) {
                return false;
            }
            BS bS = (BS)objectArray[0];
            BS bS2 = this.findPolyBS(bS);
            int n2 = bS2.nextSetBit(0);
            while (n2 >= 0) {
                this.polyhedrons[n2].move(m4, bS);
                n2 = bS2.nextSetBit(n2 + 1);
            }
            return true;
        }
        if (string == "getCenters") {
            int n3;
            SmilesMatcherInterface smilesMatcherInterface;
            String string5 = (String)objectArray[1];
            BS bS = (BS)objectArray[2];
            SmilesMatcherInterface smilesMatcherInterface2 = smilesMatcherInterface = string5 == null ? null : this.vwr.getSmilesMatcher();
            if (smilesMatcherInterface != null) {
                string5 = smilesMatcherInterface.cleanSmiles(string5);
            }
            int n4 = n3 = string5 != null ? PT.countChar(string5, '*') : n;
            if (n3 == 0) {
                n3 = Integer.MIN_VALUE;
            }
            BS bS3 = new BS();
            if (string5 == null || smilesMatcherInterface != null) {
                int n5 = this.polyhedronCount;
                while (--n5 >= 0) {
                    Polyhedron polyhedron = this.polyhedrons[n5];
                    if (polyhedron.id != null || n3 != (n3 > 0 ? polyhedron.nVertices : (n3 > Integer.MIN_VALUE ? -polyhedron.faces.length : n3))) continue;
                    n = polyhedron.centralAtom.i;
                    if (bS != null && !bS.get(n)) continue;
                    if (string5 == null) {
                        bS3.set(n);
                        continue;
                    }
                    polyhedron.getSymmetry(this.vwr, false);
                    String string6 = polyhedron.polySmiles;
                    try {
                        if (smilesMatcherInterface.areEqual(string5, string6) <= 0) continue;
                        bS3.set(n);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            objectArray[1] = bS3;
            return true;
        }
        if (string == "allInfo") {
            Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
            int n6 = this.polyhedronCount;
            while (--n6 >= 0) {
                lst.addLast(this.polyhedrons[n6].getInfo(this.vwr, false));
            }
            objectArray[1] = lst;
            return true;
        }
        return this.getPropShape(string, objectArray);
    }

    private boolean checkID(String string) {
        this.thisID = string;
        return this.findPolyBS(null).cardinality() > 0;
    }

    private Polyhedron findPoly(String string, int n, boolean bl) {
        int n2 = this.polyhedronCount;
        while (--n2 >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n2];
            if (!(polyhedron.id == null ? polyhedron.centralAtom.i == n : polyhedron.id.equalsIgnoreCase(string))) continue;
            return bl || !this.polyhedrons[n2].collapsed ? this.polyhedrons[n2] : null;
        }
        return null;
    }

    private BS findPolyBS(BS bS) {
        BS bS2 = this.bsPolys;
        bS2.clearAll();
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (!(polyhedron.id == null ? bS != null && bS.get(polyhedron.centralAtom.i) : this.isMatch(polyhedron.id))) continue;
            bS2.set(n);
        }
        return bS2;
    }

    private boolean isMatch(String string) {
        return this.thisID != null && PT.isMatch(string.toLowerCase(), this.thisID.toLowerCase(), true, true);
    }

    @Override
    public Lst<Map<String, Object>> getShapeDetail() {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        for (int i = 0; i < this.polyhedronCount; ++i) {
            lst.addLast(this.polyhedrons[i].getInfo(this.vwr, false));
        }
        return lst;
    }

    private BS andBitSet(BS bS) {
        BS bS2 = new BS();
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (polyhedron.id != null) continue;
            bS2.set(polyhedron.centralAtom.i);
        }
        bS2.and(bS);
        return bS2;
    }

    private void deletePolyhedra() {
        int n;
        int n2 = 0;
        byte by = PAL.pidOf(null);
        BS bS = this.findPolyBS(this.centers);
        for (n = 0; n < this.polyhedronCount; ++n) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (bS.get(n)) {
                if (this.colixes == null || polyhedron.id != null) continue;
                this.setColixAndPalette((short)0, by, polyhedron.centralAtom.i);
                continue;
            }
            this.polyhedrons[n2++] = polyhedron;
        }
        for (n = n2; n < this.polyhedronCount; ++n) {
            this.polyhedrons[n] = null;
        }
        this.polyhedronCount = n2;
    }

    private void setVisible(boolean bl) {
        BS bS = this.findPolyBS(this.centers);
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            polyhedron.visible = bl;
            this.atoms[polyhedron.centralAtom.i].setShapeVisibility(this.vf, bl);
            n = bS.nextSetBit(n + 1);
        }
    }

    private void buildPolyhedra() {
        boolean bl;
        Polyhedron polyhedron = null;
        if (this.thisID != null) {
            if (PT.isWild(this.thisID)) {
                return;
            }
            if (this.center != null) {
                polyhedron = this.validatePolyhedron(this.center, this.nPoints);
            }
        } else if (this.info != null && this.info.containsKey("id")) {
            this.thisID = this.info.get("id").asString();
            polyhedron = new Polyhedron().setInfo(this.info, this.vwr.ms.at);
        }
        if (polyhedron != null) {
            this.addPolyhedron(polyhedron);
            return;
        }
        boolean bl2 = bl = this.radius == 0.0f || this.bondedOnly;
        int n = this.info != null ? 6 : (this.nPoints > 0 ? 2 : (this.haveBitSetVertices ? 4 : (this.useUnitCell ? 5 : (bl ? 1 : 3))));
        AtomIndexIterator atomIndexIterator = n == 3 ? this.ms.getSelectedAtomIterator(null, false, false, false, false) : null;
        int n2 = this.centers.nextSetBit(0);
        while (n2 >= 0) {
            Atom atom = this.atoms[n2];
            polyhedron = null;
            switch (n) {
                case 4: {
                    polyhedron = this.constructBitSetPolyhedron(atom);
                    break;
                }
                case 5: {
                    polyhedron = this.constructUnitCellPolygon(atom, bl);
                    break;
                }
                case 1: {
                    polyhedron = this.constructBondsPolyhedron(atom, 0);
                    break;
                }
                case 3: {
                    this.vwr.setIteratorForAtom(atomIndexIterator, n2, this.radius);
                    polyhedron = this.constructRadiusPolyhedron(atom, atomIndexIterator);
                    break;
                }
                case 6: {
                    polyhedron = new Polyhedron().setInfo(this.info, this.vwr.ms.at);
                    break;
                }
                case 2: {
                    polyhedron = this.validatePolyhedron(atom, this.nPoints);
                }
            }
            if (polyhedron != null) {
                this.addPolyhedron(polyhedron);
            }
            if (this.haveBitSetVertices) break;
            n2 = this.centers.nextSetBit(n2 + 1);
        }
        if (atomIndexIterator != null) {
            atomIndexIterator.release();
        }
    }

    private void addPolyhedron(Polyhedron polyhedron) {
        if (this.polyhedronCount == this.polyhedrons.length) {
            this.polyhedrons = (Polyhedron[])AU.doubleLength(this.polyhedrons);
        }
        this.polyhedrons[this.polyhedronCount++] = polyhedron;
    }

    private Polyhedron constructBondsPolyhedron(Atom atom, int n) {
        this.distanceRef = 0.0f;
        if (n == 0) {
            Bond[] bondArray = atom.bonds;
            if (bondArray == null) {
                return null;
            }
            float f = this.radius * this.radius;
            float f2 = this.radiusMin * this.radiusMin;
            int n2 = bondArray.length;
            while (--n2 >= 0) {
                float f3;
                Bond bond = bondArray[n2];
                if (!bond.isCovalent()) continue;
                Atom atom2 = bond.getOtherAtom(atom);
                if (this.bsVertices != null && !this.bsVertices.get(atom2.i) || this.radius > 0.0f && ((f3 = atom2.distanceSquared(atom)) > f || f3 < f2)) continue;
                this.otherAtoms[n++] = atom2;
                if (n < 250) continue;
                return null;
            }
        }
        return n < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n) ? null : this.validatePolyhedron(atom, n);
    }

    private Polyhedron constructUnitCellPolygon(Atom atom, boolean bl) {
        SymmetryInterface symmetryInterface = this.vwr.ms.getUnitCellForAtom(atom.i);
        if (symmetryInterface == null) {
            return null;
        }
        BS bS = BSUtil.copy(this.vwr.getModelUndeletedAtomsBitSet(atom.mi));
        if (this.bsVertices != null) {
            bS.and(this.bsVertices);
        }
        if (bS.isEmpty()) {
            return null;
        }
        AtomIndexIterator atomIndexIterator = symmetryInterface.getIterator(this.vwr, atom, this.atoms, bS, bl ? 5.0f : this.radius);
        if (!bl) {
            return this.constructRadiusPolyhedron(atom, atomIndexIterator);
        }
        float f = atom.getBondingRadius();
        if (f == 0.0f) {
            return null;
        }
        float f2 = this.vwr.getFloat(0x22000004);
        float f3 = this.radiusMin == 0.0f ? this.vwr.getFloat(570425364) : this.radiusMin;
        float f4 = f3 * f3;
        int n = 0;
        block0: while (atomIndexIterator.hasNext()) {
            P3 p3;
            float f5;
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            float f6 = atom2.getBondingRadius();
            if (!this.vwr.ms.isBondable(f, f6, f5 = atom.distanceSquared(p3 = atomIndexIterator.getPosition()), f4, f2)) continue;
            for (int i = 0; i < n; ++i) {
                if (this.otherAtoms[i].distanceSquared(p3) < 0.01f) continue block0;
            }
            this.otherAtoms[n++] = p3;
            if (n < 250) continue;
            return null;
        }
        return this.constructBondsPolyhedron(atom, n);
    }

    private Polyhedron constructBitSetPolyhedron(Atom atom) {
        this.bsVertices.clear(atom.i);
        if (this.bsVertices.cardinality() >= 250) {
            return null;
        }
        int n = 0;
        this.distanceRef = 0.0f;
        int n2 = this.bsVertices.nextSetBit(0);
        while (n2 >= 0) {
            this.otherAtoms[n++] = this.atoms[n2];
            n2 = this.bsVertices.nextSetBit(n2 + 1);
        }
        return this.validatePolyhedron(atom, n);
    }

    private Polyhedron constructRadiusPolyhedron(Atom atom, AtomIndexIterator atomIndexIterator) {
        int n = 0;
        this.distanceRef = this.radius;
        float f = this.radius * this.radius;
        float f2 = this.radiusMin * this.radiusMin;
        block0: while (atomIndexIterator.hasNext()) {
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            P3 p3 = atomIndexIterator.getPosition();
            if (p3 == null) {
                p3 = atom2;
                if (this.bsVertices != null && !this.bsVertices.get(atom2.i)) continue;
            }
            float f3 = atom.distanceSquared(p3);
            if (atom2.altloc != atom.altloc && atom2.altloc != '\u0000' && atom.altloc != '\u0000' || f3 > f || f3 < f2) continue;
            if (n == 250) break;
            for (int i = 0; i < n; ++i) {
                if (this.otherAtoms[i].distanceSquared(p3) < 0.01f) continue block0;
            }
            this.otherAtoms[n++] = p3;
        }
        return n < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n) ? null : this.validatePolyhedron(atom, n);
    }

    private Polyhedron validatePolyhedron(P3 p3, int n) {
        int n2;
        P3[] p3Array = this.otherAtoms;
        boolean bl = this.isCollapsed;
        int n3 = 0;
        int n4 = n + 1;
        int n5 = n - 2;
        int n6 = n - 1;
        float f = Float.isNaN(this.planarParam) ? 0.98f : this.planarParam;
        p3Array[n] = p3;
        P3 p32 = P3.newP(p3);
        for (int i = 0; i < n; ++i) {
            p32.add(p3Array[i]);
        }
        p32.scale(1.0f / (float)(n + 1));
        P3 p33 = P3.newP(p32);
        BS bS = new BS();
        if (this.thisID == null) {
            int n7 = 0;
            for (int i = 0; i < n5; ++i) {
                for (int j = i + 1; j < n6; ++j) {
                    int n8 = j + 1;
                    while (n8 < n) {
                        if (this.isPlanar(p3Array[i], p3Array[j], p3Array[n8], p33)) {
                            bS.set(n7);
                        }
                        ++n8;
                        ++n7;
                    }
                }
            }
        }
        int[][] nArray = this.planesT;
        P4 p4 = new P4();
        V3 v3 = new V3();
        float f2 = this.faceCenterOffset;
        int n9 = 247;
        int n10 = 250;
        BS bS2 = Normix.newVertexBitSet();
        V3[] v3Array = this.normalsT;
        Hashtable<Integer, Object[]> hashtable = new Hashtable<Integer, Object[]>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        BS bS3 = new BS();
        Lst<int[]> lst = this.isFull ? new Lst<int[]>() : null;
        Object[] objectArray = new Object[3];
        V3 v32 = this.vAC;
        int n11 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            for (int i = n2 + 1; i < n6; ++i) {
                int n12 = i + 1;
                while (n12 < n) {
                    if (n3 >= n9) {
                        Logger.error("Polyhedron error: maximum face(" + n9 + ") -- reduce RADIUS");
                        return null;
                    }
                    if (n4 >= n10) {
                        Logger.error("Polyhedron error: maximum vertex count(" + n10 + ") -- reduce RADIUS");
                        return null;
                    }
                    boolean bl2 = bS.get(n11);
                    P3 p34 = bl2 ? randomPoint : p32;
                    V3 v33 = new V3();
                    boolean bl3 = Measure.getNormalFromCenter(p34, p3Array[n2], p3Array[i], p3Array[n12], !bl2, v33, v32);
                    int[] nArray2 = new int[]{bl3 ? n2 : i, bl3 ? i : n2, n12, -7};
                    float f3 = this.checkFacet(p3Array, n, nArray2, v33, p4, v3, v32, hashtable, hashtable2, f, bS2, objectArray);
                    if (f3 != 0.0f) {
                        if (this.isFull && f3 != Float.MAX_VALUE && f3 < 0.5f) {
                            nArray2[3] = (int)(f3 * 100.0f);
                            lst.addLast(nArray2);
                        }
                    } else {
                        v3Array[n3] = v33;
                        nArray[n3] = nArray2;
                        if (bl2) {
                            bS3.set(n3++);
                        } else if (bl) {
                            p3Array[n4] = new P3();
                            p33.setT(p3Array[n4]);
                            p3Array[n4].scaleAdd2(f2, v33, p3);
                            this.addFacet(n2, i, n12, p33, p3Array, v3Array, nArray, n3++, n4, bl3, v32);
                            this.addFacet(n12, n2, i, p33, p3Array, v3Array, nArray, n3++, n4, bl3, v32);
                            this.addFacet(i, n12, n2, p33, p3Array, v3Array, nArray, n3++, n4, bl3, v32);
                            ++n4;
                        } else {
                            ++n3;
                        }
                    }
                    ++n12;
                    ++n11;
                }
            }
        }
        --n4;
        if (Logger.debugging) {
            Logger.info("Polyhedron planeCount=" + n3 + " nPoints=" + n4);
            for (n2 = 0; n2 < n3; ++n2) {
                Logger.info("Polyhedron " + PT.toJSON("face[" + n2 + "]", nArray[n2]));
            }
        }
        return new Polyhedron().set(this.thisID, this.modelIndex, p3, p3Array, n4, n, nArray, n3, this.getFaces(nArray, n3, hashtable), v3Array, bS3, bl, this.distanceRef, this.pointScale);
    }

    private void addFacet(int n, int n2, int n3, P3 p3, P3[] p3Array, V3[] v3Array, int[][] nArray, int n4, int n5, boolean bl, V3 v3) {
        V3 v32 = new V3();
        Measure.getNormalFromCenter(p3Array[n3], p3, p3Array[n], p3Array[n2], false, v32, v3);
        v3Array[n4] = v32;
        nArray[n4] = new int[]{n5, bl ? n : n2, bl ? n2 : n, -2};
    }

    private float checkFacet(P3[] p3Array, int n, int[] nArray, V3 v3, P4 p4, V3 v32, V3 v33, Map<Integer, Object[]> map, Map<String, Object> map2, float f, BS bS, Object[] objectArray) {
        int n2;
        Object[] objectArray2;
        Object object;
        int n3 = nArray[0];
        p4 = Measure.getPlaneThroughPoints(p3Array[n3], p3Array[nArray[1]], p3Array[nArray[2]], v32, v33, p4);
        P3 p3 = p3Array[n3];
        for (int i = 0; i < n; ++i) {
            if (i == n3) continue;
            v33.sub2(p3Array[i], p3);
            v33.normalize();
            float f2 = v33.dot(v32);
            if (!(f2 > 0.02f)) continue;
            return f2;
        }
        Object[] objectArray3 = Integer.valueOf(Normix.getNormixV(v3, bS));
        Object[] objectArray4 = map.get(objectArray3);
        if (objectArray4 == null) {
            object = Normix.getVertexVectors();
            for (Map.Entry<Integer, Object[]> object2 : map.entrySet()) {
                objectArray2 = object2.getKey();
                if (!(object[objectArray2.intValue()].dot(v3) > f)) continue;
                objectArray4 = object2.getValue();
                map.put((Integer)objectArray3, objectArray4);
                objectArray3 = objectArray2;
                break;
            }
            if (objectArray4 == null) {
                objectArray4 = new Object[]{new Lst()};
                map.put((Integer)objectArray3, objectArray4);
            }
        }
        object = (Lst)objectArray4[0];
        for (n2 = 0; n2 < 3; ++n2) {
            objectArray[n2] = this.addEdge((Lst<int[]>)object, map2, (Integer)objectArray3, nArray, n2, p3Array);
            if (objectArray[n2] != null) continue;
            return Float.MAX_VALUE;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            Object object2 = objectArray[n2];
            if (object2 == Boolean.TRUE) continue;
            objectArray2 = (Object[])object2;
            ((Lst)object).addLast((int[])objectArray2[2]);
            map2.put((String)objectArray2[3], objectArray2);
        }
        return 0.0f;
    }

    private Object addEdge(Lst<int[]> lst, Map<String, Object> map, Integer n, int[] nArray, int n2, P3[] p3Array) {
        int n3 = nArray[n2];
        int n4 = nArray[(n2 + 1) % 3];
        String string = "_" + n4;
        String string2 = "_" + n3;
        String string3 = n + string2 + string;
        if (map.containsKey(string3)) {
            return null;
        }
        String string4 = n + string + string2;
        Object object = map.get(string4);
        if (object == null) {
            P3 p3 = p3Array[n4];
            P3 p32 = p3Array[n3];
            this.vAB.sub2(p3, p32);
            int n5 = lst.size();
            while (--n5 >= 0) {
                int[] nArray2 = (int[])lst.get(n5);
                P3 p33 = p3Array[nArray2[0]];
                P3 p34 = p3Array[nArray2[1]];
                if (p33 == p32 || p33 == p3 || p34 == p32 || p34 == p3 || !this.testDiff(p33, p34, p32, p3) || !this.testDiff(p32, p3, p33, p34)) continue;
                return null;
            }
            return new Object[]{nArray, n2, new int[]{n3, n4}, string3};
        }
        int[] nArray3 = (int[])((Object[])object)[0];
        if (nArray3 == null) {
            return null;
        }
        int n6 = (Integer)((Object[])object)[1];
        nArray3[3] = -(-nArray3[3] ^ 1 << n6);
        nArray[3] = -(-nArray[3] ^ 1 << n2);
        int[] nArray4 = (int[])((Object[])object)[2];
        int n7 = lst.size();
        while (--n7 >= 0) {
            int[] nArray5 = (int[])lst.get(n7);
            if (nArray5[0] != nArray4[0] || nArray5[1] != nArray4[1]) continue;
            lst.remove(n7);
            break;
        }
        map.put(string3, new Object[]{null});
        map.put(string4, new Object[]{null});
        return Boolean.TRUE;
    }

    private boolean testDiff(P3 p3, P3 p32, P3 p33, P3 p34) {
        this.vAB.sub2(p32, p3);
        this.vAC.sub2(p33, p3);
        this.vAC.cross(this.vAC, this.vAB);
        this.vBC.sub2(p34, p3);
        this.vBC.cross(this.vBC, this.vAB);
        return this.vBC.dot(this.vAC) < 0.0f;
    }

    private boolean isPlanar(P3 p3, P3 p32, P3 p33, P3 p34) {
        V3 v3 = new V3();
        float f = Measure.getNormalThroughPoints(p3, p32, p33, v3, this.vAB);
        float f2 = Measure.distanceToPlaneV(v3, f, p34);
        return Math.abs(f2) < MAX_DISTANCE_TO_PLANE;
    }

    private int[][] getFaces(int[][] nArray, int n, Map<Integer, Object[]> map) {
        int n2 = map.size();
        int[][] nArray2 = AU.newInt2(n2);
        if (n == n2) {
            int n3 = n;
            while (--n3 >= 0) {
                nArray2[n3] = AU.arrayCopyI(nArray[n3], 3);
            }
            return nArray2;
        }
        int n4 = 0;
        for (Map.Entry<Integer, Object[]> entry : map.entrySet()) {
            Lst lst = (Lst)entry.getValue()[0];
            n2 = lst.size();
            int n5 = n4++;
            int[] nArray3 = new int[n2];
            nArray2[n5] = nArray3;
            int[] nArray4 = nArray3;
            if (n2 < 2) continue;
            int[] nArray5 = (int[])lst.get(0);
            nArray4[0] = nArray5[0];
            nArray4[1] = nArray5[1];
            int n6 = 2;
            int n7 = 1;
            int n8 = -1;
            block2: while (n6 < n2 && n8 != n6) {
                n8 = n6;
                for (int i = n7; i < n2; ++i) {
                    nArray5 = (int[])lst.get(i);
                    if (nArray5[0] != nArray4[n6 - 1]) continue;
                    nArray4[n6++] = nArray5[1];
                    if (i != n7) continue block2;
                    ++n7;
                    continue block2;
                }
            }
        }
        return nArray2;
    }

    @Override
    public void setModelVisibilityFlags(BS bS) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (polyhedron.id == null) {
                int n2 = polyhedron.centralAtom.i;
                if (this.ms.at[n2].isDeleted()) {
                    polyhedron.isValid = false;
                }
                polyhedron.visibilityFlags = polyhedron.visible && bS.get(polyhedron.modelIndex) && !this.ms.isAtomHidden(n2) && !this.ms.at[n2].isDeleted() ? this.vf : 0;
                this.atoms[n2].setShapeVisibility(this.vf, polyhedron.visibilityFlags != 0);
                continue;
            }
            polyhedron.visibilityFlags = polyhedron.visible && (polyhedron.modelIndex < 0 || bS.get(polyhedron.modelIndex)) ? this.vf : 0;
        }
    }

    @Override
    public String getShapeState() {
        int n;
        if (this.polyhedronCount == 0) {
            return "";
        }
        SB sB = new SB();
        for (n = 0; n < this.polyhedronCount; ++n) {
            if (!this.polyhedrons[n].isValid) continue;
            sB.append(this.polyhedrons[n].getState(this.vwr));
        }
        if (this.drawEdges == 2) {
            Polyhedra.appendCmd(sB, "polyhedra frontedges");
        } else if (this.drawEdges == 1) {
            Polyhedra.appendCmd(sB, "polyhedra edges");
        }
        sB.append(this.vwr.getAtomShapeState(this));
        for (n = 0; n < this.polyhedronCount; ++n) {
            Polyhedron polyhedron = this.polyhedrons[n];
            int n2 = polyhedron.centralAtom.i;
            if (!polyhedron.isValid || polyhedron.id != null || polyhedron.colixEdge == 0 || !this.bsColixSet.get(n2)) continue;
            Polyhedra.appendCmd(sB, "select ({" + n2 + "}); color polyhedra " + (C.isColixTranslucent(this.colixes[n2]) ? "translucent " : "") + C.getHexCode(this.colixes[n2]) + " " + C.getHexCode(polyhedron.colixEdge));
        }
        return sB.toString();
    }
}

