/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.java.JavaFunctionNode;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaInteropLanguage;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.reflect.Method;
import java.util.List;

final class InvokeMemberNode
extends RootNode {
    InvokeMemberNode() {
        super(JavaInteropLanguage.class, null, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        JavaInterop.JavaObject receiver = (JavaInterop.JavaObject)ForeignAccess.getReceiver(frame);
        List<Object> args = ForeignAccess.getArguments(frame);
        Object nameOrIndex = args.get(0);
        int argsLength = args.size() - 1;
        if (nameOrIndex instanceof Integer) {
            throw new IllegalStateException();
        }
        String name = (String)nameOrIndex;
        for (Method m : receiver.clazz.getMethods()) {
            boolean isStatic;
            boolean bl = isStatic = (m.getModifiers() & 8) != 0;
            if (isStatic || !m.getName().equals(name) || m.getParameterTypes().length != argsLength) continue;
            Object[] arr = args.subList(1, args.size()).toArray();
            return JavaFunctionNode.execute(m, receiver.obj, arr);
        }
        throw new IllegalArgumentException(name);
    }
}

