/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import org.apache.commons.lang3.StringUtils;
import org.sejda.model.exception.SejdaRuntimeException;

public final class AdapterUtils {
    private static final String ALL = "all";
    private static final String DEFAULT_SEPARATOR = ":";

    private AdapterUtils() {
    }

    public static int parseInt(String input, String explainedInput) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            throw new SejdaRuntimeException("Unrecognized " + explainedInput + ": '" + input + "'", e);
        }
    }

    public static String[] split(String input) {
        return StringUtils.split(input, DEFAULT_SEPARATOR);
    }

    public static String[] splitAndTrim(String input) {
        return StringUtils.split(StringUtils.trim(input), DEFAULT_SEPARATOR);
    }

    public static String[] splitAndTrim(String input, String separator) {
        return StringUtils.split(StringUtils.trim(input), separator);
    }

    public static Integer parseIntSilently(String input) {
        try {
            return Integer.valueOf(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isAllPages(String rawString) {
        return StringUtils.equalsIgnoreCase(ALL, rawString);
    }
}

