/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.httpclient;

import ch.csnc.extension.httpclient.AliasKeyManager;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.util.reflection.Whitebox;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KeyStore.class})
public class AliasKeyManagerUnitTest {
    private static final String ALIAS = "alias";
    private static final String PASSWORD = "password";
    private AliasKeyManager aliasKeyManager;
    private KeyStore keyStore;
    @Mock
    private KeyStoreSpi keyStoreSpi;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.keyStore = (KeyStore)PowerMockito.mock(KeyStore.class);
        Whitebox.setInternalState((Object)this.keyStore, (String)"initialized", (Object)true);
        Whitebox.setInternalState((Object)this.keyStore, (String)"keyStoreSpi", (Object)this.keyStoreSpi);
    }

    @Test
    public void shouldAlwaysChooseInitiallyGivenAliasAsClientAlias() {
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        String string = this.aliasKeyManager.chooseClientAlias(new String[0], new Principal[]{(Principal)Mockito.mock(Principal.class)}, (Socket)Mockito.mock(Socket.class));
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ALIAS)));
    }

    @Test
    public void shouldOnlyReturnInitiallyGivenAliasAsClientAlias() {
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        String[] stringArray = this.aliasKeyManager.getClientAliases("", new Principal[]{(Principal)Mockito.mock(Principal.class)});
        Assert.assertThat((Object)stringArray.length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)stringArray, (Matcher)Matchers.hasItemInArray((Object)ALIAS));
    }

    @Test
    public void shouldAlwaysChooseInitiallyGivenAliasAsServerAlias() {
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        String string = this.aliasKeyManager.chooseServerAlias("", new Principal[]{(Principal)Mockito.mock(Principal.class)}, (Socket)Mockito.mock(Socket.class));
        Assert.assertThat((Object)string, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ALIAS)));
    }

    @Test
    public void shouldOnlyReturnInitiallyGivenAliasAsServerAlias() {
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        String[] stringArray = this.aliasKeyManager.getServerAliases("", new Principal[]{(Principal)Mockito.mock(Principal.class)});
        Assert.assertThat((Object)stringArray, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)1)));
        Assert.assertThat((Object)stringArray, (Matcher)Matchers.is((Matcher)Matchers.arrayContaining((Object[])new String[]{ALIAS})));
    }

    @Test
    public void shouldReturnNullWhenNoCertificatesAreFound() throws Exception {
        BDDMockito.given((Object)this.keyStoreSpi.engineGetCertificateChain(ALIAS)).willReturn(null);
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        X509Certificate[] x509CertificateArray = this.aliasKeyManager.getCertificateChain(ALIAS);
        Assert.assertThat((Object)x509CertificateArray, (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void shouldReturnCertificatesFromKeyStoreAsX509Certificates() throws Exception {
        Object[] objectArray = new Certificate[]{(Certificate)Mockito.mock(X509Certificate.class), (Certificate)Mockito.mock(X509Certificate.class)};
        BDDMockito.given((Object)this.keyStoreSpi.engineGetCertificateChain(ALIAS)).willReturn((Object)objectArray);
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        X509Certificate[] x509CertificateArray = this.aliasKeyManager.getCertificateChain(ALIAS);
        Assert.assertThat((Object)x509CertificateArray, (Matcher)Matchers.is((Matcher)Matchers.arrayWithSize((int)2)));
        Assert.assertThat((Object)x509CertificateArray, (Matcher)Matchers.arrayContaining((Object[])objectArray));
    }

    @Test
    public void shouldReturnNullAsCertificatesWhenExceptionOccursAccessingKeyStore() throws Exception {
        BDDMockito.given((Object)this.keyStoreSpi.engineGetCertificateChain(ALIAS)).willThrow(new Class[]{KeyStoreException.class});
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        X509Certificate[] x509CertificateArray = this.aliasKeyManager.getCertificateChain(ALIAS);
        Assert.assertThat((Object)x509CertificateArray, (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void shouldReturnNullAsKeyWhenExceptionOccursAccessingKeyStore() throws Exception {
        BDDMockito.given((Object)this.keyStoreSpi.engineGetKey(ALIAS, PASSWORD.toCharArray())).willThrow(new Class[]{KeyStoreException.class, NoSuchAlgorithmException.class, UnrecoverableKeyException.class});
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        Assert.assertThat((Object)this.aliasKeyManager.getPrivateKey(ALIAS), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
        Assert.assertThat((Object)this.aliasKeyManager.getPrivateKey(ALIAS), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
        Assert.assertThat((Object)this.aliasKeyManager.getPrivateKey(ALIAS), (Matcher)Matchers.is((Matcher)Matchers.equalTo(null)));
    }

    @Test
    public void shouldReturnPrivateKeyFromKeyStore() throws Exception {
        Key key = (Key)Mockito.mock(PrivateKey.class);
        BDDMockito.given((Object)this.keyStoreSpi.engineGetKey(ALIAS, PASSWORD.toCharArray())).willReturn((Object)key);
        this.aliasKeyManager = new AliasKeyManager(this.keyStore, ALIAS, PASSWORD);
        Assert.assertThat((Object)this.aliasKeyManager.getPrivateKey(ALIAS), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)key)));
    }
}

