/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.spider.URLResolver;

public class URLResolverRfc1808ExamplesUnitTest {
    @Test
    public void resolveRfc1808NormalExamples() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g:h"), (Matcher)Matchers.is((Object)"g:h"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g"), (Matcher)Matchers.is((Object)"http://a/b/c/g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "./g"), (Matcher)Matchers.is((Object)"http://a/b/c/g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g/"), (Matcher)Matchers.is((Object)"http://a/b/c/g/"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "/g"), (Matcher)Matchers.is((Object)"http://a/g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "//g"), (Matcher)Matchers.is((Object)"http://g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "?y"), (Matcher)Matchers.is((Object)"http://a/b/c/d;p?y"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g?y"), (Matcher)Matchers.is((Object)"http://a/b/c/g?y"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g?y/./x"), (Matcher)Matchers.is((Object)"http://a/b/c/g?y/./x"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "#s"), (Matcher)Matchers.is((Object)"http://a/b/c/d;p?q#s"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g#s"), (Matcher)Matchers.is((Object)"http://a/b/c/g#s"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g#s/./x"), (Matcher)Matchers.is((Object)"http://a/b/c/g#s/./x"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g?y#s"), (Matcher)Matchers.is((Object)"http://a/b/c/g?y#s"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", ";x"), (Matcher)Matchers.is((Object)"http://a/b/c/d;x"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g;x"), (Matcher)Matchers.is((Object)"http://a/b/c/g;x"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g;x?y#s"), (Matcher)Matchers.is((Object)"http://a/b/c/g;x?y#s"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "."), (Matcher)Matchers.is((Object)"http://a/b/c/"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "./"), (Matcher)Matchers.is((Object)"http://a/b/c/"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", ".."), (Matcher)Matchers.is((Object)"http://a/b/"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "../"), (Matcher)Matchers.is((Object)"http://a/b/"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "../g"), (Matcher)Matchers.is((Object)"http://a/b/g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "../.."), (Matcher)Matchers.is((Object)"http://a/"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "../../"), (Matcher)Matchers.is((Object)"http://a/"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "../../g"), (Matcher)Matchers.is((Object)"http://a/g"));
    }

    @Test
    public void resolveRfc1808AbnormalExamples() {
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", ""), (Matcher)Matchers.is((Object)"http://a/b/c/d;p?q#f"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "../../../g"), (Matcher)Matchers.is((Object)"http://a/g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "../../../../g"), (Matcher)Matchers.is((Object)"http://a/g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "/../g"), (Matcher)Matchers.is((Object)"http://a/g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "/./g"), (Matcher)Matchers.is((Object)"http://a/./g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g."), (Matcher)Matchers.is((Object)"http://a/b/c/g."));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", ".g"), (Matcher)Matchers.is((Object)"http://a/b/c/.g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g.."), (Matcher)Matchers.is((Object)"http://a/b/c/g.."));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "..g"), (Matcher)Matchers.is((Object)"http://a/b/c/..g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "./../g"), (Matcher)Matchers.is((Object)"http://a/b/g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "./g/."), (Matcher)Matchers.is((Object)"http://a/b/c/g/"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g/./h"), (Matcher)Matchers.is((Object)"http://a/b/c/g/h"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "g/../h"), (Matcher)Matchers.is((Object)"http://a/b/c/h"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "http:g"), (Matcher)Matchers.is((Object)"http:g"));
        Assert.assertThat((Object)URLResolver.resolveUrl("http://a/b/c/d;p?q#f", "http:"), (Matcher)Matchers.is((Object)"http:"));
    }
}

