/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class RaiseAtom
extends Atom {
    private Atom base;
    private int runit;
    private int hunit;
    private int dunit;
    private float r;
    private float h;
    private float d;

    public RaiseAtom(Atom atom, int n, float f, int n2, float f2, int n3, float f3) {
        this.base = atom;
        this.runit = n;
        this.r = f;
        this.hunit = n2;
        this.h = f2;
        this.dunit = n3;
        this.d = f3;
    }

    public int getLeftType() {
        return this.base.getLeftType();
    }

    public int getRightType() {
        return this.base.getRightType();
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box = this.base.createBox(teXEnvironment);
        if (this.runit == -1) {
            box.setShift(0.0f);
        } else {
            box.setShift(-this.r * SpaceAtom.getFactor(this.runit, teXEnvironment));
        }
        if (this.hunit == -1) {
            return box;
        }
        HorizontalBox horizontalBox = new HorizontalBox(box);
        horizontalBox.setHeight(this.h * SpaceAtom.getFactor(this.hunit, teXEnvironment));
        if (this.dunit == -1) {
            horizontalBox.setDepth(0.0f);
        } else {
            horizontalBox.setDepth(this.d * SpaceAtom.getFactor(this.dunit, teXEnvironment));
        }
        return horizontalBox;
    }
}

