/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.VerticalBox;

public class UnderOverAtom
extends Atom {
    private final Atom base;
    private final Atom under;
    private final Atom over;
    private final float underSpace;
    private final float overSpace;
    private final int underUnit;
    private final int overUnit;
    private final boolean underScriptSize;
    private final boolean overScriptSize;

    public UnderOverAtom(Atom atom, Atom atom2, int n, float f, boolean bl, boolean bl2) {
        SpaceAtom.checkUnit(n);
        this.base = atom;
        this.type = this.type;
        if (bl2) {
            this.under = null;
            this.underSpace = 0.0f;
            this.underUnit = 0;
            this.underScriptSize = false;
            this.over = atom2;
            this.overUnit = n;
            this.overSpace = f;
            this.overScriptSize = bl;
        } else {
            this.under = atom2;
            this.underUnit = n;
            this.underSpace = f;
            this.underScriptSize = bl;
            this.overSpace = 0.0f;
            this.over = null;
            this.overUnit = 0;
            this.overScriptSize = false;
        }
    }

    public UnderOverAtom(Atom atom, Atom atom2, int n, float f, boolean bl, Atom atom3, int n2, float f2, boolean bl2) throws InvalidUnitException {
        SpaceAtom.checkUnit(n);
        SpaceAtom.checkUnit(n2);
        this.base = atom;
        this.under = atom2;
        this.underUnit = n;
        this.underSpace = f;
        this.underScriptSize = bl;
        this.over = atom3;
        this.overUnit = n2;
        this.overSpace = f2;
        this.overScriptSize = bl2;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        Box box = this.base == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.base.createBox(teXEnvironment);
        Box box2 = null;
        Box box3 = null;
        float f = box.getWidth();
        if (this.over != null) {
            box2 = this.over.createBox(this.overScriptSize ? teXEnvironment.subStyle() : teXEnvironment);
            f = Math.max(f, box2.getWidth());
        }
        if (this.under != null) {
            box3 = this.under.createBox(this.underScriptSize ? teXEnvironment.subStyle() : teXEnvironment);
            f = Math.max(f, box3.getWidth());
        }
        VerticalBox verticalBox = new VerticalBox();
        teXEnvironment.setLastFontId(box.getLastFontId());
        if (this.over != null) {
            verticalBox.add(UnderOverAtom.changeWidth(box2, f));
            verticalBox.add(new SpaceAtom(this.overUnit, 0.0f, this.overSpace, 0.0f).createBox(teXEnvironment));
        }
        Box box4 = UnderOverAtom.changeWidth(box, f);
        verticalBox.add(box4);
        float f2 = verticalBox.getHeight() + verticalBox.getDepth() - box4.getDepth();
        if (this.under != null) {
            verticalBox.add(new SpaceAtom(this.overUnit, 0.0f, this.underSpace, 0.0f).createBox(teXEnvironment));
            verticalBox.add(UnderOverAtom.changeWidth(box3, f));
        }
        verticalBox.setDepth(verticalBox.getHeight() + verticalBox.getDepth() - f2);
        verticalBox.setHeight(f2);
        return verticalBox;
    }

    private static Box changeWidth(Box box, float f) {
        if (box != null && Math.abs(f - box.getWidth()) > 1.0E-7f) {
            return new HorizontalBox(box, f, 2);
        }
        return box;
    }

    public int getLeftType() {
        return this.base.getLeftType();
    }

    public int getRightType() {
        return this.base.getRightType();
    }
}

