/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.HorizontalRule;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class VlineAtom
extends Atom {
    private float height;
    private float shift;
    private int n;

    public VlineAtom(int n) {
        this.n = n;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public void setShift(float f) {
        this.shift = f;
    }

    public float getWidth(TeXEnvironment teXEnvironment) {
        if (this.n != 0) {
            float f = teXEnvironment.getTeXFont().getDefaultRuleThickness(teXEnvironment.getStyle());
            return f * (float)(3 * this.n - 2);
        }
        return 0.0f;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        if (this.n != 0) {
            float f = teXEnvironment.getTeXFont().getDefaultRuleThickness(teXEnvironment.getStyle());
            HorizontalRule horizontalRule = new HorizontalRule(this.height, f, this.shift);
            StrutBox strutBox = new StrutBox(2.0f * f, 0.0f, 0.0f, 0.0f);
            HorizontalBox horizontalBox = new HorizontalBox();
            for (int i = 0; i < this.n - 1; ++i) {
                horizontalBox.add(horizontalRule);
                horizontalBox.add(strutBox);
            }
            if (this.n > 0) {
                horizontalBox.add(horizontalRule);
            }
            return horizontalBox;
        }
        return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

