/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class FrozenString
extends StringLiteral {
    public FrozenString(ByteList byteList, int cr) {
        super(byteList, cr);
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.FROZEN_STRING;
    }

    public FrozenString(String s2) {
        super(s2);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        return context.runtime.freezeAndDedupString(RubyString.newString(context.runtime, this.bytelist, this.coderange));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof FrozenString && this.bytelist.equals(((FrozenString)other).bytelist) && this.coderange == ((FrozenString)other).coderange;
    }

    @Override
    public String toString() {
        return "frozen:\"" + this.bytelist + "\"";
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.FrozenString(this);
    }

    public static FrozenString decode(IRReaderDecoder d) {
        return new FrozenString(d.decodeByteList(), d.decodeInt());
    }
}

