/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.globals.ReadThreadLocalGlobalVariableNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

public class UpdateLastBacktraceNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    @Node.Child
    private ReadThreadLocalGlobalVariableNode getLastExceptionNode;
    @Node.Child
    private CallDispatchHeadNode setBacktraceNode;

    public UpdateLastBacktraceNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child = child;
        this.getLastExceptionNode = new ReadThreadLocalGlobalVariableNode(context, sourceSection, "$!");
        this.setBacktraceNode = DispatchHeadNodeFactory.createMethodCall(this.getContext());
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object lastException = this.getLastExceptionNode.execute(frame);
        if (lastException == this.nil()) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("$! is not set", this));
        }
        Object newBacktrace = this.child.execute(frame);
        this.setBacktraceNode.call(frame, lastException, "set_backtrace", null, newBacktrace);
        return newBacktrace;
    }
}

