/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sa;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.model.AbstractModelProvider;
import com.sun.tools.visualvm.coredump.CoreDump;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.sa.SaModelImpl;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModel;
import com.sun.tools.visualvm.tools.jvmstat.JvmJvmstatModelFactory;
import com.sun.tools.visualvm.tools.sa.SaModel;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaModelProvider
extends AbstractModelProvider<SaModel, DataSource> {
    private static final Logger LOGGER = Logger.getLogger(SaModelProvider.class.getName());
    private static final String SA_JAR = "lib/sa-jdi.jar";

    SaModelProvider() {
    }

    public SaModel createModelFor(DataSource ds) {
        if (ds instanceof Application) {
            Application app = (Application)ds;
            if (Host.LOCALHOST.equals((Object)app.getHost())) {
                File jdkHome;
                File saJar;
                JvmJvmstatModel jvmstat = JvmJvmstatModelFactory.getJvmstatModelFor((Application)app);
                if (jvmstat != null && Utilities.isWindows()) {
                    Boolean this64bitArch = SaModelProvider.is64BitArchitecture();
                    Boolean app64bitArch = SaModelProvider.is64BitArchitecture(jvmstat);
                    if (this64bitArch != null && app64bitArch != null && !this64bitArch.equals(app64bitArch)) {
                        return null;
                    }
                }
                if ((saJar = SaModelProvider.getSaJar(jdkHome = this.getJdkHome(jvmstat))) == null) {
                    return null;
                }
                try {
                    return new SaModelImpl(jdkHome, saJar, app.getPid());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Error getting SA agent", ex);
                    return null;
                }
            }
        } else if (ds instanceof CoreDump) {
            CoreDump coredump = (CoreDump)ds;
            File executable = new File(coredump.getExecutable());
            File coreFile = coredump.getFile();
            if (executable.exists() && coreFile.exists()) {
                File jdkHome = executable.getParentFile().getParentFile();
                File saJar = SaModelProvider.getSaJar(jdkHome);
                if (saJar == null) {
                    return null;
                }
                try {
                    return new SaModelImpl(jdkHome, saJar, executable, coreFile);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.INFO, "Unable to retrieve SA agent", ex);
                    return null;
                }
            }
        }
        return null;
    }

    private File getJdkHome(JvmJvmstatModel jvmstat) {
        File jdkHome = new File(jvmstat.getJavaHome());
        if ("jre".equals(jdkHome.getName())) {
            jdkHome = jdkHome.getParentFile();
        }
        return jdkHome;
    }

    static File getSaJar(File jdkHome) {
        File saJar = new File(jdkHome, SA_JAR);
        try {
            if (saJar.exists()) {
                return saJar.getCanonicalFile();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, saJar.getPath(), ex);
        }
        return null;
    }

    private static Boolean is64BitArchitecture(JvmJvmstatModel jvmstat) {
        String name = jvmstat.getVmName();
        if (name != null) {
            return name.toLowerCase().contains("64-bit");
        }
        return null;
    }

    private static Boolean is64BitArchitecture() {
        String thisArch = System.getProperty("sun.arch.data.model");
        if (thisArch != null) {
            return "64".equals(thisArch);
        }
        return null;
    }
}

