/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Sheet
extends ProteinStructure {
    V3 widthUnitVector;
    V3 heightUnitVector;

    Sheet(AlphaPolymer alphaPolymer, int n, int n2, STR sTR) {
        this.setupPS(alphaPolymer, STR.SHEET, n, n2);
        this.subtype = sTR;
    }

    @Override
    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.nRes == 2) {
            this.axisA = this.apolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.apolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new P3();
            this.apolymer.getLeadMidPoint(this.monomerIndexFirst + this.nRes - 1, this.axisB);
        }
        this.axisUnitVector = new V3();
        this.axisUnitVector.sub2(this.axisB, this.axisA);
        this.axisUnitVector.normalize();
        P3 p3 = new P3();
        this.apolymer.getLeadMidPoint(this.monomerIndexFirst, p3);
        if (this.notHelixOrSheet(this.monomerIndexFirst - 1)) {
            Measure.projectOntoAxis(p3, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        P3 p32 = new P3();
        this.apolymer.getLeadMidPoint(this.monomerIndexFirst + this.nRes, p32);
        if (this.notHelixOrSheet(this.monomerIndexFirst + this.nRes)) {
            Measure.projectOntoAxis(p32, this.axisA, this.axisUnitVector, this.vectorProjection);
        }
        this.axisA = p3;
        this.axisB = p32;
    }

    private boolean notHelixOrSheet(int n) {
        return n < 0 || n >= this.apolymer.monomerCount || !this.apolymer.monomers[n].isHelix() && !this.apolymer.monomers[n].isSheet();
    }

    void calcSheetUnitVectors() {
        if (!(this.apolymer instanceof AminoPolymer)) {
            return;
        }
        if (this.widthUnitVector == null) {
            V3 v3 = new V3();
            V3 v32 = new V3();
            AminoMonomer aminoMonomer = (AminoMonomer)this.apolymer.monomers[this.monomerIndexFirst];
            v32.sub2(aminoMonomer.getCarbonylOxygenAtom(), aminoMonomer.getCarbonylCarbonAtom());
            int n = this.nRes;
            while (--n > this.monomerIndexFirst) {
                aminoMonomer = (AminoMonomer)this.apolymer.monomers[n];
                v3.sub2(aminoMonomer.getCarbonylOxygenAtom(), aminoMonomer.getCarbonylCarbonAtom());
                if (v32.angle(v3) < 1.5707964f) {
                    v32.add(v3);
                    continue;
                }
                v32.sub(v3);
            }
            this.heightUnitVector = v3;
            this.heightUnitVector.cross(this.axisUnitVector, v32);
            this.heightUnitVector.normalize();
            this.widthUnitVector = v32;
            this.widthUnitVector.cross(this.axisUnitVector, this.heightUnitVector);
        }
    }

    public void setBox(float f, float f2, P3 p3, V3 v3, V3 v32, P3 p32, float f3) {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        v3.setT(this.widthUnitVector);
        v3.scale(f3 * f);
        v32.setT(this.heightUnitVector);
        v32.scale(f3 * f2);
        p32.ave(v3, v32);
        p32.sub2(p3, p32);
    }
}

