/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;

public class QS {
    public static final int S = 0;
    public static final int P = 1;
    public static final int SP = 2;
    public static final int DS = 3;
    public static final int DC = 4;
    public static final int FS = 5;
    public static final int FC = 6;
    public static final int GS = 7;
    public static final int GC = 8;
    public static final int HS = 9;
    public static final int HC = 10;
    public static final int IS = 11;
    public static final int IC = 12;
    public static int MAX_TYPE_SUPPORTED = 6;
    private static final int MAXID = 13;
    public static final int[] idSpherical = new int[]{0, 1, 2, 3, 3, 5, 5, 7, 7, 9, 9, 11, 11};
    public static final String[] tags = new String[]{"S", "P", "SP", "5D", "D", "7F", "F", "9G", "G", "11H", "H", "13I", "I"};
    public static final String[] tags2 = new String[]{"S", "X", "SP", "5D", "XX", "7F", "XXX", "9G", "XXXX", "11H", "XXXXX", "13I", "XXXXXX"};
    public static final String CANONICAL_DC_LIST = "DXX   DYY   DZZ   DXY   DXZ   DYZ";
    public static final String CANONICAL_DS_LIST = "d0    d1+   d1-   d2+   d2-";
    public static final String CANONICAL_FC_LIST = "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ";
    public static final String CANONICAL_FS_LIST = "f0    f1+   f1-   f2+   f2-   f3+   f3-";

    public static boolean isQuantumBasisSupported(char c) {
        return "SPLDF".indexOf(Character.toUpperCase(c)) >= 0;
    }

    public static int[][] getNewDfCoefMap() {
        return new int[][]{new int[1], new int[3], new int[4], new int[5], new int[6], new int[7], new int[10], new int[9], new int[15], new int[11], new int[21], new int[13], new int[28]};
    }

    public static int getItem(int n) {
        return n >= 0 && n < 13 ? n : -1;
    }

    public static int getQuantumShellTagID(String string) {
        return string.equals("L") ? 2 : QS.getQuantumShell(string);
    }

    private static int getQuantumShell(String string) {
        for (int i = 0; i < 13; ++i) {
            if (!tags[i].equals(string) && !tags2[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static final int getQuantumShellTagIDSpherical(String string) {
        if (string.equals("L")) {
            return 2;
        }
        int n = QS.getQuantumShell(string);
        return n < 0 ? n : idSpherical[n];
    }

    public static final String getQuantumShellTag(int n) {
        return n >= 0 && n < 13 ? tags[n] : "" + n;
    }

    public static final String getMOString(float[] fArray) {
        SB sB = new SB();
        if (fArray.length == 2) {
            return "" + (int)(fArray[0] < 0.0f ? -fArray[1] : fArray[1]);
        }
        sB.appendC('[');
        for (int i = 0; i < fArray.length; i += 2) {
            if (i > 0) {
                sB.append(", ");
            }
            sB.appendF(fArray[i]).append(" ").appendI((int)fArray[i + 1]);
        }
        sB.appendC(']');
        return sB.toString();
    }

    public void setNboLabels(String[] stringArray, int n, Lst<Map<String, Object>> lst, int n2, String string) {
        for (int i = 0; i < stringArray.length; i += n + 2) {
            if (string.indexOf(stringArray[i]) < 0) continue;
            for (int j = 0; j < n; ++j) {
                Map map = (Map)lst.get(j + n2);
                String string2 = stringArray[i + j + 2];
                map.put("type", string + " " + string2);
                map.put("occupancy", Float.valueOf(string2.indexOf("*") >= 0 || string2.indexOf("(ry)") >= 0 ? 0.0f : 2.0f));
            }
            return;
        }
    }

    public static boolean createDFMap(int[] nArray, String string, String string2, int n) {
        String[] stringArray = PT.getTokens(string);
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            String string3 = stringArray[i];
            if (string3.length() < n || (n2 = string2.indexOf(string3)) < 0) {
                bl = false;
                break;
            }
            nArray[n2 /= 6] = i - n2;
        }
        if (!bl) {
            nArray[0] = Integer.MIN_VALUE;
        }
        return bl;
    }
}

