/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import javajs.util.Lst;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.smiles.SmilesRing;
import org.jmol.smiles.SmilesRingSet;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.Node;

public class SmilesAromatic {
    private static final int[][] OS_PI_COUNTS = new int[][]{{-2, 1, 0}, {1, 2, 1, -1}, {2, 1, 2, 1, 1}, {2, 1}, {-2, 1, 2, 1, -2}, {2, 1, 2, 2}};

    static void setAromatic(int n, Node[] nodeArray, BS bS, Lst<Object> lst, BS bS2, int n2, boolean bl, boolean bl2, VTemp vTemp, Lst<BS> lst2, Lst<SmilesRing> lst3, int[] nArray, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = bl || n2 > 0;
        if (!bl3) {
            int n3 = lst.size();
            while (--n3 >= 0) {
                BS bS3 = BSUtil.copy((BS)lst.get(n3));
                bS3.and(bS2);
                if (bS3.cardinality() != n) continue;
                lst2.addLast(bS3);
            }
            return;
        }
        int n4 = lst.size();
        block6: while (--n4 >= 0) {
            BS bS4 = (BS)lst.get(n4);
            boolean bl6 = SmilesAromatic.isSp2Ring(n, nodeArray, bS, bS4, !bl2 ? Float.MAX_VALUE : (n2 > 0 ? 0.1f : 0.01f), n2 == 0);
            if (!bl6) continue;
            bS2.or(bS4);
            if (bl4) {
                Lst<Edge> lst4 = new Lst<Edge>();
                int n5 = bS4.nextSetBit(0);
                while (n5 >= 0) {
                    Node node = nodeArray[n5];
                    Edge[] edgeArray = node.getEdges();
                    int n6 = node.getIndex();
                    int n7 = edgeArray.length;
                    while (--n7 >= 0) {
                        Node node2 = edgeArray[n7].getOtherAtomNode(node);
                        int n8 = node2.getIndex();
                        if (n8 <= n6 || !bS4.get(n8)) continue;
                        lst4.addLast(edgeArray[n7]);
                    }
                    n5 = bS4.nextSetBit(n5 + 1);
                }
                switch (SmilesAromatic.checkHueckelAromatic(n, nodeArray, bS2, bS4, n2, nArray)) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        bl6 = false;
                    }
                    case 1: {
                        if (lst3 != null) {
                            lst3.addLast(new SmilesRing(n, bS4, lst4, bl6));
                        }
                        if (bl6) break;
                        continue block6;
                    }
                }
            }
            lst2.addLast(bS4);
        }
    }

    static void checkAromaticDefined(Node[] nodeArray, BS bS, BS bS2) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Edge[] edgeArray = nodeArray[n].getEdges();
            for (int i = 0; i < edgeArray.length; ++i) {
                switch (edgeArray[i].order) {
                    case 513: 
                    case 514: 
                    case 515: {
                        bS2.set(edgeArray[i].getAtomIndex1());
                        bS2.set(edgeArray[i].getAtomIndex2());
                    }
                }
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    private static final boolean isSp2Ring(int n, Node[] nodeArray, BS bS, BS bS2, float f, boolean bl) {
        Object object;
        Object object2;
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            object2 = nodeArray[n2];
            object = object2.getEdges();
            if (((Edge[])object).length > 3) {
                return false;
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
        if (f == Float.MAX_VALUE) {
            return true;
        }
        if (f <= 0.0f) {
            f = 0.01f;
        }
        V3 v3 = new V3();
        object2 = new V3();
        object = new V3();
        V3 v32 = null;
        int n3 = bS2.cardinality();
        V3[] v3Array = new V3[n3 * 2];
        int n4 = 0;
        float f2 = 1.0f - f * 5.0f;
        int n5 = bS2.nextSetBit(0);
        while (n5 >= 0) {
            int n6;
            Node node = nodeArray[n5];
            Edge[] edgeArray = node.getEdges();
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = edgeArray.length;
            while (--n10 >= 0) {
                n6 = node.getBondedAtomIndex(n10);
                if (!bS.get(n6)) continue;
                if (!bS2.get(n6)) {
                    if (node.getElementNumber() == 16) {
                        if (!bl) {
                            return false;
                        }
                        n6 = -1;
                    }
                    n7 = n6;
                    continue;
                }
                if (n8 < 0) {
                    n8 = n6;
                    continue;
                }
                n9 = n6;
            }
            if (v32 == null) {
                v32 = new V3();
            }
            n6 = n5;
            for (n10 = 0; n10 < 2; ++n10) {
                SmilesSearch.getNormalThroughPoints(nodeArray[n8], nodeArray[n6], nodeArray[n9], v3, (V3)object2, (V3)object);
                if (!SmilesAromatic.addNormal(v3, v32, f2)) {
                    return false;
                }
                v3Array[n4++] = V3.newV(v3);
                n6 = n7;
                if (n6 < 0) break;
            }
            n5 = bS2.nextSetBit(n5 + 1);
        }
        return SmilesAromatic.checkStandardDeviation(v3Array, v32, n4, f);
    }

    private static final boolean addNormal(V3 v3, V3 v32, float f) {
        float f2 = v32.dot(v3);
        if (f2 != 0.0f && Math.abs(f2) < f) {
            return false;
        }
        if (f2 < 0.0f) {
            v3.scale(-1.0f);
        }
        v32.add(v3);
        v32.normalize();
        return true;
    }

    private static final boolean checkStandardDeviation(V3[] v3Array, V3 v3, int n, float f) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            float f2 = v3Array[i].dot(v3);
            d += (double)f2;
            d2 += (double)f2 * (double)f2;
        }
        return (d = Math.sqrt((d2 - d * d / (double)n) / (double)(n - 1))) < (double)f;
    }

    private static int checkHueckelAromatic(int n, Node[] nodeArray, BS bS, BS bS2, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = 0;
        int n5 = bS2.nextSetBit(0);
        while (n5 >= 0 && n3 >= 0) {
            int n6;
            Node node = nodeArray[n5];
            int n7 = node.getElementNumber();
            int n8 = node.getCovalentBondCount() + node.getMissingHydrogenCount() + node.getValence() - 4;
            if (n7 == 6 && (n6 = node.getFormalCharge()) != Integer.MIN_VALUE) {
                n8 += n6;
            }
            int n9 = n7 >= 5 && n7 <= 8 ? n7 - 5 : (n7 == 15 ? 2 : (n7 == 34 ? 3 : (n7 == 33 ? 4 : (n6 = n7 == 16 ? 5 : -1))));
            if (n6 >= 0) {
                int[] nArray2 = OS_PI_COUNTS[n6];
                if (n8 < 0 || n8 >= nArray2.length) {
                    return -1;
                }
                n8 = nArray2[n8];
                block0 : switch (n8) {
                    case -2: {
                        return -1;
                    }
                    case -1: {
                        Edge[] edgeArray = node.getEdges();
                        n8 = 0;
                        int n10 = edgeArray.length;
                        while (--n10 >= 0) {
                            Edge edge = edgeArray[n10];
                            if (edge.getCovalentOrder() != 2) continue;
                            Node node2 = edge.getOtherAtomNode(node);
                            n8 = node2.getElementNumber() == 6 || bS.get(node2.getIndex()) ? 1 : (n2 > 0 ? -100 : 0);
                            break block0;
                        }
                        break;
                    }
                }
                if (n8 < 0) {
                    return -1;
                }
                if (nArray != null) {
                    nArray[n5] = n8;
                }
                n3 += n8;
                if (n8 == 1) {
                    ++n4;
                }
                if (Logger.debugging) {
                    Logger.info("atom " + node + " pi=" + n8 + " npi=" + n3);
                }
            }
            n5 = bS2.nextSetBit(n5 + 1);
        }
        return (n3 - 2) % 4 == 0 && (n2 < 2 || n == 5 || n4 == 6) ? 1 : 0;
    }

    static void finalizeAromatic(Node[] nodeArray, BS bS, Lst<BS> lst, Lst<SmilesRing> lst2, int[] nArray, boolean bl, boolean bl2) {
        if (bl2) {
            SmilesAromatic.removeBridgingRings(lst, lst2);
        }
        SmilesAromatic.checkFusedRings(lst2, nArray, lst);
        bS.clearAll();
        int n = lst.size();
        while (--n >= 0) {
            bS.or((BS)lst.get(n));
        }
        if (bl2 || bl) {
            n = bS.nextSetBit(0);
            while (n >= 0) {
                Edge[] edgeArray = nodeArray[n].getEdges();
                int n2 = 0;
                int n3 = edgeArray.length;
                while (--n3 >= 0) {
                    Node node = edgeArray[n3].getOtherAtomNode(nodeArray[n]);
                    int n4 = edgeArray[n3].getCovalentOrder();
                    int n5 = node.getIndex();
                    boolean bl3 = bS.get(n5);
                    if (bl3) {
                        if (n4 == 2) {
                            boolean bl4 = false;
                            int n6 = lst2.size();
                            while (--n6 >= 0) {
                                SmilesRing smilesRing = (SmilesRing)lst2.get(n6);
                                if (!smilesRing.get(n) || !smilesRing.get(n5)) continue;
                                bl4 = true;
                                break;
                            }
                            if (!bl4) {
                                n2 = -1;
                                break;
                            }
                        }
                        ++n2;
                        continue;
                    }
                    if (!bl2 || node.getElementNumber() != 6 || n4 != 2) continue;
                    n2 = -1;
                    break;
                }
                if (n2 < 2) {
                    bS.clear(n);
                    n = -1;
                }
                n = bS.nextSetBit(n + 1);
            }
        }
    }

    private static void removeBridgingRings(Lst<BS> lst, Lst<SmilesRing> lst2) {
        BS bS = new BS();
        BS bS2 = new BS();
        BS bS3 = new BS();
        SmilesAromatic.checkBridges(lst, bS2, lst, bS2, bS);
        SmilesAromatic.checkBridges(lst2, bS3, lst2, bS3, bS);
        SmilesAromatic.checkBridges(lst, bS2, lst2, bS3, bS);
        int n = lst.size();
        while (--n >= 0) {
            if (!bS2.get(n)) continue;
            lst.remove(n);
        }
        n = lst2.size();
        while (--n >= 0) {
            if (!bS3.get(n)) continue;
            lst2.remove(n);
        }
    }

    private static void checkBridges(Lst<?> lst, BS bS, Lst<?> lst2, BS bS2, BS bS3) {
        boolean bl = lst == lst2;
        int n = lst.size();
        while (--n >= 0) {
            BS bS4 = (BS)lst.get(n);
            int n2 = bl ? n + 1 : 0;
            int n3 = lst2.size();
            while (--n3 >= n2) {
                BS bS5 = (BS)lst2.get(n3);
                if (bS5.equals(bS4)) continue;
                bS3.clearAll();
                bS3.or(bS4);
                bS3.and(bS5);
                int n4 = bS3.cardinality();
                if (n4 <= 2) continue;
                bS.set(n);
                bS2.set(n3);
            }
        }
    }

    private static void checkFusedRings(Lst<SmilesRing> lst, int[] nArray, Lst<BS> lst2) {
        int n;
        SmilesRing smilesRing;
        Hashtable<String, SmilesRingSet> hashtable = new Hashtable<String, SmilesRingSet>();
        int n2 = lst.size();
        while (--n2 >= 0) {
            SmilesRingSet smilesRingSet;
            smilesRing = (SmilesRing)lst.get(n2);
            Lst<Edge> lst3 = smilesRing.edges;
            n = lst3.size();
            while (--n >= 0) {
                SmilesRingSet smilesRingSet2 = SmilesRing.getSetByEdge((Edge)lst3.get(n), hashtable);
                if (smilesRingSet2 == null || smilesRingSet2 == smilesRing.set) continue;
                if (smilesRing.set != null) {
                    smilesRingSet2.addSet(smilesRing.set, hashtable);
                    continue;
                }
                smilesRingSet2.addRing(smilesRing);
            }
            if (smilesRing.set == null) {
                smilesRingSet = new SmilesRingSet();
                smilesRing.set = smilesRing.set;
            } else {
                smilesRingSet = smilesRing.set;
            }
            smilesRingSet.addRing(smilesRing);
            smilesRing.addEdges(hashtable);
        }
        int n3 = lst.size();
        while (--n3 >= 0) {
            SmilesRingSet smilesRingSet;
            smilesRing = (SmilesRing)lst.get(n3);
            if (smilesRing.isOK || (smilesRingSet = smilesRing.set) == null || smilesRingSet.isEmpty()) continue;
            if (smilesRingSet.getElectronCount(nArray) % 4 == 2) {
                n = smilesRingSet.size();
                while (--n >= 0) {
                    smilesRing = (SmilesRing)smilesRingSet.get(n);
                    if (smilesRing.isOK) continue;
                    lst2.addLast(smilesRing);
                }
            }
            smilesRingSet.clear();
        }
    }
}

