/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.J2SIgnoreImport;
import javajs.util.SB;
import org.jmol.java.BS;
import org.jmol.modelset.Orientation;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;
import org.jmol.viewer.Connections;
import org.jmol.viewer.GlobalSettings;
import org.jmol.viewer.Scene;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={Runtime.class})
public class StateManager {
    public static final int OBJ_BACKGROUND = 0;
    public static final int OBJ_AXIS1 = 1;
    public static final int OBJ_AXIS2 = 2;
    public static final int OBJ_AXIS3 = 3;
    public static final int OBJ_BOUNDBOX = 4;
    public static final int OBJ_UNITCELL = 5;
    public static final int OBJ_FRANK = 6;
    public static final int OBJ_MAX = 7;
    private static final String objectNameList = "background axis1      axis2      axis3      boundbox   unitcell   frank      ";
    protected final Viewer vwr;
    protected Map<String, Object> saved = new Hashtable<String, Object>();
    private String lastOrientation = "";
    private String lastContext = "";
    private String lastConnections = "";
    private String lastScene = "";
    private String lastSelected = "";
    private String lastState = "";
    private String lastShape = "";
    private String lastCoordinates = "";

    public static String getVariableList(Map<String, SV> map, int n, boolean bl, boolean bl2) {
        SB sB = new SB();
        int n2 = 0;
        Object[] objectArray = new String[map.size()];
        for (Map.Entry<String, SV> entry : map.entrySet()) {
            String string = entry.getKey();
            SV sV = entry.getValue();
            if (!bl && string.startsWith("site_") || bl2 && string.charAt(0) != '@') continue;
            objectArray[n2++] = string + (string.charAt(0) == '@' ? " " + sV.asString() : " = " + StateManager.varClip(string, sV.escape(), n));
        }
        Arrays.sort(objectArray, 0, n2);
        for (int i = 0; i < n2; ++i) {
            if (objectArray[i] == null) continue;
            sB.append("  ").append((String)objectArray[i]).append(";\n");
        }
        if (n2 == 0 && !bl2) {
            sB.append("# --no global user variables defined--;\n");
        }
        return sB.toString();
    }

    public static int getObjectIdFromName(String string) {
        if (string == null) {
            return -1;
        }
        int n = objectNameList.indexOf(string.toLowerCase());
        return n < 0 ? n : n / 11;
    }

    static String getObjectNameFromId(int n) {
        if (n < 0 || n >= 7) {
            return null;
        }
        return objectNameList.substring(n * 11, n * 11 + 11).trim();
    }

    StateManager(Viewer viewer) {
        this.vwr = viewer;
    }

    void clear(GlobalSettings globalSettings) {
        this.vwr.setShowAxes(false);
        this.vwr.setShowBbcage(false);
        this.vwr.setShowUnitCell(false);
        globalSettings.clear();
    }

    public void resetLighting() {
        this.vwr.setIntProperty("ambientPercent", 45);
        this.vwr.setIntProperty("celShadingPower", 10);
        this.vwr.setIntProperty("diffusePercent", 84);
        this.vwr.setIntProperty("phongExponent", 64);
        this.vwr.setIntProperty("specularExponent", 6);
        this.vwr.setIntProperty("specularPercent", 22);
        this.vwr.setIntProperty("specularPower", 40);
        this.vwr.setIntProperty("zDepth", 0);
        this.vwr.setIntProperty("zShadePower", 3);
        this.vwr.setIntProperty("zSlab", 50);
        this.vwr.setBooleanProperty("specular", true);
        this.vwr.setBooleanProperty("celShading", false);
        this.vwr.setBooleanProperty("zshade", false);
    }

    void setCrystallographicDefaults() {
        this.vwr.setAxesMode(0x24000020);
        this.vwr.setShowAxes(true);
        this.vwr.setShowUnitCell(true);
        this.vwr.setBooleanProperty("perspectiveDepth", false);
    }

    private void setCommonDefaults() {
        this.vwr.setBooleanProperty("perspectiveDepth", true);
        this.vwr.setFloatProperty("bondTolerance", 0.45f);
        this.vwr.setFloatProperty("minBondDistance", 0.4f);
        this.vwr.setIntProperty("bondingVersion", 0);
        this.vwr.setBooleanProperty("translucent", true);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.vwr.setStringProperty("defaultColorScheme", "Jmol");
        this.vwr.setBooleanProperty("axesOrientationRasmol", false);
        this.vwr.setBooleanProperty("zeroBasedXyzRasmol", false);
        this.vwr.setIntProperty("percentVdwAtom", 23);
        this.vwr.setIntProperty("bondRadiusMilliAngstroms", 150);
        this.vwr.setVdwStr("auto");
    }

    void setRasMolDefaults() {
        this.setCommonDefaults();
        this.vwr.setStringProperty("defaultColorScheme", "RasMol");
        this.vwr.setBooleanProperty("axesOrientationRasmol", true);
        this.vwr.setBooleanProperty("zeroBasedXyzRasmol", true);
        this.vwr.setIntProperty("percentVdwAtom", 0);
        this.vwr.setIntProperty("bondRadiusMilliAngstroms", 1);
        this.vwr.setVdwStr("Rasmol");
    }

    void setPyMOLDefaults() {
        this.setCommonDefaults();
        this.vwr.setStringProperty("measurementUnits", "ANGSTROMS");
        this.vwr.setBooleanProperty("zoomHeight", true);
    }

    private static Object getNoCase(Map<String, Object> map, String string) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String listSavedStates() {
        String string = "";
        for (String string2 : this.saved.keySet()) {
            string = string + "\n" + string2;
        }
        return string;
    }

    private void deleteSavedType(String string) {
        Iterator<String> iterator = this.saved.keySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().startsWith(string)) continue;
            iterator.remove();
        }
    }

    public void deleteSaved(String string) {
        Iterator<String> iterator = this.saved.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string) && (!string2.endsWith("_" + string) || string2.indexOf("_") != string2.lastIndexOf("_" + string))) continue;
            iterator.remove();
        }
    }

    public void saveSelection(String string, BS bS) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Selected_");
            return;
        }
        string = this.lastSelected = "Selected_" + string;
        this.saved.put(string, BSUtil.copy(bS));
    }

    public boolean restoreSelection(String string) {
        String string2 = string.length() > 0 ? "Selected_" + string : this.lastSelected;
        BS bS = (BS)StateManager.getNoCase(this.saved, string2);
        if (bS == null) {
            this.vwr.select(new BS(), false, 0, false);
            return false;
        }
        this.vwr.select(bS, false, 0, false);
        return true;
    }

    public void saveState(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("State_");
            return;
        }
        string = this.lastState = "State_" + string;
        this.saved.put(string, this.vwr.getStateInfo());
    }

    public String getSavedState(String string) {
        String string2 = string.length() > 0 ? "State_" + string : this.lastState;
        String string3 = (String)StateManager.getNoCase(this.saved, string2);
        return string3 == null ? "" : string3;
    }

    public void saveStructure(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Shape_");
            return;
        }
        string = this.lastShape = "Shape_" + string;
        this.saved.put(string, this.vwr.getStructureState());
    }

    public String getSavedStructure(String string) {
        String string2 = string.length() > 0 ? "Shape_" + string : this.lastShape;
        String string3 = (String)StateManager.getNoCase(this.saved, string2);
        return string3 == null ? "" : string3;
    }

    public void saveCoordinates(String string, BS bS) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Coordinates_");
            return;
        }
        string = this.lastCoordinates = "Coordinates_" + string;
        this.saved.put(string, this.vwr.getCoordinateState(bS));
    }

    public String getSavedCoordinates(String string) {
        String string2 = string.length() > 0 ? "Coordinates_" + string : this.lastCoordinates;
        String string3 = (String)StateManager.getNoCase(this.saved, string2);
        return string3 == null ? "" : string3;
    }

    Orientation getOrientation() {
        return new Orientation(this.vwr, false, null);
    }

    String getSavedOrientationText(String string) {
        if (string != null) {
            Orientation orientation = this.getOrientationFor(string);
            return orientation == null ? "" : orientation.getMoveToText(true);
        }
        SB sB = new SB();
        for (Map.Entry<String, Object> entry : this.saved.entrySet()) {
            String string2 = entry.getKey();
            if (!string2.startsWith("Orientation_")) continue;
            sB.append(((Orientation)entry.getValue()).getMoveToText(true));
        }
        return sB.toString();
    }

    public void saveScene(String string, Map<String, Object> map) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Scene_");
            return;
        }
        Scene scene = new Scene(map);
        scene.saveName = this.lastScene = "Scene_" + string;
        this.saved.put(scene.saveName, scene);
    }

    public boolean restoreScene(String string, float f) {
        Scene scene = (Scene)StateManager.getNoCase(this.saved, string.length() > 0 ? "Scene_" + string : this.lastScene);
        return scene != null && scene.restore(this.vwr, f);
    }

    public void saveOrientation(String string, float[] fArray) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Orientation_");
            return;
        }
        Orientation orientation = new Orientation(this.vwr, string.equalsIgnoreCase("default"), fArray);
        orientation.saveName = this.lastOrientation = "Orientation_" + string;
        this.saved.put(orientation.saveName, orientation);
    }

    public boolean restoreOrientation(String string, float f, boolean bl) {
        Orientation orientation = this.getOrientationFor(string);
        return orientation != null && orientation.restore(f, bl);
    }

    private Orientation getOrientationFor(String string) {
        String string2 = string.length() > 0 ? "Orientation_" + string : this.lastOrientation;
        return (Orientation)StateManager.getNoCase(this.saved, string2);
    }

    public void saveContext(String string, Object object) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Context_");
            return;
        }
        this.lastContext = "Context_" + string;
        this.saved.put(this.lastContext, object);
    }

    public Object getContext(String string) {
        return this.saved.get(string.length() == 0 ? this.lastContext : "Context_" + string);
    }

    public void saveBonds(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Bonds_");
            return;
        }
        Connections connections = new Connections(this.vwr);
        connections.saveName = this.lastConnections = "Bonds_" + string;
        this.saved.put(connections.saveName, connections);
    }

    public boolean restoreBonds(String string) {
        this.vwr.clearModelDependentObjects();
        String string2 = string.length() > 0 ? "Bonds_" + string : this.lastConnections;
        Connections connections = (Connections)StateManager.getNoCase(this.saved, string2);
        return connections != null && connections.restore();
    }

    public static String varClip(String string, String string2, int n) {
        if (n > 0 && string2.length() > n) {
            string2 = string2.substring(0, n) + " #...more (" + string2.length() + " bytes -- use SHOW " + string + " or MESSAGE @" + string + " to view)";
        }
        return string2;
    }
}

