/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.util.Logger;

public class XmlQEReader
extends XmlReader {
    private float a;
    private float b;
    private float c;

    @Override
    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        xmlReader.doProcessLines = true;
        this.processXml2(xmlReader, object);
    }

    @Override
    public void processStartElement(String string, String string2) {
        if (this.debugging) {
            Logger.debug("xmlqe: start " + string);
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("number_of_atoms".equals(string) || "cell_dimensions".equals(string) || "at".equals(string)) {
            this.setKeepChars(true);
            return;
        }
        if (string.startsWith("atom.")) {
            this.parent.setAtomCoordScaled(null, (String[])PT.getTokens((String)((String)this.atts.get((Object)"tau"))), (int)0, (float)0.5291772f).elementSymbol = ((String)this.atts.get("species")).trim();
        }
        if ("structure".equals(string)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber, null)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.asc.doFixPeriodic = true;
            this.asc.newAtomSet();
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
    }

    @Override
    void processEndElement(String string) {
        if (this.debugging) {
            Logger.debug("xmlqe: end " + string);
        }
        if (this.parent.doProcessLines) {
            if ("cell_dimensions".equals(string)) {
                this.parent.setFractionalCoordinates(true);
                float[] fArray = XmlQEReader.getTokensFloat(this.chars.toString(), null, 6);
                this.a = fArray[0];
                this.b = fArray[1] == 0.0f ? this.a : fArray[1];
                this.c = fArray[2] == 0.0f ? this.a : fArray[2];
            } else if ("at".equals(string)) {
                float[] fArray = XmlQEReader.getTokensFloat(this.chars.toString(), null, 9);
                for (int i = 0; i < 9; i += 3) {
                    int n = i;
                    fArray[n] = fArray[n] * this.a;
                    int n2 = i + 1;
                    fArray[n2] = fArray[n2] * this.b;
                    int n3 = i + 2;
                    fArray[n3] = fArray[n3] * this.c;
                }
                this.parent.addPrimitiveLatticeVector(0, fArray, 0);
                this.parent.addPrimitiveLatticeVector(1, fArray, 3);
                this.parent.addPrimitiveLatticeVector(2, fArray, 6);
            } else if ("geometry_info".equals(string)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.setKeepChars(false);
    }
}

