/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.c.STR;
import org.jmol.java.BS;

public class StructureIterator
extends JmolAdapterStructureIterator {
    private int structureCount;
    private Structure[] structures;
    private Structure structure;
    private int istructure;
    private BS bsModelsDefined;

    StructureIterator(AtomSetCollection atomSetCollection) {
        this.structureCount = atomSetCollection.structureCount;
        this.structures = atomSetCollection.structures;
        this.istructure = 0;
        this.bsModelsDefined = atomSetCollection.bsStructuredModels;
    }

    @Override
    public boolean hasNext() {
        if (this.istructure == this.structureCount) {
            return false;
        }
        this.structure = this.structures[this.istructure++];
        return true;
    }

    @Override
    public STR getStructureType() {
        return this.structure.structureType;
    }

    @Override
    public STR getSubstructureType() {
        return this.structure.substructureType;
    }

    @Override
    public String getStructureID() {
        return this.structure.structureID;
    }

    @Override
    public int getSerialID() {
        return this.structure.serialID;
    }

    @Override
    public int getStartChainID() {
        return this.structure.startChainID;
    }

    @Override
    public int getStartSequenceNumber() {
        return this.structure.startSequenceNumber;
    }

    @Override
    public char getStartInsertionCode() {
        return JmolAdapter.canonizeInsertionCode(this.structure.startInsertionCode);
    }

    @Override
    public int getEndChainID() {
        return this.structure.endChainID;
    }

    @Override
    public int getEndSequenceNumber() {
        return this.structure.endSequenceNumber;
    }

    @Override
    public char getEndInsertionCode() {
        return this.structure.endInsertionCode;
    }

    @Override
    public int getStrandCount() {
        return this.structure.strandCount;
    }

    @Override
    public BS getStructuredModels() {
        return this.bsModelsDefined;
    }

    @Override
    public int[] getAtomIndices() {
        return this.structure.atomStartEnd;
    }

    @Override
    public int[] getModelIndices() {
        return this.structure.modelStartEnd;
    }
}

