/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import javajs.util.PT;
import org.jmol.adapter.readers.molxyz.V3000Rdr;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class MolReader
extends AtomSetCollectionReader {
    private boolean optimize2D;
    private boolean haveAtomSerials;
    protected String dimension;
    protected boolean allow2D = true;
    private int iatom0;
    private V3000Rdr vr;

    public void initializeReader() throws Exception {
        this.optimize2D = this.checkFilterKey("2D");
    }

    protected boolean checkLine() throws Exception {
        boolean bl = this.line.startsWith("$MDL");
        if (bl) {
            this.discardLinesUntilStartsWith("$HDR");
            this.rd();
            if (this.line == null) {
                Logger.warn((String)"$HDR not found in MDL RG file");
                this.continuing = false;
                return false;
            }
        } else if (this.line.equals("M  END")) {
            return true;
        }
        if (this.doGetModel(++this.modelNumber, null)) {
            this.iatom0 = this.asc.ac;
            this.processMolSdHeader();
            this.processCtab(bl);
            this.vr = null;
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        }
        if (this.line != null && this.line.indexOf("$$$$") < 0) {
            this.discardLinesUntilStartsWith("$$$$");
        }
        return true;
    }

    public void finalizeSubclassReader() throws Exception {
        this.finalizeReaderMR();
    }

    protected void finalizeReaderMR() throws Exception {
        if (this.optimize2D) {
            this.set2D();
        }
        this.isTrajectory = false;
        this.finalizeReaderASCR();
    }

    private void processMolSdHeader() throws Exception {
        String string = "";
        String string2 = this.line.trim();
        string = string + this.line + "\n";
        this.asc.setCollectionName(string2);
        this.rd();
        if (this.line == null) {
            return;
        }
        string = string + this.line + "\n";
        String string3 = this.dimension = this.line.length() < 22 ? "3D" : this.line.substring(20, 22);
        if (this.dimension.equals("2D")) {
            if (!this.allow2D) {
                throw new Exception("File is 2D, not 3D");
            }
            this.appendLoadNote("This model is 2D. Its 3D structure has not been generated.");
        }
        this.asc.setInfo("dimension", (Object)this.dimension);
        this.rd();
        if (this.line == null) {
            return;
        }
        this.line = this.line.trim();
        string = string + this.line + "\n";
        if (this.line.length() != 0) {
            string2 = string2 + ": " + this.line;
        }
        Logger.info((String)string);
        this.checkCurrentLineForScript();
        this.asc.setInfo("fileHeader", (Object)string);
        this.newAtomSet(string2);
    }

    private void processCtab(boolean bl) throws Exception {
        if (bl) {
            this.discardLinesUntilStartsWith("$CTAB");
        }
        if (this.rd() == null) {
            return;
        }
        if (this.line.indexOf("V3000") >= 0) {
            this.optimize2D = this.dimension.equals("2D");
            this.vr = ((V3000Rdr)this.getInterface("org.jmol.adapter.readers.molxyz.V3000Rdr")).set(this);
            this.discardLinesUntilContains("COUNTS");
            this.vr.readAtomsAndBonds(this.getTokens());
        } else {
            this.readAtomsAndBonds(this.parseIntRange(this.line, 0, 3), this.parseIntRange(this.line, 3, 6));
        }
        this.applySymmetryAndSetTrajectory();
    }

    private void readAtomsAndBonds(int n, int n2) throws Exception {
        Object object;
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            this.rd();
            int n4 = this.line.length();
            int n5 = 0;
            int n6 = 0;
            int n7 = Integer.MIN_VALUE;
            float f = this.parseFloatRange(this.line, 0, 10);
            float f2 = this.parseFloatRange(this.line, 10, 20);
            float f3 = this.parseFloatRange(this.line, 20, 30);
            if (n4 < 34) {
                object = this.line.substring(31).trim();
            } else {
                object = this.line.substring(31, 34).trim();
                if (n4 >= 39) {
                    int n8 = this.parseIntRange(this.line, 36, 39);
                    if (n8 >= 1 && n8 <= 7) {
                        n5 = 4 - n8;
                    }
                    if ((n8 = this.parseIntRange(this.line, 34, 36)) != 0 && n8 >= -3 && n8 <= 4) {
                        n6 = JmolAdapter.getNaturalIsotope((int)JmolAdapter.getElementNumber((String)object));
                        switch (n6) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                n6 = -n8;
                                break;
                            }
                            default: {
                                n6 += n8;
                            }
                        }
                    }
                    if (n7 == Integer.MIN_VALUE && this.haveAtomSerials) {
                        n7 = n3 + 1;
                    }
                }
            }
            this.addMolAtom(n7, n6, (String)object, n5, f, f2, f3);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.rd();
            int n9 = 0;
            String string = this.line.substring(0, 3).trim();
            object = this.line.substring(3, 6).trim();
            int n10 = this.parseIntRange(this.line, 6, 9);
            if (this.optimize2D && n10 == 1 && this.line.length() >= 12) {
                n9 = this.parseIntRange(this.line, 9, 12);
            }
            n10 = this.fixOrder(n10, n9);
            if (this.haveAtomSerials) {
                this.asc.addNewBondFromNames(string, (String)object, n10);
                continue;
            }
            this.asc.addNewBondWithOrder(this.iatom0 + this.parseIntStr(string) - 1, this.iatom0 + this.parseIntStr((String)object) - 1, n10);
        }
        while (this.rd() != null && this.line.indexOf("$$$$") != 0) {
            if (!this.line.toUpperCase().contains("_PARTIAL_CHARGES")) continue;
            try {
                Atom[] atomArray = this.asc.atoms;
                int n11 = this.parseIntStr(this.rd());
                while (--n11 >= 0) {
                    object = PT.getTokens((String)this.rd());
                    int n12 = this.parseIntStr(object[0]) + this.iatom0 - 1;
                    float f = this.parseFloatStr(object[1]);
                    if (Float.isNaN(f)) continue;
                    atomArray[n12].partialCharge = f;
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void addMolAtom(int n, int n2, String string, int n3, float f, float f2, float f3) {
        switch (n2) {
            case 0: {
                break;
            }
            case -1: {
                string = "D";
                break;
            }
            case -2: {
                string = "T";
                break;
            }
            default: {
                string = n2 + string;
            }
        }
        if (this.optimize2D && f3 != 0.0f) {
            this.optimize2D = false;
        }
        Atom atom = new Atom();
        atom.elementSymbol = string;
        atom.formalCharge = n3;
        this.setAtomCoordXYZ(atom, f, f2, f3);
        if (n == Integer.MIN_VALUE) {
            this.asc.addAtom(atom);
        } else {
            this.haveAtomSerials = true;
            atom.atomSerial = n;
            this.asc.addAtomWithMappedSerialNumber(atom);
        }
    }

    public int fixOrder(int n, int n2) {
        switch (n) {
            default: {
                return 1;
            }
            case 1: {
                switch (n2) {
                    case 1: {
                        return 1025;
                    }
                    case 3: 
                    case 6: {
                        return 1041;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                return 515;
            }
            case 5: {
                return 66;
            }
            case 6: {
                return 513;
            }
            case 7: {
                return 514;
            }
            case 8: 
            case 9: {
                return 33;
            }
        }
        return n;
    }

    public void addMolBond(String string, String string2, int n, int n2) {
        n = this.fixOrder(n, n2);
        if (this.haveAtomSerials) {
            this.asc.addNewBondFromNames(string, string2, n);
        } else {
            this.asc.addNewBondWithOrder(this.iatom0 + this.parseIntStr(string) - 1, this.iatom0 + this.parseIntStr(string2) - 1, n);
        }
    }
}

