/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import javajs.api.JSONEncodable;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import org.jmol.api.Interface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.util.GData;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Vibration;
import org.jmol.viewer.JC;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class ShapeManager {
    private ModelSet ms;
    public Shape[] shapes;
    public Viewer vwr;
    private static final int[] hoverable = new int[]{31, 25, 24, 22, 36};
    private static int clickableMax = hoverable.length - 1;
    public final BS bsRenderableAtoms;
    public final BS bsSlabbedInternal;
    private final int[] navMinMax = new int[4];

    public ShapeManager(Viewer viewer) {
        this.vwr = viewer;
        this.bsRenderableAtoms = new BS();
        this.bsSlabbedInternal = new BS();
    }

    public void setParallel() {
        this.resetShapes();
        this.loadDefaultShapes(this.vwr.ms);
    }

    public void findNearestShapeAtomIndex(int n, int n2, Atom[] atomArray, BS bS) {
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length && atomArray[0] == null; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].findNearestAtomIndex(n, n2, atomArray, bS);
            }
        }
    }

    public Object getShapePropertyIndex(int n, String string, int n2) {
        if (this.shapes == null || this.shapes[n] == null) {
            return null;
        }
        this.vwr.setShapeErrorState(n, "get " + string);
        Object object = this.shapes[n].getProperty(string, n2);
        this.vwr.setShapeErrorState(-1, null);
        return object;
    }

    public boolean getShapePropertyData(int n, String string, Object[] objectArray) {
        if (this.shapes == null || this.shapes[n] == null) {
            return false;
        }
        this.vwr.setShapeErrorState(n, "get " + string);
        boolean bl = this.shapes[n].getPropertyData(string, objectArray);
        this.vwr.setShapeErrorState(-1, null);
        return bl;
    }

    public int getShapeIdFromObjectName(String string) {
        if (this.shapes != null) {
            for (int i = 16; i < 30; ++i) {
                if (this.shapes[i] == null || this.shapes[i].getIndexFromName(string) < 0) continue;
                return i;
            }
        }
        return -1;
    }

    public void loadDefaultShapes(ModelSet modelSet) {
        this.ms = modelSet;
        if (this.shapes != null) {
            for (int i = 0; i < this.shapes.length; ++i) {
                if (this.shapes[i] == null) continue;
                this.shapes[i].setModelSet(modelSet);
            }
        }
        this.loadShape(0);
        this.loadShape(1);
    }

    public Shape loadShape(int n) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[n] != null) {
            return this.shapes[n];
        }
        if (n == 2 || n == 3 || n == 4) {
            return null;
        }
        String string = JC.getShapeClassName(n, false);
        Shape shape = (Shape)Interface.getInterface(string, this.vwr, "shape");
        if (shape == null) {
            return null;
        }
        this.vwr.setShapeErrorState(n, "allocate");
        shape.initializeShape(this.vwr, this.ms, n);
        this.vwr.setShapeErrorState(-1, null);
        this.shapes[n] = shape;
        return this.shapes[n];
    }

    public void notifyAtomPositionsChanged(int n, BS bS, M4 m4) {
        Integer n2 = n;
        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(n);
        for (int i = 0; i < 37; ++i) {
            if (this.shapes[i] == null) continue;
            this.setShapePropertyBs(i, "refreshTrajectories", new Object[]{n2, bS, m4}, bS2);
        }
    }

    public void releaseShape(int n) {
        if (this.shapes != null) {
            this.shapes[n] = null;
        }
    }

    public void resetShapes() {
        if (!this.vwr.noGraphicsAllowed) {
            this.shapes = new Shape[37];
        }
    }

    public void setShapeSizeBs(int n, int n2, RadiusData radiusData, BS bS) {
        if (this.shapes == null) {
            return;
        }
        if (bS == null && (n != 1 || n2 != Integer.MAX_VALUE)) {
            bS = this.vwr.bsA();
        }
        if (radiusData != null && radiusData.value != 0.0f && radiusData.vdwType == VDW.TEMP) {
            this.ms.getBfactor100Lo();
        }
        this.vwr.setShapeErrorState(n, "set size");
        if (radiusData == null ? n2 != 0 : radiusData.value != 0.0f) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setShapeSizeRD(n2, radiusData, bS);
        }
        this.vwr.setShapeErrorState(-1, null);
    }

    public void setLabel(Object object, BS bS) {
        if (object == null) {
            if (this.shapes[5] == null) {
                return;
            }
        } else {
            this.loadShape(5);
            this.setShapeSizeBs(5, 0, null, bS);
        }
        this.setShapePropertyBs(5, "label", object, bS);
    }

    public void setShapePropertyBs(int n, String string, Object object, BS bS) {
        if (this.shapes == null || this.shapes[n] == null) {
            return;
        }
        if (bS == null) {
            bS = this.vwr.bsA();
        }
        this.vwr.setShapeErrorState(n, "set " + string);
        this.shapes[n].setProperty(string.intern(), object, bS);
        this.vwr.setShapeErrorState(-1, null);
    }

    boolean checkFrankclicked(int n, int n2) {
        Shape shape = this.shapes[36];
        return shape != null && shape.wasClicked(n, n2);
    }

    Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        Map<String, Object> map = null;
        if (n3 != 0 && this.vwr.getBondPicking() && (map = this.shapes[1].checkObjectClicked(n, n2, n3, bS, false)) != null) {
            return map;
        }
        for (int i = 0; i < clickableMax; ++i) {
            Shape shape = this.shapes[hoverable[i]];
            if (shape == null || (map = shape.checkObjectClicked(n, n2, n3, bS, bl)) == null) continue;
            return map;
        }
        return null;
    }

    boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BS bS, int n6) {
        boolean bl = false;
        int n7 = n6 > 0 ? n6 + 1 : 37;
        for (int i = n6; !bl && i < n7; ++i) {
            if (this.shapes[i] == null) continue;
            bl = this.shapes[i].checkObjectDragged(n, n2, n3, n4, n5, bS);
        }
        return bl;
    }

    boolean checkObjectHovered(int n, int n2, BS bS, boolean bl) {
        Shape shape = this.shapes[1];
        if (bl && shape != null && shape.checkObjectHovered(n, n2, bS)) {
            return true;
        }
        for (int i = 0; i < hoverable.length; ++i) {
            shape = this.shapes[hoverable[i]];
            if (shape == null || !shape.checkObjectHovered(n, n2, bS)) continue;
            return true;
        }
        return false;
    }

    public void deleteShapeAtoms(Object[] objectArray, BS bS) {
        if (this.shapes != null) {
            for (int i = 0; i < 37; ++i) {
                if (this.shapes[i] == null) continue;
                this.setShapePropertyBs(i, "deleteModelAtoms", objectArray, bS);
            }
        }
    }

    void deleteVdwDependentShapes(BS bS) {
        if (bS == null) {
            bS = this.vwr.bsA();
        }
        if (this.shapes[24] != null) {
            this.shapes[24].setProperty("deleteVdw", null, bS);
        }
        if (this.shapes[25] != null) {
            this.shapes[25].setProperty("deleteVdw", null, bS);
        }
    }

    public float getAtomShapeValue(int n, Group group, int n2) {
        int n3 = JC.shapeTokenIndex(n);
        if (n3 < 0 || this.shapes[n3] == null) {
            return 0.0f;
        }
        int n4 = this.shapes[n3].getSize(n2);
        if (n4 == 0) {
            if ((group.shapeVisibilityFlags & this.shapes[n3].vf) == 0) {
                return 0.0f;
            }
            n4 = this.shapes[n3].getSizeG(group);
        }
        return (float)n4 / 2000.0f;
    }

    public void replaceGroup(Group group, Group group2) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 9; i < 16; ++i) {
            if (this.shapes[i] == null) continue;
            this.shapes[i].replaceGroup(group, group2);
        }
    }

    void getObjectMap(Map<String, ?> map, boolean bl) {
        if (this.shapes == null) {
            return;
        }
        Boolean bl2 = bl;
        for (int i = 16; i < 30; ++i) {
            this.getShapePropertyData(i, "getNames", new Object[]{map, bl2});
        }
    }

    Object getProperty(Object object) {
        if (object.equals("getShapes")) {
            return this.shapes;
        }
        return null;
    }

    public Shape getShape(int n) {
        return this.shapes == null ? null : this.shapes[n];
    }

    public void resetBioshapes(BS bS) {
        if (this.shapes == null) {
            return;
        }
        for (int i = 0; i < this.shapes.length; ++i) {
            if (this.shapes[i] == null || !this.shapes[i].isBioShape) continue;
            this.shapes[i].setModelSet(this.ms);
            this.shapes[i].setShapeSizeRD(0, null, bS);
            this.shapes[i].setProperty("color", (Object)PAL.NONE, bS);
        }
    }

    public void setAtomLabel(String string, int n) {
        if (this.shapes != null) {
            this.shapes[5].setProperty("label:" + string, n, null);
        }
    }

    void setModelVisibility() {
        int n;
        Shape[] shapeArray = this.shapes;
        if (shapeArray == null || shapeArray[0] == null) {
            return;
        }
        BS bS = this.vwr.getVisibleFramesBitSet();
        for (n = 8; n < 33; ++n) {
            if (shapeArray[n] == null) continue;
            shapeArray[n].setModelVisibilityFlags(bS);
        }
        n = this.vwr.getBoolean(603979922) ? 1 : 0;
        BS bS2 = this.vwr.slm.bsDeleted;
        Atom[] atomArray = this.ms.at;
        this.ms.clearVisibleSets();
        if (atomArray.length > 0) {
            int n2 = this.ms.ac;
            while (--n2 >= 0) {
                Atom atom = atomArray[n2];
                atom.shapeVisibilityFlags &= 0xFFFFFFC0;
                if (bS2 != null && bS2.get(n2) || !bS.get(atom.mi)) continue;
                int n3 = 1;
                if (this.ms.isAtomHidden(n2) || n == 0 && atom.getElementNumber() == 1) continue;
                n3 |= 8;
                if (atom.madAtom != 0) {
                    n3 |= 0x10;
                }
                atom.setShapeVisibility(n3, true);
            }
        }
        this.setShapeVis();
    }

    private void setShapeVis() {
        for (int i = 0; i < 37; ++i) {
            Shape shape = this.shapes[i];
            if (shape == null) continue;
            shape.setAtomClickability();
        }
    }

    public int[] finalizeAtoms(BS bS, boolean bl) {
        int n;
        int n2;
        int n3;
        Vibration[] vibrationArray;
        JSONEncodable jSONEncodable;
        Viewer viewer = this.vwr;
        TransformManager transformManager = viewer.tm;
        if (bl) {
            viewer.finalizeTransformParameters();
        }
        if (bS != null) {
            jSONEncodable = this.ms.getAtomSetCenter(bS);
            vibrationArray = new P3();
            transformManager.transformPt3f((T3)jSONEncodable, (P3)vibrationArray);
            vibrationArray.add(transformManager.ptOffset);
            transformManager.unTransformPoint((T3)vibrationArray, (T3)vibrationArray);
            vibrationArray.sub((T3)jSONEncodable);
            viewer.setAtomCoordsRelative((T3)vibrationArray, bS);
            transformManager.ptOffset.set(0.0f, 0.0f, 0.0f);
            transformManager.bsSelectedAtoms = null;
        }
        jSONEncodable = this.bsRenderableAtoms;
        this.ms.getAtomsInFrame((BS)jSONEncodable);
        vibrationArray = this.ms.vibrations;
        boolean bl2 = vibrationArray != null && transformManager.vibrationOn;
        boolean bl3 = this.ms.bsModulated != null && this.ms.occupancies != null;
        Atom[] atomArray = this.ms.at;
        boolean bl4 = false;
        BS bS2 = this.bsSlabbedInternal;
        bS2.clearAll();
        int n4 = ((BS)jSONEncodable).nextSetBit(0);
        while (n4 >= 0) {
            int n5;
            P3i p3i;
            Atom atom = atomArray[n4];
            P3i p3i2 = p3i = bl2 && atom.hasVibration() ? transformManager.transformPtVib(atom, vibrationArray[n4]) : transformManager.transformPt(atom);
            if (p3i.z == 1 && transformManager.internalSlab && transformManager.xyzIsSlabbedInternal(atom)) {
                bS2.set(n4);
            }
            atom.sX = p3i.x;
            atom.sY = p3i.y;
            atom.sZ = p3i.z;
            n3 = Math.abs(atom.madAtom);
            if (n3 == Atom.MAD_GLOBAL) {
                n3 = (int)(viewer.getFloat(0x44000001) * 2000.0f);
            }
            atom.sD = (short)viewer.tm.scaleToScreen(p3i.z, n3);
            if (bl3 && vibrationArray[n4] != null && (n5 = vibrationArray[n4].getOccupancy100(bl2)) != Integer.MIN_VALUE) {
                bl4 = true;
                atom.setShapeVisibility(2, false);
                if (n5 >= 0 && n5 < 50) {
                    atom.setShapeVisibility(24, false);
                } else {
                    atom.setShapeVisibility(8 | (atom.madAtom > 0 ? 16 : 0), true);
                }
                this.ms.occupancies[atom.i] = Math.abs(n5);
            }
            n4 = ((BS)jSONEncodable).nextSetBit(n4 + 1);
        }
        if (bl4) {
            this.setShapeVis();
        }
        GData gData = viewer.gdata;
        if (transformManager.slabEnabled) {
            int n6;
            boolean bl5 = viewer.getBoolean(603979940);
            boolean bl6 = viewer.getBoolean(603979939);
            n3 = gData.slab;
            n2 = gData.depth;
            if (bl5) {
                JmolMolecule[] jmolMoleculeArray = this.ms.getMolecules();
                int n7 = this.ms.getMoleculeCountInModel(-1);
                for (n6 = 0; n6 < n7; ++n6) {
                    JmolMolecule jmolMolecule = jmolMoleculeArray[n6];
                    int n8 = 0;
                    int n9 = jmolMolecule.firstAtomIndex;
                    if (!((BS)jSONEncodable).get(n9)) continue;
                    while (n8 < jmolMolecule.ac && !gData.isClippedZ(atomArray[n9].sZ - (atomArray[n9].sD >> 1))) {
                        ++n8;
                        ++n9;
                    }
                    if (n8 == jmolMolecule.ac) continue;
                    n9 = jmolMolecule.firstAtomIndex;
                    for (int i = 0; i < jmolMolecule.ac; ++i) {
                        ((BS)jSONEncodable).clear(n9);
                        atomArray[n9++].sZ = 0;
                    }
                }
            }
            n = ((BS)jSONEncodable).nextSetBit(0);
            while (n >= 0) {
                Atom atom = atomArray[n];
                if (gData.isClippedZ(atom.sZ - (bl6 ? atomArray[n].sD >> 1 : 0))) {
                    atom.setClickable(0);
                    n6 = (bl6 ? -1 : 1) * atom.sD / 2;
                    if (atom.sZ + n6 < n3 || atom.sZ - n6 > n2 || !gData.isInDisplayRange(atom.sX, atom.sY)) {
                        ((BS)jSONEncodable).clear(n);
                    }
                }
                n = ((BS)jSONEncodable).nextSetBit(n + 1);
            }
        }
        if (this.ms.ac == 0 || !viewer.getShowNavigationPoint()) {
            return null;
        }
        int n10 = Integer.MAX_VALUE;
        int n11 = Integer.MIN_VALUE;
        n3 = Integer.MAX_VALUE;
        n2 = Integer.MIN_VALUE;
        n = ((BS)jSONEncodable).nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            if (atom.sX < n10) {
                n10 = atom.sX;
            }
            if (atom.sX > n11) {
                n11 = atom.sX;
            }
            if (atom.sY < n3) {
                n3 = atom.sY;
            }
            if (atom.sY > n2) {
                n2 = atom.sY;
            }
            n = ((BS)jSONEncodable).nextSetBit(n + 1);
        }
        this.navMinMax[0] = n10;
        this.navMinMax[1] = n11;
        this.navMinMax[2] = n3;
        this.navMinMax[3] = n2;
        return this.navMinMax;
    }

    public void setModelSet(ModelSet modelSet) {
        this.ms = this.vwr.ms = modelSet;
    }

    public void checkInheritedShapes() {
        if (this.shapes[24] == null) {
            return;
        }
        this.setShapePropertyBs(24, "remapInherited", null, null);
    }

    public void restrictSelected(boolean bl, boolean bl2) {
        BS bS = this.vwr.slm.getSelectedAtomsNoSubset();
        if (bl2) {
            this.vwr.slm.invertSelection();
            BS bS2 = this.vwr.slm.bsSubset;
            if (bS2 != null) {
                bS = this.vwr.slm.getSelectedAtomsNoSubset();
                bS.and(bS2);
                this.vwr.select(bS, false, 0, true);
                BSUtil.invertInPlace(bS, this.vwr.ms.ac);
                bS.and(bS2);
            }
        }
        BSUtil.andNot(bS, this.vwr.slm.bsDeleted);
        boolean bl3 = this.vwr.getBoolean(0x24000024);
        if (!bl) {
            this.vwr.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 32768, null);
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 1023, null);
        BS bS3 = this.vwr.bsA();
        int n = 21;
        while (--n >= 0) {
            if (n == 6 || this.getShape(n) == null) continue;
            this.setShapeSizeBs(n, 0, null, bS3);
        }
        if (this.getShape(21) != null) {
            this.setShapePropertyBs(21, "off", bS3, null);
        }
        this.setLabel(null, bS3);
        if (!bl) {
            this.vwr.setBooleanProperty("bondModeOr", bl3);
        }
        this.vwr.select(bS, false, 0, true);
    }
}

