/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.awt.XWindow;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ContainerEvent;
import com.sun.star.container.XContainer;
import com.sun.star.container.XContainerListener;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbcx.XAppend;
import com.sun.star.sdbcx.XColumnsSupplier;
import com.sun.star.sdbcx.XDataDescriptorFactory;
import com.sun.star.sdbcx.XDrop;
import com.sun.star.sdbcx.XKeysSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.ColumnPropertySet;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.CommandName;
import java.util.ArrayList;

public class TableDescriptor
extends CommandMetaData
implements XContainerListener {
    private XDataDescriptorFactory xTableDataDescriptorFactory;
    private XPropertySet xPropTableDataDescriptor;
    private XNameAccess xNameAccessColumns;
    private XIndexAccess xIndexAccessKeys;
    private XDataDescriptorFactory xColumnDataDescriptorFactory;
    private XContainer xTableContainer;
    private XAppend xTableAppend;
    private XDrop xTableDrop;
    private XAppend xKeyAppend;
    private XDrop xKeyDrop;
    private String[] sTableFilters = null;
    private final ArrayList<ColumnDescriptor> columncontainer;
    private final ArrayList<XPropertySet> keycolumncontainer;
    private CommandName ComposedTableName;
    private XAppend xKeyColAppend;
    private XColumnsSupplier xKeyColumnSupplier;
    private XPropertySet xKey;
    private boolean bIDFieldisInserted = false;
    private String IDFieldName = PropertyNames.EMPTY_STRING;
    private final String sColumnAlreadyExistsMessage;
    private final XWindow xWindow;

    public TableDescriptor(XMultiServiceFactory xMSF, XWindow _xWindow, String _sColumnAlreadyExistsMessage) {
        super(xMSF);
        this.columncontainer = new ArrayList();
        this.keycolumncontainer = new ArrayList();
        this.sColumnAlreadyExistsMessage = _sColumnAlreadyExistsMessage;
        this.xWindow = _xWindow;
    }

    public boolean getConnection(PropertyValue[] _curPropertyValue) {
        if (super.getConnection(_curPropertyValue)) {
            this.xTableAppend = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)this.getTableNamesAsNameAccess());
            this.xTableDrop = (XDrop)UnoRuntime.queryInterface(XDrop.class, (Object)this.getTableNamesAsNameAccess());
            this.xTableDataDescriptorFactory = (XDataDescriptorFactory)UnoRuntime.queryInterface(XDataDescriptorFactory.class, (Object)this.getTableNamesAsNameAccess());
            this.xPropTableDataDescriptor = this.xTableDataDescriptorFactory.createDataDescriptor();
            XColumnsSupplier xColumnsSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.xPropTableDataDescriptor);
            this.xNameAccessColumns = xColumnsSupplier.getColumns();
            this.xColumnDataDescriptorFactory = (XDataDescriptorFactory)UnoRuntime.queryInterface(XDataDescriptorFactory.class, (Object)this.xNameAccessColumns);
            try {
                this.createTypeInspector();
                this.sTableFilters = (String[])AnyConverter.toArray((Object)this.getDataSourcePropertySet().getPropertyValue("TableFilter"));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            return true;
        }
        return false;
    }

    private void removePrimaryKeys() {
        if (this.keycolumncontainer.size() > 0) {
            for (int i = this.keycolumncontainer.size() - 1; i >= 0; --i) {
                this.keycolumncontainer.remove(i);
            }
        }
    }

    private boolean createPrimaryKeys(String[] _fieldnames, boolean _bAutoincrementation) {
        try {
            XKeysSupplier xKeySupplier = (XKeysSupplier)UnoRuntime.queryInterface(XKeysSupplier.class, (Object)this.xPropTableDataDescriptor);
            this.xIndexAccessKeys = xKeySupplier.getKeys();
            XDataDescriptorFactory xKeyFac = (XDataDescriptorFactory)UnoRuntime.queryInterface(XDataDescriptorFactory.class, (Object)this.xIndexAccessKeys);
            this.xKeyDrop = (XDrop)UnoRuntime.queryInterface(XDrop.class, (Object)this.xIndexAccessKeys);
            this.xKeyAppend = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)xKeyFac);
            this.xKey = xKeyFac.createDataDescriptor();
            this.xKey.setPropertyValue("Type", (Object)1);
            this.xKeyColumnSupplier = (XColumnsSupplier)UnoRuntime.queryInterface(XColumnsSupplier.class, (Object)this.xKey);
            XDataDescriptorFactory xKeyColFac = (XDataDescriptorFactory)UnoRuntime.queryInterface(XDataDescriptorFactory.class, (Object)this.xKeyColumnSupplier.getColumns());
            this.xKeyColAppend = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)xKeyColFac);
            this.removePrimaryKeys();
            for (int i = 0; i < _fieldnames.length; ++i) {
                int nDataType;
                XPropertySet xKeyColPropertySet = xKeyColFac.createDataDescriptor();
                xKeyColPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)_fieldnames[i]);
                this.keycolumncontainer.add(xKeyColPropertySet);
                XPropertySet xColPropertySet = null;
                xColPropertySet = this.hasByName(_fieldnames[i]) ? this.getByName(_fieldnames[i]) : this.addPrimaryKeyColumn(_fieldnames[i]);
                xColPropertySet.setPropertyValue("IsNullable", (Object)0);
                if (_bAutoincrementation && (nDataType = this.oTypeInspector.getAutoIncrementIndex(xColPropertySet)) != 999999 && xColPropertySet.getPropertySetInfo().hasPropertyByName("IsAutoIncrement")) {
                    xColPropertySet.setPropertyValue("Type", (Object)nDataType);
                    xColPropertySet.setPropertyValue("IsAutoIncrement", (Object)_bAutoincrementation);
                }
                this.modifyColumn(_fieldnames[i], xColPropertySet);
            }
            return true;
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(System.err);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(System.err);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(System.err);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    private boolean isColunnNameDuplicate(XNameAccess _xColumns, XPropertySet _xToBeAppendedPropertySet) {
        try {
            String sColumnName = AnyConverter.toString((Object)_xToBeAppendedPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME));
            if (_xColumns.hasByName(sColumnName)) {
                String sMessage = JavaTools.replaceSubString(this.sColumnAlreadyExistsMessage, sColumnName, "%FIELDNAME");
                this.showMessageBox("ErrorBox", 0x400000, sMessage);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    public boolean createTable(String _catalogname, String _schemaname, String _tablename) {
        boolean breturn = true;
        try {
            int i;
            XAppend xAppendColumns = (XAppend)UnoRuntime.queryInterface(XAppend.class, (Object)this.xNameAccessColumns);
            for (i = 0; i < this.columncontainer.size(); ++i) {
                XPropertySet xColPropertySet = this.getByIndex(i);
                if (!this.isColunnNameDuplicate(this.xNameAccessColumns, xColPropertySet)) {
                    xAppendColumns.appendByDescriptor(xColPropertySet);
                    continue;
                }
                breturn = false;
            }
            if (breturn) {
                this.assignTableProperty(PropertyNames.PROPERTY_NAME, _tablename);
                this.assignTableProperty("CatalogName", _catalogname);
                this.assignTableProperty("SchemaName", _schemaname);
                this.xTableContainer = (XContainer)UnoRuntime.queryInterface(XContainer.class, (Object)this.getTableNamesAsNameAccess());
                this.xTableContainer.addContainerListener((XContainerListener)this);
                if (this.keycolumncontainer.size() > 0) {
                    for (i = 0; i < this.keycolumncontainer.size(); ++i) {
                        XPropertySet xKeyColPropertySet = this.keycolumncontainer.get(i);
                        if (!this.isColunnNameDuplicate(this.xKeyColumnSupplier.getColumns(), xKeyColPropertySet)) {
                            this.xKeyColAppend.appendByDescriptor(xKeyColPropertySet);
                            continue;
                        }
                        breturn = false;
                    }
                    if (breturn) {
                        this.xKeyAppend.appendByDescriptor(this.xKey);
                    }
                }
                if (breturn) {
                    this.xTableAppend.appendByDescriptor(this.xPropTableDataDescriptor);
                }
            }
        }
        catch (SQLException oSQLException) {
            super.callSQLErrorMessageDialog(oSQLException, this.xWindow);
            breturn = false;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            breturn = false;
        }
        if (!breturn) {
            this.removeAllColumnsFromDescriptor(_tablename);
            this.removePrimaryKeys();
        }
        return breturn;
    }

    private boolean removeAllColumnsFromDescriptor(String _tablename) {
        try {
            int i;
            int icount;
            this.xPropTableDataDescriptor.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)PropertyNames.EMPTY_STRING);
            if (this.xKeyDrop != null && this.xIndexAccessKeys != null && (icount = this.xIndexAccessKeys.getCount()) > 0) {
                for (i = this.xIndexAccessKeys.getCount() - 1; i >= 0; --i) {
                    this.xKeyDrop.dropByIndex(i);
                }
            }
            XDrop xColumnDrop = (XDrop)UnoRuntime.queryInterface(XDrop.class, (Object)this.xNameAccessColumns);
            for (i = this.xNameAccessColumns.getElementNames().length - 1; i >= 0; --i) {
                xColumnDrop.dropByIndex(i);
            }
            if (this.xTableDrop != null && this.getTableNamesAsNameAccess().hasByName(_tablename)) {
                this.xTableDrop.dropByName(_tablename);
            }
            if (this.bIDFieldisInserted) {
                this.dropColumnbyName(this.IDFieldName);
                this.bIDFieldisInserted = false;
            }
            return false;
        }
        catch (SQLException oSQLException) {
            super.callSQLErrorMessageDialog(oSQLException, this.xWindow);
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
        }
        return false;
    }

    public boolean createTable(String _catalogname, String _schemaname, String _tablename, String[] _keycolumnnames, boolean _bAutoincrementation) {
        if (this.createPrimaryKeys(_keycolumnnames, _bAutoincrementation)) {
            return this.createTable(_catalogname, _schemaname, _tablename);
        }
        return false;
    }

    private void assignTableProperty(String _spropname, String _svalue) {
        if (_svalue != null && !_svalue.equals(PropertyNames.EMPTY_STRING)) {
            try {
                this.xPropTableDataDescriptor.setPropertyValue(_spropname, (Object)_svalue);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public boolean modifyColumnName(String _soldname, String _snewname) {
        try {
            return this.modifyColumn(_soldname, PropertyNames.PROPERTY_NAME, _snewname);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.showMessageBox("ErrorBox", 0x400000, e.getMessage());
            return false;
        }
    }

    private boolean modifyColumn(String _sname, String _spropname, Object _oValue) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor oColumnDescriptor = this.columncontainer.get(i);
                    if (!oColumnDescriptor.Name.equals(_sname)) continue;
                    oColumnDescriptor.xColPropertySet.setPropertyValue(_spropname, _oValue);
                    if (_spropname.equals(PropertyNames.PROPERTY_NAME)) {
                        oColumnDescriptor.Name = (String)_oValue;
                    }
                    this.columncontainer.remove(i);
                    this.columncontainer.add(i, oColumnDescriptor);
                    return true;
                }
            }
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(System.err);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(System.err);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(System.err);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    public boolean modifyColumn(String _sname, XPropertySet _xColPropertySet) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor oColumnDescriptor = this.columncontainer.get(i);
                    if (!oColumnDescriptor.Name.equals(_sname)) continue;
                    oColumnDescriptor.xColPropertySet = _xColPropertySet;
                    oColumnDescriptor.Name = (String)_xColPropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME);
                    this.columncontainer.remove(i);
                    this.columncontainer.add(i, oColumnDescriptor);
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    public void dropColumnbyName(String _sname) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor oColumnDescriptor = this.columncontainer.get(i);
                    if (oColumnDescriptor == null || !oColumnDescriptor.Name.equals(_sname)) continue;
                    this.columncontainer.remove(i);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private String[] getColumnNames() {
        if (this.columncontainer.size() > 0) {
            try {
                String[] fieldnames = new String[this.columncontainer.size()];
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor oColumnDescriptor = this.columncontainer.get(i);
                    fieldnames[i] = oColumnDescriptor.Name;
                }
                return fieldnames;
            }
            catch (RuntimeException e) {
                e.printStackTrace(System.err);
            }
        }
        return new String[0];
    }

    private boolean hasByName(String _fieldname) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor oColumnDescriptor = this.columncontainer.get(i);
                    if (!oColumnDescriptor.Name.equals(_fieldname)) continue;
                    return true;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    private ColumnDescriptor getColumnDescriptorByName(String _fieldname) {
        try {
            if (this.columncontainer.size() > 0) {
                for (int i = 0; i < this.columncontainer.size(); ++i) {
                    ColumnDescriptor oColumnDescriptor = this.columncontainer.get(i);
                    if (!oColumnDescriptor.Name.equals(_fieldname)) continue;
                    return oColumnDescriptor;
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public XPropertySet getByName(String _fieldname) {
        ColumnDescriptor oColumnDescriptor = this.getColumnDescriptorByName(_fieldname);
        if (oColumnDescriptor != null) {
            return oColumnDescriptor.xColPropertySet;
        }
        return null;
    }

    private XPropertySet getByIndex(int _index) {
        try {
            if (this.columncontainer.size() > _index) {
                ColumnDescriptor oColumnDescriptor = this.columncontainer.get(_index);
                return oColumnDescriptor.xColPropertySet;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public XPropertySet clonePropertySet(String _snewname, XPropertySet _xnewPropertySet) {
        XPropertySet xRetPropertySet = this.xColumnDataDescriptorFactory.createDataDescriptor();
        try {
            if (this.hasByName(_snewname)) {
                XPropertySet oColumn = this.getByName(_snewname);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oColumn);
                Property[] aColProperties = xPropertySet.getPropertySetInfo().getProperties();
                for (int i = 0; i < aColProperties.length; ++i) {
                    String sPropName = aColProperties[i].Name;
                    Object oColValue = _xnewPropertySet.getPropertyValue(sPropName);
                    xRetPropertySet.setPropertyValue(sPropName, oColValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return xRetPropertySet;
    }

    public boolean addColumn(PropertyValue[] _aNewPropertyValues) {
        try {
            String sname = (String)Properties.getPropertyValue(_aNewPropertyValues, PropertyNames.PROPERTY_NAME);
            if (!this.hasByName(sname)) {
                ColumnPropertySet oPropertySet = new ColumnPropertySet(this.oTypeInspector, this.xColumnDataDescriptorFactory.createDataDescriptor());
                oPropertySet.assignPropertyValues(_aNewPropertyValues, true);
                ColumnDescriptor oColumnDescriptor = new ColumnDescriptor(oPropertySet.xPropertySet, sname);
                this.columncontainer.add(oColumnDescriptor);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return false;
    }

    public boolean moveColumn(int _nOldIndex, int _nNewIndex) {
        try {
            ColumnDescriptor oColumnDescriptor = this.columncontainer.get(_nOldIndex);
            this.columncontainer.remove(_nOldIndex);
            this.columncontainer.add(_nNewIndex, oColumnDescriptor);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    private XPropertySet addPrimaryKeyColumn(String _columnname) {
        try {
            if (!this.hasByName(_columnname)) {
                try {
                    XPropertySet xColPropertySet = this.xColumnDataDescriptorFactory.createDataDescriptor();
                    this.IDFieldName = Desktop.getUniqueName(this.getColumnNames(), _columnname, PropertyNames.EMPTY_STRING);
                    xColPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)this.IDFieldName);
                    int nDataType = this.oTypeInspector.convertDataType(4);
                    xColPropertySet.setPropertyValue("Type", (Object)nDataType);
                    xColPropertySet.setPropertyValue("TypeName", (Object)this.oTypeInspector.getDefaultTypeName(nDataType, null));
                    ColumnDescriptor oColumnDescriptor = new ColumnDescriptor(xColPropertySet, this.IDFieldName);
                    this.columncontainer.add(0, oColumnDescriptor);
                    this.bIDFieldisInserted = true;
                    return xColPropertySet;
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace(System.err);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return null;
    }

    public String[] getNonBinaryFieldNames() {
        ArrayList<String> NonBinaryFieldNameVector = new ArrayList<String>();
        try {
            for (int i = 0; i < this.columncontainer.size(); ++i) {
                ColumnDescriptor oColumnDescriptor = this.columncontainer.get(i);
                XPropertySet xColPropertySet = this.getByName(oColumnDescriptor.Name);
                try {
                    int itype = AnyConverter.toInt((Object)xColPropertySet.getPropertyValue("Type"));
                    if (this.isBinaryDataType(itype)) continue;
                    NonBinaryFieldNameVector.add(oColumnDescriptor.Name);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace(System.err);
        }
        String[] sbinaryfieldnames = new String[NonBinaryFieldNameVector.size()];
        NonBinaryFieldNameVector.toArray(sbinaryfieldnames);
        return sbinaryfieldnames;
    }

    public String getComposedTableName(String _scatalogname, String _sschemaname, String _stablename) {
        this.ComposedTableName = new CommandName(this, _scatalogname, _sschemaname, _stablename, false);
        return this.ComposedTableName.getComposedName();
    }

    public String getComposedTableName() {
        if (this.ComposedTableName != null) {
            return this.ComposedTableName.getComposedName();
        }
        return null;
    }

    public void elementInserted(ContainerEvent arg0) {
        try {
            XPropertySet xTablePropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)arg0.Element);
            String stablename = AnyConverter.toString((Object)xTablePropertySet.getPropertyValue(PropertyNames.PROPERTY_NAME));
            String sschemaname = AnyConverter.toString((Object)this.xPropTableDataDescriptor.getPropertyValue("SchemaName"));
            String scatalogname = AnyConverter.toString((Object)this.xPropTableDataDescriptor.getPropertyValue("CatalogName"));
            this.ComposedTableName = new CommandName(this, scatalogname, sschemaname, stablename, false);
            this.appendTableNameToFilter(this.ComposedTableName.getComposedName());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void elementRemoved(ContainerEvent arg0) {
    }

    public void elementReplaced(ContainerEvent arg0) {
    }

    public void disposing(EventObject arg0) {
    }

    private boolean appendTableNameToFilter(String _scomposedtablename) {
        boolean bhastoinsert = true;
        for (int i = 0; i < this.sTableFilters.length; ++i) {
            if (this.sTableFilters[i].compareTo("%") > -1) {
                if (this.sTableFilters[i].endsWith("." + _scomposedtablename)) {
                    bhastoinsert = false;
                } else if (this.sTableFilters[i].length() == 1) {
                    bhastoinsert = false;
                }
            } else if (this.sTableFilters[i].equals(_scomposedtablename)) {
                bhastoinsert = false;
            }
            if (!bhastoinsert) break;
        }
        if (bhastoinsert) {
            String[] sNewTableFilters = new String[this.sTableFilters.length + 1];
            System.arraycopy(this.sTableFilters, 0, sNewTableFilters, 0, this.sTableFilters.length);
            sNewTableFilters[this.sTableFilters.length] = _scomposedtablename;
            this.sTableFilters = sNewTableFilters;
            try {
                this.getDataSourcePropertySet().setPropertyValue("TableFilter", (Object)this.sTableFilters);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                bhastoinsert = false;
            }
        }
        return bhastoinsert;
    }

    private class ColumnDescriptor {
        String Name;
        XPropertySet xColPropertySet;

        public ColumnDescriptor(XPropertySet _xColPropertySet, String _Name) {
            this.Name = _Name;
            this.xColPropertySet = _xColPropertySet;
        }
    }
}

