/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.writer.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.writer.model.ImageWriterAbstractFactory;
import org.sejda.core.writer.xmlgraphics.ImageWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageWriterContext {
    private static final Logger LOG = LoggerFactory.getLogger(ImageWriterContext.class);
    private static final String IMAGE_WRITER_FACTORY_CLASS = "sejda.image.writer.factory.class";
    @Deprecated
    private static final String OLD_IMAGE_WRITER_FACTORY_CLASS = "org.sejda.image.writer.factory.class";
    private final ImageWriterAbstractFactory factory = ImageWriterContext.newImageWriterFactory();
    private final ImageWriterAbstractFactory defaultFactory = new ImageWriterFactory();

    public static ImageWriterContext getContext() {
        return DefaultImageWriterFactoryContextHolder.IMAGE_WRITER_CONTEXT;
    }

    private ImageWriterContext() {
    }

    public ImageWriterAbstractFactory getImageWriterFactory() {
        return this.factory;
    }

    public ImageWriterAbstractFactory getDefaultImageWriterFactory() {
        return this.defaultFactory;
    }

    private static ImageWriterAbstractFactory newImageWriterFactory() {
        ImageWriterAbstractFactory retVal = ImageWriterContext.newNonDefaultFactory();
        if (retVal != null) {
            return retVal;
        }
        LOG.trace("Creating default ImageWriterAbstractFactory.");
        return new ImageWriterFactory();
    }

    private static ImageWriterAbstractFactory newNonDefaultFactory() {
        ImageWriterAbstractFactory retVal = null;
        String factoryClassString = StringUtils.defaultString(System.getProperty(IMAGE_WRITER_FACTORY_CLASS), System.getProperty(OLD_IMAGE_WRITER_FACTORY_CLASS));
        if (StringUtils.isNotBlank(factoryClassString)) {
            LOG.trace("Instantiating custom ImageWriterAbstractFactory: {}", (Object)factoryClassString);
            try {
                Constructor<?> constructor = ImageWriterContext.findConstructor(factoryClassString);
                if (constructor != null) {
                    retVal = (ImageWriterAbstractFactory)ImageWriterAbstractFactory.class.cast(constructor.newInstance(new Object[0]));
                }
            }
            catch (InvocationTargetException e) {
                LOG.warn("An exception occured instantiating custom ImageWriterAbstractFactory.", e);
            }
            catch (InstantiationException e) {
                LOG.warn("Unable to instantiate custom ImageWriterAbstractFactory.", e);
            }
            catch (IllegalAccessException e) {
                LOG.warn("Unable to access the constructor for custom ImageWriterAbstractFactory.", e);
            }
        }
        return retVal;
    }

    private static Constructor<?> findConstructor(String factoryClassString) {
        try {
            Class<?> factoryClass = Class.forName(factoryClassString);
            return factoryClass.getConstructor(new Class[0]);
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Custom ImageWriterAbstractFactory class not found.", e);
        }
        catch (SecurityException e) {
            LOG.warn("Error finding the constructor for custom ImageWriterAbstractFactory.", e);
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Unable to find constructor for custom ImageWriterAbstractFactory.", e);
        }
        return null;
    }

    private static final class DefaultImageWriterFactoryContextHolder {
        static final ImageWriterContext IMAGE_WRITER_CONTEXT = new ImageWriterContext();

        private DefaultImageWriterFactoryContextHolder() {
        }
    }
}

