/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.sejda.io.BaseSeekableSource;
import org.sejda.io.SeekableSource;
import org.sejda.util.RequireUtils;

public class SeekableSourceView
extends BaseSeekableSource {
    private long startingPosition;
    private long length;
    private long currentPosition;
    private SeekableSource wrapped;

    public SeekableSourceView(SeekableSource wrapped, long startingPosition, long length) {
        super(Optional.ofNullable(wrapped).map(SeekableSource::id).orElseThrow(() -> new IllegalArgumentException("Input decorated SeekableSource cannot be null")));
        RequireUtils.requireArg(startingPosition >= 0L && startingPosition < wrapped.size(), "Starting position cannot be negative");
        RequireUtils.requireArg(length > 0L, "View length must be positive");
        this.startingPosition = startingPosition;
        this.currentPosition = 0L;
        this.length = Math.min(length, wrapped.size() - startingPosition);
        this.wrapped = wrapped;
    }

    @Override
    public long position() {
        return this.currentPosition;
    }

    @Override
    public SeekableSource position(long newPosition) throws IOException {
        RequireUtils.requireArg(newPosition >= 0L, "Cannot set position to a negative value");
        this.currentPosition = Math.min(this.length, newPosition);
        this.wrapped.position(this.startingPosition + this.currentPosition);
        return this;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.requireOpen();
        if (this.hasAvailable()) {
            int read;
            this.wrapped.position(this.startingPosition + this.currentPosition);
            if ((long)dst.remaining() > this.available()) {
                dst.limit(dst.position() + (int)this.available());
            }
            if ((read = this.wrapped.read(dst)) > 0) {
                this.currentPosition += (long)read;
                return read;
            }
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        this.requireOpen();
        if (this.hasAvailable()) {
            this.wrapped.position(this.startingPosition + this.currentPosition);
            ++this.currentPosition;
            return this.wrapped.read();
        }
        return -1;
    }

    private boolean hasAvailable() {
        return this.available() > 0L;
    }

    private long available() {
        return this.length - this.currentPosition;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.currentPosition = 0L;
    }

    @Override
    protected void requireOpen() {
        super.requireOpen();
        RequireUtils.requireState(this.wrapped.isOpen(), "The original SeekableSource has been closed");
    }

    @Override
    public SeekableSource view(long startingPosition, long length) {
        throw new RuntimeException("Cannot create a view of a view");
    }
}

