/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class Predictor {
    private Predictor() {
    }

    static void decodePredictor(int predictor, int colors, int bitsPerComponent, int columns, InputStream in, OutputStream out) throws IOException {
        if (predictor == 1) {
            IOUtils.copy(in, out);
        } else {
            int bitsPerPixel = colors * bitsPerComponent;
            int bytesPerPixel = (bitsPerPixel + 7) / 8;
            int rowlength = (columns * bitsPerPixel + 7) / 8;
            byte[] actline = new byte[rowlength];
            byte[] lastline = new byte[rowlength];
            int linepredictor = predictor;
            while (in.available() > 0) {
                int i;
                if (predictor >= 10) {
                    linepredictor = in.read();
                    if (linepredictor == -1) {
                        return;
                    }
                    linepredictor += 10;
                }
                for (int offset = 0; offset < rowlength && (i = in.read(actline, offset, rowlength - offset)) != -1; offset += i) {
                }
                switch (linepredictor) {
                    case 2: {
                        int p;
                        int left;
                        int sub;
                        int left2;
                        int sub2;
                        int p2;
                        if (bitsPerComponent == 8) {
                            for (p2 = bytesPerPixel; p2 < rowlength; ++p2) {
                                sub2 = actline[p2] & 0xFF;
                                left2 = actline[p2 - bytesPerPixel] & 0xFF;
                                actline[p2] = (byte)(sub2 + left2);
                            }
                        } else if (bitsPerComponent == 16) {
                            for (p2 = bytesPerPixel; p2 < rowlength; p2 += 2) {
                                sub2 = ((actline[p2] & 0xFF) << 8) + (actline[p2 + 1] & 0xFF);
                                left2 = ((actline[p2 - bytesPerPixel] & 0xFF) << 8) + (actline[p2 - bytesPerPixel + 1] & 0xFF);
                                actline[p2] = (byte)(sub2 + left2 >> 8 & 0xFF);
                                actline[p2 + 1] = (byte)(sub2 + left2 & 0xFF);
                            }
                        } else if (bitsPerComponent == 1 && colors == 1) {
                            for (p2 = 0; p2 < rowlength; ++p2) {
                                for (int bit = 7; bit >= 0; --bit) {
                                    sub = actline[p2] >> bit & 1;
                                    if (p2 == 0 && bit == 7) continue;
                                    left = bit == 7 ? actline[p2 - 1] & 1 : actline[p2] >> bit + 1 & 1;
                                    actline[p2] = (sub + left & 1) == 0 ? (byte)(actline[p2] & ~(1 << bit)) : (byte)(actline[p2] | 1 << bit);
                                }
                            }
                        } else {
                            int elements = columns * colors;
                            for (p = colors; p < elements; ++p) {
                                int bytePosSub = p * bitsPerComponent / 8;
                                int bitPosSub = 8 - p * bitsPerComponent % 8 - bitsPerComponent;
                                int bytePosLeft = (p - colors) * bitsPerComponent / 8;
                                int bitPosLeft = 8 - (p - colors) * bitsPerComponent % 8 - bitsPerComponent;
                                int sub3 = Predictor.getBitSeq(actline[bytePosSub], bitPosSub, bitsPerComponent);
                                int left3 = Predictor.getBitSeq(actline[bytePosLeft], bitPosLeft, bitsPerComponent);
                                actline[bytePosSub] = (byte)Predictor.calcSetBitSeq(actline[bytePosSub], bitPosSub, bitsPerComponent, sub3 + left3);
                            }
                        }
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        int p;
                        int left;
                        int sub;
                        for (p = bytesPerPixel; p < rowlength; ++p) {
                            sub = actline[p];
                            left = actline[p - bytesPerPixel];
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 12: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int up = actline[p] & 0xFF;
                            int prior = lastline[p] & 0xFF;
                            actline[p] = (byte)(up + prior & 0xFF);
                        }
                        break;
                    }
                    case 13: {
                        int p;
                        int left;
                        for (p = 0; p < rowlength; ++p) {
                            int avg = actline[p] & 0xFF;
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int up = lastline[p] & 0xFF;
                            actline[p] = (byte)(avg + (left + up) / 2 & 0xFF);
                        }
                        break;
                    }
                    case 14: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int paeth = actline[p] & 0xFF;
                            int a = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int b = lastline[p] & 0xFF;
                            int c = p - bytesPerPixel >= 0 ? lastline[p - bytesPerPixel] & 0xFF : 0;
                            int value = a + b - c;
                            int absa = Math.abs(value - a);
                            int absb = Math.abs(value - b);
                            int absc = Math.abs(value - c);
                            actline[p] = absa <= absb && absa <= absc ? (byte)(paeth + a & 0xFF) : (absb <= absc ? (byte)(paeth + b & 0xFF) : (byte)(paeth + c & 0xFF));
                        }
                        break;
                    }
                }
                System.arraycopy(actline, 0, lastline, 0, rowlength);
                out.write(actline);
            }
        }
    }

    static int getBitSeq(int by, int startBit, int bitSize) {
        int mask = (1 << bitSize) - 1;
        return by >>> startBit & mask;
    }

    static int calcSetBitSeq(int by, int startBit, int bitSize, int val) {
        int mask = (1 << bitSize) - 1;
        int truncatedVal = val & mask;
        mask = ~(mask << startBit);
        return by & mask | truncatedVal << startBit;
    }
}

