/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.PrimaryShardAllocator;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.gateway.ReplicaShardAllocator;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;

public class GatewayAllocator
extends AbstractComponent {
    private RoutingService routingService;
    private final PrimaryShardAllocator primaryShardAllocator;
    private final ReplicaShardAllocator replicaShardAllocator;
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>> asyncFetchStarted = ConcurrentCollections.newConcurrentMap();
    private final ConcurrentMap<ShardId, AsyncShardFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData>> asyncFetchStore = ConcurrentCollections.newConcurrentMap();

    @Inject
    public GatewayAllocator(Settings settings, TransportNodesListGatewayStartedShards startedAction, TransportNodesListShardStoreMetaData storeAction) {
        super(settings);
        this.primaryShardAllocator = new InternalPrimaryShardAllocator(settings, startedAction);
        this.replicaShardAllocator = new InternalReplicaShardAllocator(settings, storeAction);
    }

    public void setReallocation(ClusterService clusterService, RoutingService routingService) {
        this.routingService = routingService;
        clusterService.add(new ClusterStateListener(){

            @Override
            public void clusterChanged(ClusterChangedEvent event) {
                boolean cleanCache = false;
                DiscoveryNode localNode = event.state().nodes().localNode();
                if (localNode != null) {
                    if (localNode.masterNode() && !event.localNodeMaster()) {
                        cleanCache = true;
                    }
                } else {
                    cleanCache = true;
                }
                if (cleanCache) {
                    Releasables.close(GatewayAllocator.this.asyncFetchStarted.values());
                    GatewayAllocator.this.asyncFetchStarted.clear();
                    Releasables.close(GatewayAllocator.this.asyncFetchStore.values());
                    GatewayAllocator.this.asyncFetchStore.clear();
                }
            }
        });
    }

    public int getNumberOfInFlightFetch() {
        int count = 0;
        for (AsyncShardFetch fetch : this.asyncFetchStarted.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        for (AsyncShardFetch fetch : this.asyncFetchStore.values()) {
            count += fetch.getNumberOfInFlightFetches();
        }
        return count;
    }

    public void applyStartedShards(StartedRerouteAllocation allocation) {
        for (ShardRouting shardRouting : allocation.startedShards()) {
            Releasables.close((Releasable)this.asyncFetchStarted.remove(shardRouting.shardId()));
            Releasables.close((Releasable)this.asyncFetchStore.remove(shardRouting.shardId()));
        }
    }

    public void applyFailedShards(FailedRerouteAllocation allocation) {
        for (FailedRerouteAllocation.FailedShard shard : allocation.failedShards()) {
            Releasables.close((Releasable)this.asyncFetchStarted.remove(shard.shard.shardId()));
            Releasables.close((Releasable)this.asyncFetchStore.remove(shard.shard.shardId()));
        }
    }

    public boolean allocateUnassigned(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes.UnassignedShards unassigned = allocation.routingNodes().unassigned();
        unassigned.sort(PriorityComparator.getAllocationComparator(allocation));
        changed |= this.primaryShardAllocator.allocateUnassigned(allocation);
        changed |= this.replicaShardAllocator.processExistingRecoveries(allocation);
        return changed |= this.replicaShardAllocator.allocateUnassigned(allocation);
    }

    class InternalReplicaShardAllocator
    extends ReplicaShardAllocator {
        private final TransportNodesListShardStoreMetaData storeAction;

        public InternalReplicaShardAllocator(Settings settings, TransportNodesListShardStoreMetaData storeAction) {
            super(settings);
            this.storeAction = storeAction;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores;
            InternalAsyncFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetch = (InternalAsyncFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData>)GatewayAllocator.this.asyncFetchStore.get(shard.shardId());
            if (fetch == null) {
                fetch = new InternalAsyncFetch<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData>(this.logger, "shard_store", shard.shardId(), this.storeAction);
                GatewayAllocator.this.asyncFetchStore.put(shard.shardId(), fetch);
            }
            if ((shardStores = fetch.fetchData(allocation.nodes(), allocation.metaData(), allocation.getIgnoreNodes(shard.shardId()))).hasData()) {
                shardStores.processAllocation(allocation);
            }
            return shardStores;
        }
    }

    class InternalPrimaryShardAllocator
    extends PrimaryShardAllocator {
        private final TransportNodesListGatewayStartedShards startedAction;

        public InternalPrimaryShardAllocator(Settings settings, TransportNodesListGatewayStartedShards startedAction) {
            super(settings);
            this.startedAction = startedAction;
        }

        @Override
        protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting shard, RoutingAllocation allocation) {
            AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState;
            InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetch = (InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>)GatewayAllocator.this.asyncFetchStarted.get(shard.shardId());
            if (fetch == null) {
                fetch = new InternalAsyncFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards>(this.logger, "shard_started", shard.shardId(), this.startedAction);
                GatewayAllocator.this.asyncFetchStarted.put(shard.shardId(), fetch);
            }
            if ((shardState = fetch.fetchData(allocation.nodes(), allocation.metaData(), allocation.getIgnoreNodes(shard.shardId()))).hasData()) {
                shardState.processAllocation(allocation);
            }
            return shardState;
        }
    }

    class InternalAsyncFetch<T extends BaseNodeResponse>
    extends AsyncShardFetch<T> {
        public InternalAsyncFetch(ESLogger logger, String type, ShardId shardId, AsyncShardFetch.List<? extends BaseNodesResponse<T>, T> action) {
            super(logger, type, shardId, action);
        }

        @Override
        protected void reroute(ShardId shardId, String reason) {
            this.logger.trace("{} scheduling reroute for {}", shardId, reason);
            GatewayAllocator.this.routingService.reroute("async_shard_fetch");
        }
    }
}

