/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal.findbugs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsClasspathValidator {
    private final JavaVersion javaVersion;

    public FindBugsClasspathValidator(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void validateClasspath(Iterable<String> fileNamesOnClasspath) {
        boolean findbugs2orLess;
        boolean findbugs3orMore;
        VersionNumber v = this.getFindbugsVersion(fileNamesOnClasspath);
        boolean java6orLess = this.javaVersion.compareTo((Enum)JavaVersion.VERSION_1_7) < 0;
        boolean bl = findbugs3orMore = v.getMajor() > 2;
        if (java6orLess && findbugs3orMore) {
            throw new FindBugsVersionTooHighException("The version of FindBugs (" + v + ") inferred from FindBugs classpath is too high to work with currently used Java version (" + this.javaVersion + ")." + " Please use lower version of FindBugs or use newer version of Java. Inspected FindBugs classpath: " + fileNamesOnClasspath);
        }
        boolean java8orMore = this.javaVersion.compareTo((Enum)JavaVersion.VERSION_1_7) > 0;
        boolean bl2 = findbugs2orLess = v.getMajor() < 3;
        if (java8orMore && findbugs2orLess) {
            throw new FindBugsVersionTooLowException("The version of FindBugs (" + v + ") inferred from FindBugs classpath is too low to work with currently used Java version (" + this.javaVersion + ")." + " Please use higher version of FindBugs. Inspected FindBugs classpath: " + fileNamesOnClasspath);
        }
    }

    private VersionNumber getFindbugsVersion(Iterable<String> classpath) {
        for (String f : classpath) {
            Matcher m = Pattern.compile("findbugs-(.*)\\.jar").matcher(f);
            if (!m.matches()) continue;
            return VersionNumber.parse((String)m.group(1));
        }
        throw new GradleException("Unable to infer the version of FindBugs from currently specified FindBugs classpath: " + classpath);
    }

    static class FindBugsVersionTooHighException
    extends GradleException {
        FindBugsVersionTooHighException(String message) {
            super(message);
        }
    }

    static class FindBugsVersionTooLowException
    extends GradleException {
        FindBugsVersionTooLowException(String message) {
            super(message);
        }
    }
}

