/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal.findbugs;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsExecuter;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsResult;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsSpec;
import org.gradle.api.plugins.quality.internal.findbugs.FindBugsWorkerClientProtocol;
import org.gradle.process.internal.WorkerProcessContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsWorkerServer
implements Action<WorkerProcessContext>,
Serializable {
    private static final Logger LOGGER = Logging.getLogger(FindBugsWorkerServer.class);
    private FindBugsSpec spec;

    public FindBugsWorkerServer(FindBugsSpec spec) {
        this.spec = spec;
    }

    public void execute(WorkerProcessContext context) {
        FindBugsResult result = this.execute(new FindBugsExecuter());
        FindBugsWorkerClientProtocol clientProtocol = (FindBugsWorkerClientProtocol)context.getServerConnection().addOutgoing(FindBugsWorkerClientProtocol.class);
        context.getServerConnection().connect();
        clientProtocol.executed(result);
    }

    FindBugsResult execute(FindBugsExecuter executer) {
        LOGGER.debug("Executing FindBugs worker.");
        try {
            return executer.runFindbugs(this.spec);
        }
        catch (Throwable t) {
            LOGGER.warn("Exception occurred while running FindBugs.", t);
            return new FindBugsResult(0, 0, 1, t);
        }
    }
}

