/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.testkit.jarjar.org.gradle.initialization.BuildCancellationToken;
import org.gradle.testkit.jarjar.org.slf4j.Logger;
import org.gradle.testkit.jarjar.org.slf4j.LoggerFactory;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.internal.consumer.TestExecutionRequest;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonCancellableConsumerConnectionAdapter
implements ConsumerConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonCancellableConsumerConnectionAdapter.class);
    private final ConsumerConnection delegate;

    public NonCancellableConsumerConnectionAdapter(ConsumerConnection delegate) {
        this.delegate = delegate;
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        Runnable callback = this.handleCancellationPreOperation(operationParameters.getCancellationToken());
        try {
            T t = this.delegate.run(action, operationParameters);
            return t;
        }
        finally {
            this.handleCancellationPostOperation(operationParameters.getCancellationToken(), callback);
        }
    }

    @Override
    public void runTests(TestExecutionRequest testExecutionRequest, ConsumerOperationParameters operationParameters) {
        this.delegate.runTests(testExecutionRequest, operationParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(Class<T> type, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        Runnable callback = this.handleCancellationPreOperation(operationParameters.getCancellationToken());
        try {
            T t = this.delegate.run(type, operationParameters);
            return t;
        }
        finally {
            this.handleCancellationPostOperation(operationParameters.getCancellationToken(), callback);
        }
    }

    private Runnable handleCancellationPreOperation(BuildCancellationToken cancellationToken) {
        Runnable callback = new Runnable(){

            public void run() {
                LOGGER.info("Note: Version of Gradle provider does not support cancellation. Upgrade your Gradle build.");
            }
        };
        cancellationToken.addCallback(callback);
        return callback;
    }

    private void handleCancellationPostOperation(BuildCancellationToken cancellationToken, Runnable callback) {
        cancellationToken.removeCallback(callback);
    }
}

