/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.gradle.gradleplugin.foundation.favorites.FavoritesEditor;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;

public class SwingEditFavoriteInteraction
implements FavoritesEditor.EditFavoriteInteraction {
    private JDialog dialog;
    private JTextField fullCommandLineTextField;
    private JTextField displayNameTextField;
    private JCheckBox alwaysShowOutputCheckBox;
    private boolean saveResults;
    private SynchronizeType synchronizeType;
    private DocumentListener synchronizationDocumentListener;
    private KeyAdapter synchronizationKeyAdapter;

    public SwingEditFavoriteInteraction(Window parent, String title, SynchronizeType synchronizeType) {
        this.synchronizeType = synchronizeType;
        this.setupUI(parent, title);
    }

    private void setupUI(Window parent, String title) {
        this.dialog = Utility.createDialog(parent, title, true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SwingEditFavoriteInteraction.this.close(false);
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        this.dialog.getContentPane().add(panel);
        panel.add(this.createMainPanel(), "Center");
        panel.add(this.createButtonPanel(), "South");
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialog.pack();
    }

    private Component createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.fullCommandLineTextField = new JTextField();
        this.displayNameTextField = new JTextField();
        this.alwaysShowOutputCheckBox = new JCheckBox("Always Show Live Output");
        panel.add(Utility.addLeftJustifiedComponent(new JLabel("Command Line")));
        panel.add(Utility.addLeftJustifiedComponent(this.fullCommandLineTextField));
        panel.add(Box.createVerticalStrut(10));
        panel.add(Utility.addLeftJustifiedComponent(new JLabel("Display Name")));
        panel.add(Utility.addLeftJustifiedComponent(this.displayNameTextField));
        panel.add(Box.createVerticalStrut(10));
        panel.add(Utility.addLeftJustifiedComponent(this.alwaysShowOutputCheckBox));
        panel.add(Box.createVerticalGlue());
        this.synchronizationDocumentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SwingEditFavoriteInteraction.this.setDisplayNameTextToCommandLineText();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SwingEditFavoriteInteraction.this.setDisplayNameTextToCommandLineText();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SwingEditFavoriteInteraction.this.setDisplayNameTextToCommandLineText();
            }
        };
        this.synchronizationKeyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                SwingEditFavoriteInteraction.this.fullCommandLineTextField.getDocument().removeDocumentListener(SwingEditFavoriteInteraction.this.synchronizationDocumentListener);
                SwingEditFavoriteInteraction.this.displayNameTextField.removeKeyListener(SwingEditFavoriteInteraction.this.synchronizationKeyAdapter);
            }
        };
        return panel;
    }

    private void synchronizeDisplayNameWithCommand(FavoritesEditor.EditibleFavoriteTask favoriteTask) {
        if (this.synchronizeType == SynchronizeType.Never || !favoriteTask.isDisplayNameAndFullCommandSynchronized()) {
            this.fullCommandLineTextField.getDocument().removeDocumentListener(this.synchronizationDocumentListener);
            this.displayNameTextField.removeKeyListener(this.synchronizationKeyAdapter);
        } else {
            this.fullCommandLineTextField.getDocument().addDocumentListener(this.synchronizationDocumentListener);
            this.displayNameTextField.addKeyListener(this.synchronizationKeyAdapter);
        }
    }

    private void setDisplayNameTextToCommandLineText() {
        try {
            String text = this.fullCommandLineTextField.getDocument().getText(0, this.fullCommandLineTextField.getDocument().getLength());
            this.displayNameTextField.setText(text);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private Component createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JButton okButton = new JButton(new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                SwingEditFavoriteInteraction.this.close(true);
            }
        });
        this.dialog.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                SwingEditFavoriteInteraction.this.close(false);
            }
        });
        this.dialog.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingEditFavoriteInteraction.this.close(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        panel.add(Box.createHorizontalGlue());
        panel.add(okButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(cancelButton);
        panel.add(Box.createHorizontalGlue());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        return panel;
    }

    private void close(boolean saveResults) {
        this.saveResults = saveResults;
        this.dialog.setVisible(false);
    }

    public boolean editFavorite(FavoritesEditor.EditibleFavoriteTask favoriteTask) {
        this.saveResults = false;
        this.fullCommandLineTextField.setText(favoriteTask.fullCommandLine);
        this.displayNameTextField.setText(favoriteTask.displayName);
        this.alwaysShowOutputCheckBox.setSelected(favoriteTask.alwaysShowOutput);
        this.synchronizeDisplayNameWithCommand(favoriteTask);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
        this.dialog.setVisible(true);
        if (this.saveResults) {
            favoriteTask.fullCommandLine = this.fullCommandLineTextField.getText();
            favoriteTask.displayName = this.displayNameTextField.getText();
            favoriteTask.alwaysShowOutput = this.alwaysShowOutputCheckBox.isSelected();
        }
        return this.saveResults;
    }

    public void reportError(String error) {
        if (this.dialog.isVisible()) {
            JOptionPane.showMessageDialog(this.dialog, error);
        } else {
            JOptionPane.showMessageDialog(this.dialog.getParent(), error);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SynchronizeType {
        OnlyIfAlreadySynchronized,
        Never;

    }
}

