/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.DiscoveredInputsListener;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.file.FileCollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveredInputsTaskStateChanges
extends AbstractFileSnapshotTaskStateChanges
implements DiscoveredInputsListener {
    private final FileCollectionSnapshotter snapshotter;
    private final FileCollectionFactory fileCollectionFactory;
    private final TaskExecution previous;
    private final TaskExecution current;
    private Collection<File> discoveredFiles = Collections.emptySet();

    public DiscoveredInputsTaskStateChanges(TaskExecution previous, TaskExecution current, FileCollectionSnapshotter snapshotter, FileCollectionFactory fileCollectionFactory, TaskInternal task) {
        super(task.getName());
        this.snapshotter = snapshotter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.previous = previous;
        this.current = current;
    }

    @Override
    public FileCollectionSnapshot getPrevious() {
        return this.previous.getDiscoveredInputFilesSnapshot();
    }

    @Override
    public FileCollectionSnapshot getCurrent() {
        return this.createSnapshot(this.snapshotter, this.fileCollectionFactory.fixed("Discovered input files", this.getPrevious().getFiles()));
    }

    @Override
    public void saveCurrent() {
        FileCollectionSnapshot discoveredFilesSnapshot = this.createSnapshot(this.snapshotter, this.fileCollectionFactory.fixed("Discovered input files", this.discoveredFiles));
        this.current.setDiscoveredInputFilesSnapshot(discoveredFilesSnapshot);
    }

    @Override
    public void newInputs(Set<File> files) {
        this.discoveredFiles = files;
    }

    @Override
    protected String getInputFileType() {
        return "Discovered input";
    }
}

