/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.component.internal;

import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.component.internal.AbstractComponentSpec;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentSpec
extends AbstractComponentSpec {
    private static ThreadLocal<ComponentInfo> nextComponentInfo = new ThreadLocal();

    public static <T extends DefaultComponentSpec> T create(Class<? extends ComponentSpec> publicType, Class<T> implementationType, ComponentSpecIdentifier identifier, MutableModelNode modelNode) {
        nextComponentInfo.set(new ComponentInfo(identifier, modelNode, publicType));
        try {
            DefaultComponentSpec defaultComponentSpec = (DefaultComponentSpec)DirectInstantiator.INSTANCE.newInstance(implementationType, new Object[0]);
            return (T)defaultComponentSpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create component of type %s", publicType.getSimpleName()), e.getCause());
        }
        finally {
            nextComponentInfo.set(null);
        }
    }

    protected static ComponentInfo getInfo() {
        return nextComponentInfo.get();
    }

    public DefaultComponentSpec() {
        this(DefaultComponentSpec.getInfo());
    }

    public DefaultComponentSpec(ComponentInfo info) {
        super(DefaultComponentSpec.validate((ComponentInfo)info).componentIdentifier, info.publicType);
    }

    private static ComponentInfo validate(ComponentInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseComponentSpec is not permitted. Use a @ComponentType rule instead.");
        }
        return info;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ComponentInfo {
        public final ComponentSpecIdentifier componentIdentifier;
        public final MutableModelNode modelNode;
        public final Class<?> publicType;

        private ComponentInfo(ComponentSpecIdentifier componentIdentifier, MutableModelNode modelNode, Class<?> publicType) {
            this.componentIdentifier = componentIdentifier;
            this.modelNode = modelNode;
            this.publicType = publicType;
        }
    }
}

