/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.io.BufferedWriter;
import java.io.File;
import java.util.Collections;
import org.apache.tools.ant.taskdefs.Chmod;
import org.gradle.api.Action;
import org.gradle.api.internal.plugins.DefaultJavaAppStartScriptGenerationDetails;
import org.gradle.api.internal.plugins.UnixStartScriptGenerator;
import org.gradle.api.internal.plugins.WindowsStartScriptGenerator;
import org.gradle.internal.IoActions;
import org.gradle.jvm.application.scripts.JavaAppStartScriptGenerationDetails;
import org.gradle.jvm.application.scripts.ScriptGenerator;
import org.gradle.util.AntUtil;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartScriptGenerator {
    private String applicationName;
    private String optsEnvironmentVar;
    private String exitEnvironmentVar;
    private String mainClassName;
    private Iterable<String> defaultJvmOpts = Collections.emptyList();
    private Iterable<String> classpath;
    private String scriptRelPath;
    private String appNameSystemProperty;
    private final ScriptGenerator unixStartScriptGenerator;
    private final ScriptGenerator windowsStartScriptGenerator;
    private final UnixFileOperation unixFileOperation;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setOptsEnvironmentVar(String optsEnvironmentVar) {
        this.optsEnvironmentVar = optsEnvironmentVar;
    }

    public void setExitEnvironmentVar(String exitEnvironmentVar) {
        this.exitEnvironmentVar = exitEnvironmentVar;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public void setDefaultJvmOpts(Iterable<String> defaultJvmOpts) {
        this.defaultJvmOpts = defaultJvmOpts;
    }

    public void setClasspath(Iterable<String> classpath) {
        this.classpath = classpath;
    }

    public void setScriptRelPath(String scriptRelPath) {
        this.scriptRelPath = scriptRelPath;
    }

    public void setAppNameSystemProperty(String appNameSystemProperty) {
        this.appNameSystemProperty = appNameSystemProperty;
    }

    public StartScriptGenerator() {
        this(new UnixStartScriptGenerator(), new WindowsStartScriptGenerator());
    }

    public StartScriptGenerator(ScriptGenerator unixStartScriptGenerator, ScriptGenerator windowsStartScriptGenerator) {
        this(unixStartScriptGenerator, windowsStartScriptGenerator, new AntUnixFileOperation());
    }

    StartScriptGenerator(ScriptGenerator unixStartScriptGenerator, ScriptGenerator windowsStartScriptGenerator, UnixFileOperation unixFileOperation) {
        this.unixStartScriptGenerator = unixStartScriptGenerator;
        this.windowsStartScriptGenerator = windowsStartScriptGenerator;
        this.unixFileOperation = unixFileOperation;
    }

    private JavaAppStartScriptGenerationDetails createStartScriptGenerationDetails() {
        return new DefaultJavaAppStartScriptGenerationDetails(this.applicationName, this.optsEnvironmentVar, this.exitEnvironmentVar, this.mainClassName, CollectionUtils.toStringList(this.defaultJvmOpts), CollectionUtils.toStringList(this.classpath), this.scriptRelPath, this.appNameSystemProperty);
    }

    public void generateUnixScript(File unixScript) {
        IoActions.writeTextFile((File)unixScript, (Action)new Generate(this.createStartScriptGenerationDetails(), this.unixStartScriptGenerator));
        this.unixFileOperation.createExecutablePermission(unixScript);
    }

    public void generateWindowsScript(File windowsScript) {
        IoActions.writeTextFile((File)windowsScript, (Action)new Generate(this.createStartScriptGenerationDetails(), this.windowsStartScriptGenerator));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Generate
    implements Action<BufferedWriter> {
        private final JavaAppStartScriptGenerationDetails startScriptGenerationDetails;
        private final ScriptGenerator unixStartScriptGenerator;

        public Generate(JavaAppStartScriptGenerationDetails startScriptGenerationDetails, ScriptGenerator unixStartScriptGenerator) {
            this.startScriptGenerationDetails = startScriptGenerationDetails;
            this.unixStartScriptGenerator = unixStartScriptGenerator;
        }

        public void execute(BufferedWriter writer) {
            this.unixStartScriptGenerator.generateScript(this.startScriptGenerationDetails, writer);
        }
    }

    static class AntUnixFileOperation
    implements UnixFileOperation {
        AntUnixFileOperation() {
        }

        public void createExecutablePermission(File file) {
            Chmod chmod = new Chmod();
            chmod.setFile(file);
            chmod.setPerm("ugo+rx");
            chmod.setProject(AntUtil.createProject());
            chmod.execute();
        }
    }

    static interface UnixFileOperation {
        public void createExecutablePermission(File var1);
    }
}

