/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.launcher.daemon.configuration.GradleProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesToStartParameterConverter {
    public StartParameter convert(Map<String, String> properties, StartParameter startParameter) {
        String workers;
        startParameter.setConfigureOnDemand(GradleProperties.isTrue(properties.get("org.gradle.configureondemand")));
        String parallel = properties.get("org.gradle.parallel");
        if (GradleProperties.isTrue(parallel)) {
            startParameter.setParallelProjectExecutionEnabled(true);
        }
        if ((workers = properties.get("org.gradle.workers.max")) != null) {
            try {
                int workerCount = Integer.parseInt(workers);
                if (workerCount < 1) {
                    this.invalidMaxWorkersPropValue(workers);
                }
                startParameter.setMaxWorkerCount(workerCount);
            }
            catch (NumberFormatException e) {
                this.invalidMaxWorkersPropValue(workers);
            }
        }
        return startParameter;
    }

    private StartParameter invalidMaxWorkersPropValue(String value) {
        throw new IllegalArgumentException(String.format("Value '%s' given for %s system property is invalid (must be a positive, non-zero, integer)", value, "org.gradle.workers.max"));
    }
}

