/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraphPathResolver {
    public static Collection<List<ModuleVersionIdentifier>> calculatePaths(List<DependencyGraphNode> fromNodes, DependencyGraphNode toNode) {
        LinkedHashMap shortestPaths = new LinkedHashMap();
        ArrayList<ModuleVersionIdentifier> rootPath = new ArrayList<ModuleVersionIdentifier>();
        rootPath.add(toNode.toId());
        shortestPaths.put(toNode.getSelection(), rootPath);
        LinkedHashSet<DependencyGraphBuilder.ModuleVersionResolveState> directDependees = new LinkedHashSet<DependencyGraphBuilder.ModuleVersionResolveState>();
        for (DependencyGraphNode node : fromNodes) {
            DependencyGraphBuilder.ConfigurationNode rawNode = (DependencyGraphBuilder.ConfigurationNode)node;
            directDependees.add(rawNode.moduleRevision);
        }
        HashSet<DependencyGraphBuilder.ModuleVersionResolveState> seen = new HashSet<DependencyGraphBuilder.ModuleVersionResolveState>();
        LinkedList<DependencyGraphBuilder.ModuleVersionResolveState> queue = new LinkedList<DependencyGraphBuilder.ModuleVersionResolveState>();
        queue.addAll(directDependees);
        while (!queue.isEmpty()) {
            DependencyGraphBuilder.ModuleVersionResolveState version = (DependencyGraphBuilder.ModuleVersionResolveState)queue.getFirst();
            if (version == toNode.getSelection()) {
                queue.removeFirst();
                continue;
            }
            if (seen.add(version)) {
                for (DependencyGraphBuilder.ModuleVersionResolveState incomingVersion : version.getIncoming()) {
                    queue.add(0, incomingVersion);
                }
                continue;
            }
            queue.remove();
            List shortest = null;
            for (DependencyGraphBuilder.ModuleVersionResolveState incomingVersion : version.getIncoming()) {
                List candidate = (List)shortestPaths.get(incomingVersion);
                if (candidate == null) continue;
                if (shortest == null) {
                    shortest = candidate;
                    continue;
                }
                if (shortest.size() <= candidate.size()) continue;
                shortest = candidate;
            }
            if (shortest == null) continue;
            ArrayList<ModuleVersionIdentifier> path = new ArrayList<ModuleVersionIdentifier>();
            path.addAll(shortest);
            path.add(version.id);
            shortestPaths.put(version, path);
        }
        ArrayList<List<ModuleVersionIdentifier>> paths = new ArrayList<List<ModuleVersionIdentifier>>();
        for (DependencyGraphBuilder.ModuleVersionResolveState version : directDependees) {
            List path = (List)shortestPaths.get(version);
            paths.add(path);
        }
        return paths;
    }
}

