/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.format;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.format.Layout;
import ch.ehi.umleditor.format.TestLayoutPane;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import ch.ehi.umleditor.umlpresentation.Diagram;
import ch.ehi.umleditor.umlpresentation.PresentationEdge;
import ch.ehi.umleditor.umlpresentation.PresentationNode;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class TestLayoutDialog
extends JDialog {
    private TestLayoutPane view;
    private JButton okBtn = null;
    private JButton cancelBtn = null;
    private Layout model = null;

    public TestLayoutDialog(Frame parent) {
        super(parent, true);
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        this.view = new TestLayoutPane();
        pane.add(this.view);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createHorizontalGlue());
        this.okBtn = new JButton("Layout");
        buttonPane.add(this.okBtn);
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestLayoutDialog.this.onOk();
            }
        });
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        this.cancelBtn = new JButton("Close");
        buttonPane.add(this.cancelBtn);
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestLayoutDialog.this.onCancel();
            }
        });
        pane.add(buttonPane);
        Container contentPane = this.getContentPane();
        contentPane.add(pane);
    }

    public void showDialog() {
        this.model = new Layout();
        this.view.setModel(this.model);
        this.pack();
        this.show();
    }

    public void onOk() {
        this.view.updateModel();
        Vector edgev = new Vector(30);
        Vector nodev = new Vector(30);
        ClassDiagramView diagView = LauncherView.getInstance().getCurrentClassDiagram();
        if (diagView != null) {
            EhiLogger.traceState("current ClassDiagramView found");
            Diagram diag = diagView.getDiagram();
            Iterator elei = diag.iteratorPresentationElement();
            while (elei.hasNext()) {
                Object obj = elei.next();
                if (obj instanceof PresentationEdge) {
                    edgev.add(obj);
                    continue;
                }
                if (!(obj instanceof PresentationNode)) continue;
                nodev.add(obj);
            }
            Layout.layout(nodev, edgev, 0.0, 0.0, 800.0, 800.0);
            diagView.refresh();
        }
    }

    public void onCancel() {
        this.dispose();
    }
}

