/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.util.Locale;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import org.GNOME.Accessibility.Accessible;
import org.GNOME.Accessibility.AccessibleOperations;
import org.GNOME.Accessibility.AccessiblePOATie;
import org.GNOME.Accessibility.ActionImpl;
import org.GNOME.Accessibility.Application;
import org.GNOME.Accessibility.ComponentImpl;
import org.GNOME.Accessibility.EditableTextImpl;
import org.GNOME.Accessibility.HypertextImpl;
import org.GNOME.Accessibility.ImageImpl;
import org.GNOME.Accessibility.JavaBridge;
import org.GNOME.Accessibility.Relation;
import org.GNOME.Accessibility.RelationHelper;
import org.GNOME.Accessibility.RelationImpl;
import org.GNOME.Accessibility.Role;
import org.GNOME.Accessibility.SelectionImpl;
import org.GNOME.Accessibility.StateSet;
import org.GNOME.Accessibility.StateSetHelper;
import org.GNOME.Accessibility.StateSetImpl;
import org.GNOME.Accessibility.TableImpl;
import org.GNOME.Accessibility.TextImpl;
import org.GNOME.Accessibility.ValueImpl;
import org.GNOME.Bonobo.UnknownImpl;

public class AccessibleImpl
extends UnknownImpl
implements AccessibleOperations {
    protected AccessibleContext ac;

    public AccessibleImpl(AccessibleContext accessibleContext) {
        this();
        this.ac = accessibleContext;
        this.ac.addPropertyChangeListener(JavaBridge.getGlobalPropertyChangeListener());
        this.poa = JavaBridge.getRootPOA();
        this.tie = new AccessiblePOATie(this, JavaBridge.getRootPOA());
        this.aggregate_interfaces();
        try {
            JavaBridge.getRootPOA().activate_object(this.tie);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public AccessibleImpl() {
    }

    private void aggregate_interfaces() {
        if (this.ac != null) {
            AccessibleText accessibleText;
            UnknownImpl unknownImpl;
            if (this.ac.getAccessibleAction() != null) {
                unknownImpl = new ActionImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleComponent() != null) {
                unknownImpl = new ComponentImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if ((accessibleText = this.ac.getAccessibleText()) != null) {
                if (this.ac.getAccessibleEditableText() != null) {
                    unknownImpl = new EditableTextImpl(this.ac);
                    this.add_interface(unknownImpl);
                }
                unknownImpl = new TextImpl(this.ac);
                this.add_interface(unknownImpl);
                if (accessibleText instanceof AccessibleHypertext) {
                    unknownImpl = new HypertextImpl(this.ac);
                    this.add_interface(unknownImpl);
                }
            }
            if (this.ac.getAccessibleIcon() != null) {
                unknownImpl = new ImageImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleSelection() != null) {
                unknownImpl = new SelectionImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleTable() != null) {
                unknownImpl = new TableImpl(this.ac);
                this.add_interface(unknownImpl);
            }
            if (this.ac.getAccessibleValue() != null) {
                unknownImpl = new ValueImpl(this.ac);
                this.add_interface(unknownImpl);
            }
        }
    }

    @Override
    public void name(String string) {
        if (this.ac != null) {
            this.ac.setAccessibleName(string);
        }
    }

    @Override
    public String name() {
        javax.accessibility.Accessible accessible;
        AccessibleSelection accessibleSelection;
        AccessibleRole accessibleRole;
        String string = null;
        if (this.ac != null && (accessibleRole = this.ac.getAccessibleRole()) == AccessibleRole.COMBO_BOX && this.ac.getAccessibleChildrenCount() == 1 && (accessibleSelection = this.ac.getAccessibleSelection()) != null && (accessible = accessibleSelection.getAccessibleSelection(0)) != null) {
            string = accessible.getAccessibleContext().getAccessibleName();
        }
        if (string == null) {
            string = this.ac.getAccessibleName();
        }
        return string != null ? string : "";
    }

    @Override
    public Accessible parent() {
        javax.accessibility.Accessible accessible;
        Accessible accessible2 = null;
        if (this.ac != null && (accessible = this.ac.getAccessibleParent()) != null) {
            accessible2 = JavaBridge.getAccessibleObjectFactory().getAccessible(accessible.getAccessibleContext());
        }
        return accessible2;
    }

    @Override
    public void description(String string) {
        if (this.ac != null) {
            this.ac.setAccessibleDescription(string);
        }
    }

    @Override
    public String description() {
        String string = null;
        if (this.ac != null) {
            string = this.ac.getAccessibleDescription();
        }
        return string != null ? string : "";
    }

    @Override
    public int childCount() {
        int n = 0;
        if (this.ac != null) {
            n = this.ac.getAccessibleChildrenCount();
        }
        return n;
    }

    @Override
    public boolean isEqual(Accessible accessible) {
        if (this.ac == null || accessible == null) {
            return false;
        }
        return accessible._is_equivalent(this.tie());
    }

    @Override
    public Accessible getChildAtIndex(int n) {
        javax.accessibility.Accessible accessible;
        Accessible accessible2 = null;
        if (this.ac != null && this.ac.getAccessibleChildrenCount() > n && (accessible = this.ac.getAccessibleChild(n)) != null) {
            accessible2 = JavaBridge.getAccessibleObjectFactory().getAccessible(accessible.getAccessibleContext());
        }
        return accessible2;
    }

    @Override
    public int getIndexInParent() {
        int n = -1;
        if (this.ac != null) {
            n = this.ac.getAccessibleIndexInParent();
        }
        return n;
    }

    @Override
    public Relation[] getRelationSet() {
        AccessibleRelationSet accessibleRelationSet;
        Relation[] relationArray = new Relation[]{null};
        if (this.ac != null && (accessibleRelationSet = this.ac.getAccessibleRelationSet()) != null) {
            AccessibleRelation[] accessibleRelationArray = accessibleRelationSet.toArray();
            relationArray = new Relation[accessibleRelationArray.length];
            for (int i = 0; i < accessibleRelationArray.length; ++i) {
                RelationImpl relationImpl = new RelationImpl(accessibleRelationArray[i]);
                Relation relation = null;
                try {
                    relation = RelationHelper.narrow(relationImpl.tie());
                }
                catch (Exception exception) {
                    System.out.println("Error getting relation:" + exception);
                }
                relationArray[i] = relation;
            }
        }
        return relationArray;
    }

    @Override
    public Role getRole() {
        Role role = Role.ROLE_INVALID;
        if (this.ac != null) {
            javax.accessibility.Accessible accessible;
            javax.accessibility.Accessible accessible2;
            AccessibleRole accessibleRole;
            AccessibleRole accessibleRole2 = this.ac.getAccessibleRole();
            role = accessibleRole2 == AccessibleRole.ALERT ? Role.ROLE_ALERT : (accessibleRole2 == AccessibleRole.AWT_COMPONENT ? Role.ROLE_UNKNOWN : (accessibleRole2 == AccessibleRole.CANVAS ? Role.ROLE_CANVAS : (accessibleRole2 == AccessibleRole.CHECK_BOX ? Role.ROLE_CHECK_BOX : (accessibleRole2 == AccessibleRole.COLOR_CHOOSER ? Role.ROLE_COLOR_CHOOSER : (accessibleRole2 == AccessibleRole.COLUMN_HEADER ? Role.ROLE_COLUMN_HEADER : (accessibleRole2 == AccessibleRole.COMBO_BOX ? Role.ROLE_COMBO_BOX : (accessibleRole2 == AccessibleRole.DATE_EDITOR ? Role.ROLE_DATE_EDITOR : (accessibleRole2 == AccessibleRole.DESKTOP_ICON ? Role.ROLE_DESKTOP_ICON : (accessibleRole2 == AccessibleRole.DESKTOP_PANE ? Role.ROLE_LAYERED_PANE : (accessibleRole2 == AccessibleRole.DIALOG ? Role.ROLE_DIALOG : (accessibleRole2 == AccessibleRole.DIRECTORY_PANE ? Role.ROLE_DIRECTORY_PANE : (accessibleRole2 == AccessibleRole.FILE_CHOOSER ? Role.ROLE_FILE_CHOOSER : (accessibleRole2 == AccessibleRole.FILLER ? Role.ROLE_FILLER : (accessibleRole2 == AccessibleRole.FONT_CHOOSER ? Role.ROLE_FONT_CHOOSER : (accessibleRole2 == AccessibleRole.FRAME ? Role.ROLE_FRAME : (accessibleRole2 == AccessibleRole.GLASS_PANE ? Role.ROLE_GLASS_PANE : (accessibleRole2 == AccessibleRole.GROUP_BOX ? Role.ROLE_PANEL : (accessibleRole2 == AccessibleRole.HYPERLINK ? Role.ROLE_UNKNOWN : (accessibleRole2 == AccessibleRole.ICON ? Role.ROLE_ICON : (accessibleRole2 == AccessibleRole.INTERNAL_FRAME ? Role.ROLE_INTERNAL_FRAME : (accessibleRole2 == AccessibleRole.LABEL ? Role.ROLE_LABEL : (accessibleRole2 == AccessibleRole.LAYERED_PANE ? Role.ROLE_LAYERED_PANE : (accessibleRole2 == AccessibleRole.LIST ? Role.ROLE_LIST : (accessibleRole2 == AccessibleRole.LIST_ITEM ? Role.ROLE_LIST_ITEM : (accessibleRole2 == AccessibleRole.MENU ? Role.ROLE_MENU : (accessibleRole2 == AccessibleRole.MENU_BAR ? Role.ROLE_MENU_BAR : (accessibleRole2 == AccessibleRole.MENU_ITEM ? Role.ROLE_MENU_ITEM : (accessibleRole2 == AccessibleRole.OPTION_PANE ? Role.ROLE_OPTION_PANE : (accessibleRole2 == AccessibleRole.PAGE_TAB ? Role.ROLE_PAGE_TAB : (accessibleRole2 == AccessibleRole.PAGE_TAB_LIST ? Role.ROLE_PAGE_TAB_LIST : (accessibleRole2 == AccessibleRole.PANEL ? Role.ROLE_PANEL : (accessibleRole2 == AccessibleRole.PASSWORD_TEXT ? Role.ROLE_PASSWORD_TEXT : (accessibleRole2 == AccessibleRole.POPUP_MENU ? Role.ROLE_POPUP_MENU : (accessibleRole2 == AccessibleRole.PROGRESS_BAR ? Role.ROLE_PROGRESS_BAR : (accessibleRole2 == AccessibleRole.PUSH_BUTTON ? Role.ROLE_PUSH_BUTTON : (accessibleRole2 == AccessibleRole.RADIO_BUTTON ? ((accessibleRole = (accessible2 = this.ac.getAccessibleParent()).getAccessibleContext().getAccessibleRole()) == AccessibleRole.MENU ? Role.ROLE_RADIO_MENU_ITEM : Role.ROLE_RADIO_BUTTON) : (accessibleRole2 == AccessibleRole.ROOT_PANE ? Role.ROLE_ROOT_PANE : (accessibleRole2 == AccessibleRole.ROW_HEADER ? Role.ROLE_ROW_HEADER : (accessibleRole2 == AccessibleRole.SCROLL_BAR ? Role.ROLE_SCROLL_BAR : (accessibleRole2 == AccessibleRole.SCROLL_PANE ? Role.ROLE_SCROLL_PANE : (accessibleRole2 == AccessibleRole.SEPARATOR ? Role.ROLE_SEPARATOR : (accessibleRole2 == AccessibleRole.SLIDER ? Role.ROLE_SLIDER : (accessibleRole2 == AccessibleRole.SPIN_BOX ? Role.ROLE_SPIN_BUTTON : (accessibleRole2 == AccessibleRole.SPLIT_PANE ? Role.ROLE_SPLIT_PANE : (accessibleRole2 == AccessibleRole.STATUS_BAR ? Role.ROLE_STATUS_BAR : (accessibleRole2 == AccessibleRole.SWING_COMPONENT ? Role.ROLE_UNKNOWN : (accessibleRole2 == AccessibleRole.TABLE ? Role.ROLE_TABLE : (accessibleRole2 == AccessibleRole.TEXT ? Role.ROLE_TEXT : (accessibleRole2 == AccessibleRole.TOGGLE_BUTTON ? Role.ROLE_TOGGLE_BUTTON : (accessibleRole2 == AccessibleRole.TOOL_BAR ? Role.ROLE_TOOL_BAR : (accessibleRole2 == AccessibleRole.TOOL_TIP ? Role.ROLE_TOOL_TIP : (accessibleRole2 == AccessibleRole.TREE ? Role.ROLE_TREE : (accessibleRole2 == AccessibleRole.UNKNOWN ? ((accessible = this.ac.getAccessibleParent()) == null ? Role.ROLE_APPLICATION : Role.ROLE_UNKNOWN) : (accessibleRole2 == AccessibleRole.VIEWPORT ? Role.ROLE_VIEWPORT : (accessibleRole2 == AccessibleRole.WINDOW ? Role.ROLE_WINDOW : (accessibleRole2.toDisplayString(Locale.US).equalsIgnoreCase("paragraph") ? Role.ROLE_PARAGRAPH : Role.ROLE_EXTENDED))))))))))))))))))))))))))))))))))))))))))))))))))))))));
        }
        return role;
    }

    @Override
    public String getRoleName() {
        if (this.ac != null) {
            javax.accessibility.Accessible accessible;
            AccessibleRole accessibleRole = this.ac.getAccessibleRole();
            if (accessibleRole == AccessibleRole.UNKNOWN && (accessible = this.ac.getAccessibleParent()) == null) {
                return "application";
            }
            if (accessibleRole != null) {
                return accessibleRole.toDisplayString(Locale.US);
            }
        }
        return "";
    }

    @Override
    public StateSet getState() {
        StateSet stateSet = null;
        if (this.ac != null) {
            AccessibleStateSet accessibleStateSet = this.ac.getAccessibleStateSet();
            AccessibleContext accessibleContext = JavaBridge.getFocusContext();
            if (this.ac == accessibleContext) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            StateSetImpl stateSetImpl = new StateSetImpl(accessibleStateSet);
            stateSet = StateSetHelper.narrow(stateSetImpl.tie());
        }
        return stateSet;
    }

    @Override
    public String getLocalizedRoleName() {
        if (this.ac != null) {
            javax.accessibility.Accessible accessible;
            AccessibleRole accessibleRole = this.ac.getAccessibleRole();
            if (accessibleRole == AccessibleRole.UNKNOWN && (accessible = this.ac.getAccessibleParent()) == null) {
                return "application";
            }
            if (accessibleRole != null) {
                return accessibleRole.toString();
            }
        }
        return "";
    }

    @Override
    public String[] getAttributes() {
        return new String[0];
    }

    @Override
    public Application getApplication() {
        return null;
    }

    @Override
    public void unimplemented() {
    }
}

