/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.HasContext;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponseContentListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.LoggingTaskListener;
import org.elasticsearch.tasks.Task;

public abstract class AbstractBaseReindexRestHandler<Request extends ActionRequest<Request>, Response extends BulkIndexByScrollResponse, TA extends TransportAction<Request, Response>>
extends BaseRestHandler {
    private final ClusterService clusterService;
    private final RestController controller;
    private final TA action;

    protected AbstractBaseReindexRestHandler(Settings settings, RestController controller, Client client, ClusterService clusterService, TA action) {
        super(settings, controller, client);
        this.clusterService = clusterService;
        this.controller = controller;
        this.action = action;
    }

    protected void execute(RestRequest request, Request internalRequest, RestChannel channel) throws IOException {
        for (String usefulHeader : this.controller.relevantHeaders()) {
            String headerValue = request.header(usefulHeader);
            if (headerValue == null) continue;
            internalRequest.putHeader(usefulHeader, (Object)headerValue);
        }
        internalRequest.copyContextFrom((HasContext)request);
        if (request.paramAsBoolean("wait_for_completion", true)) {
            this.action.execute(internalRequest, new BulkIndexByScrollResponseContentListener(channel));
            return;
        }
        ActionRequestValidationException validationException = internalRequest.validate();
        if (validationException != null) {
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Throwable)validationException));
            return;
        }
        Task task = this.action.execute(internalRequest, LoggingTaskListener.instance());
        this.sendTask(channel, task);
    }

    private void sendTask(RestChannel channel, Task task) throws IOException {
        XContentBuilder builder = channel.newBuilder();
        builder.startObject();
        builder.field("task", this.clusterService.localNode().getId() + ":" + task.getId());
        builder.endObject();
        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
    }
}

